/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.OverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class AttributeOverrideMetadata
extends OverrideMetadata {
    private ColumnMetadata m_column;

    public AttributeOverrideMetadata() {
        super("<attribute-override>");
    }

    public AttributeOverrideMetadata(MetadataAnnotation attributeOverride, MetadataAccessor accessor) {
        super(attributeOverride, accessor);
        this.m_column = new ColumnMetadata((MetadataAnnotation)attributeOverride.getAttribute("column"), accessor);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof AttributeOverrideMetadata) {
            return this.valuesMatch(this.m_column, ((AttributeOverrideMetadata)objectToCompare).getColumn());
        }
        return false;
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    @Override
    public String getIgnoreMappedSuperclassContext() {
        return "metadata_warning_ignore_mapped_superclass_attribute_override";
    }

    public DatabaseField getOverrideField() {
        return this.m_column.getDatabaseField();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_column, accessibleObject);
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }
}

