/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWOXQueryManager;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWQueryManager
extends MWModel {
    private Collection queries;
    public static final String QUERY_COLLECTION = "queries";
    private volatile Integer queryTimeout;
    public static final String QUERY_TIMEOUT_PROPERTY = "queryTimeout";
    public static final Integer DEFAULT_QUERY_TIMEOUT = new Integer(-1);
    public static final Integer QUERY_TIMEOUT_NO_TIMEOUT = new Integer(0);
    public static final Integer QUERY_TIMEOUT_TIMEOUT = new Integer(1);

    protected MWQueryManager() {
    }

    protected MWQueryManager(MWAbstractTransactionalPolicy descriptor) {
        super(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.queries;
        synchronized (collection) {
            children.addAll(this.queries);
        }
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.queries = new Vector();
        this.queryTimeout = DEFAULT_QUERY_TIMEOUT;
    }

    public MWMappingDescriptor getOwningDescriptor() {
        return (MWMappingDescriptor)((MWTransactionalPolicy)this.getParent()).getParent();
    }

    private void adjustParametersForToplinkReservedFinder(MWQuery query) {
        MWClass objectClass = this.typeFor(Object.class);
        MWClass stringClass = this.typeFor(String.class);
        MWClass vectorClass = this.typeFor(Vector.class);
        if (query.getName().equals("findByPrimaryKey")) {
            query.addParameter(objectClass).setName("primaryKey");
        } else if (!query.getName().equals("findAll")) {
            if (query.getName().equals("findOneBySql")) {
                query.addParameter(stringClass).setName("1");
                query.addParameter(vectorClass).setName("2");
            } else if (query.getName().equals("findManyBySql")) {
                query.addParameter(stringClass).setName("1");
                query.addParameter(vectorClass).setName("2");
            } else if (query.getName().equals("findOneByEjbql")) {
                query.addParameter(stringClass).setName("1");
                query.addParameter(vectorClass).setName("2");
            } else if (query.getName().equals("findManyByEjbql")) {
                query.addParameter(stringClass).setName("1");
                query.addParameter(vectorClass).setName("2");
            } else if (query.getName().equals("findOneByQuery")) {
                query.addParameter(this.typeFor(ReadObjectQuery.class)).setName("1");
                query.addParameter(vectorClass).setName("2");
            } else if (query.getName().equals("findManyByQuery")) {
                query.addParameter(this.typeFor(ReadAllQuery.class)).setName("1");
                query.addParameter(vectorClass).setName("2");
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public MWReadObjectQuery addReadObjectQuery(String queryName) {
        return (MWReadObjectQuery)this.addQuery(this.buildReadObjectQuery(queryName));
    }

    public MWReadAllQuery addReadAllQuery(String queryName) {
        return (MWReadAllQuery)this.addQuery(this.buildReadAllQuery(queryName));
    }

    public abstract boolean supportsReportQueries();

    public abstract MWReadObjectQuery buildReadObjectQuery(String var1);

    public abstract MWReadAllQuery buildReadAllQuery(String var1);

    protected MWQuery addQuery(MWQuery query) {
        this.queries.add(query);
        this.fireItemAdded(QUERY_COLLECTION, query);
        return query;
    }

    public void removeQuery(MWQuery query) {
        this.removeItemFromCollection(query, this.queries, QUERY_COLLECTION);
    }

    public Iterator queries() {
        return new CloneIterator(this.queries);
    }

    public int queriesSize() {
        return this.queries.size();
    }

    public MWQuery queryWithSignature(String querySignature) {
        Iterator queries = this.queries();
        while (queries.hasNext()) {
            MWQuery query = (MWQuery)queries.next();
            if (!query.signature().equals(querySignature)) continue;
            return query;
        }
        return null;
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    private Collection getQueriesForTopLink() {
        return CollectionTools.sort((List)this.queries);
    }

    private void setQueriesForTopLink(Collection queries) {
        this.queries = queries;
    }

    public void setQueryTimeout(Integer queryTimeout) {
        Integer oldQueryTimeout = this.getQueryTimeout();
        this.queryTimeout = queryTimeout;
        this.firePropertyChanged(QUERY_TIMEOUT_PROPERTY, oldQueryTimeout, queryTimeout);
    }

    public static Vector topLinkReservedFinderNames() {
        Vector<String> finderNames = new Vector<String>();
        finderNames.add("findByPrimaryKey");
        finderNames.add("findAll");
        finderNames.add("findOneBySql");
        finderNames.add("findManyBySql");
        finderNames.add("findOneByEjbql");
        finderNames.add("findManyByEjbql");
        finderNames.addAll(MWQueryManager.topLinkReservedFindByQueryFinderNames());
        return finderNames;
    }

    public static Vector topLinkReservedFindByQueryFinderNames() {
        Vector<String> finderNames = new Vector<String>();
        finderNames.add("findOneByQuery");
        finderNames.add("findManyByQuery");
        return finderNames;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWQueryManager.class);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWRelationalQueryManager.class, (Object)"relational");
        ip.addClassIndicator(MWEisQueryManager.class, (Object)"eis");
        ip.addClassIndicator(MWOXQueryManager.class, (Object)"ox");
        XMLDirectMapping queryTimeoutMapping = new XMLDirectMapping();
        queryTimeoutMapping.setAttributeName(QUERY_TIMEOUT_PROPERTY);
        queryTimeoutMapping.setXPath("query-timeout/text()");
        queryTimeoutMapping.setGetMethodName("getQueryTimeoutForTopLink");
        queryTimeoutMapping.setSetMethodName("setQueryTimeoutForTopLink");
        queryTimeoutMapping.setNullValue((Object)DEFAULT_QUERY_TIMEOUT);
        descriptor.addMapping((DatabaseMapping)queryTimeoutMapping);
        XMLCompositeCollectionMapping queriesMapping = new XMLCompositeCollectionMapping();
        queriesMapping.setAttributeName(QUERY_COLLECTION);
        queriesMapping.setGetMethodName("getQueriesForTopLink");
        queriesMapping.setSetMethodName("setQueriesForTopLink");
        queriesMapping.setReferenceClass(MWAbstractQuery.class);
        queriesMapping.setXPath("query-list/query");
        descriptor.addMapping((DatabaseMapping)queriesMapping);
        return descriptor;
    }

    private Integer getQueryTimeoutForTopLink() {
        return this.queryTimeout;
    }

    private void setQueryTimeoutForTopLink(Integer queryTimeout) {
        this.queryTimeout = queryTimeout.equals(QUERY_TIMEOUT_NO_TIMEOUT) ? QUERY_TIMEOUT_NO_TIMEOUT : (queryTimeout.equals(DEFAULT_QUERY_TIMEOUT) ? DEFAULT_QUERY_TIMEOUT : queryTimeout);
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        DescriptorQueryManager rtQueryManager = runtimeDescriptor.getQueryManager();
        rtQueryManager.setQueryTimeout(this.getQueryTimeout().intValue());
        Iterator i = this.queries();
        while (i.hasNext()) {
            rtQueryManager.addQuery(((MWQuery)i.next()).runtimeQuery());
        }
    }

    public void adjustFromRuntime(ClassDescriptor runtimeDescriptor) {
        DescriptorQueryManager rtQueryManager = runtimeDescriptor.getQueryManager();
        this.queries.clear();
        Iterator queryVectorIt = rtQueryManager.getQueries().values().iterator();
        while (queryVectorIt.hasNext()) {
            for (DatabaseQuery query : (Vector)queryVectorIt.next()) {
                MWReadQuery mwQuery;
                if (query instanceof ReadObjectQuery) {
                    mwQuery = this.addReadObjectQuery(query.getName());
                } else {
                    if (!(query instanceof ReadAllQuery)) continue;
                    mwQuery = this.addReadAllQuery(query.getName());
                }
                mwQuery.adjustFromRuntime((ObjectLevelReadQuery)query);
            }
        }
    }
}

