/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.xml;

import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXpathableSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;

final class MWXpathStep
extends MWModel {
    private transient String stepString;
    private transient MWNamespace namespace;
    private MWXpathableSchemaComponent xpathComponent;
    private boolean isText;
    private boolean isAttribute;
    private String localName = "";
    private int position = ANY_POSITION;
    private static int ANY_POSITION = 0;
    private transient boolean resolved;
    private transient boolean valid;

    private MWXpathStep(MWXmlField parent) {
        super(parent);
    }

    MWXpathStep(MWXmlField parent, String stepString) {
        this(parent);
        this.stepString = stepString;
    }

    boolean isText() {
        return this.isText;
    }

    boolean isAttribute() {
        return this.xpathComponent instanceof MWAttributeDeclaration;
    }

    boolean isElement() {
        return this.xpathComponent instanceof MWElementDeclaration;
    }

    boolean isPositional() {
        return this.position != ANY_POSITION;
    }

    boolean isSingular() {
        if (this.xpathComponent != null && this.xpathComponent.getMaxOccurs() == -1) {
            return false;
        }
        return this.isText || this.position != ANY_POSITION || this.xpathComponent.getMaxOccurs() <= 1;
    }

    MWXpathableSchemaComponent xpathComponent() {
        return this.xpathComponent;
    }

    String getStepString() {
        return this.stepString;
    }

    void updateStepString() {
        this.stepString = this.isText ? this.textStepString() : this.componentStepString();
    }

    private String textStepString() {
        return "text()";
    }

    private String componentStepString() {
        String stepString = "";
        if (this.isAttribute) {
            stepString = stepString + "@";
        }
        stepString = stepString + this.namespacePrefix();
        stepString = stepString + this.localName;
        stepString = stepString + this.positionString();
        return stepString;
    }

    private String namespacePrefix() {
        if (this.namespace != null && !"".equals(this.namespace.getNamespacePrefix()) && !this.namespace.getSchema().getDefaultNamespaceUrl().equals(this.namespace.getNamespaceUrl())) {
            return this.namespace.getNamespacePrefix() + ":";
        }
        return "";
    }

    private String positionString() {
        if (this.position != ANY_POSITION) {
            return "[" + this.position + "]";
        }
        return "";
    }

    boolean isResolved() {
        return this.resolved;
    }

    boolean isValid() {
        return this.valid;
    }

    MWSchemaContextComponent resolveContext(MWSchemaContextComponent parentContext) {
        if (parentContext == null) {
            this.unresolve();
            return null;
        }
        if ("text()".equals(this.stepString)) {
            return this.resolveTextContext(parentContext);
        }
        if (this.stepString.startsWith("@")) {
            return this.resolveAttributeContext(parentContext);
        }
        return this.resolveElementContext(parentContext);
    }

    private void unresolve() {
        this.namespace = null;
        this.xpathComponent = null;
        this.localName = "";
        this.isAttribute = false;
        this.isText = false;
        this.position = ANY_POSITION;
        this.resolved = false;
        this.valid = false;
    }

    private MWSchemaContextComponent resolveTextContext(MWSchemaContextComponent parentContext) {
        this.namespace = null;
        this.isText = true;
        this.isAttribute = false;
        this.localName = "";
        this.position = ANY_POSITION;
        this.resolved = true;
        this.valid = parentContext.containsText();
        return null;
    }

    private MWSchemaContextComponent resolveAttributeContext(MWSchemaContextComponent parentContext) {
        this.isAttribute = true;
        this.position = ANY_POSITION;
        String qName = this.stepString.substring(1);
        return this.resolveComponentContext(parentContext, qName);
    }

    private MWSchemaContextComponent resolveElementContext(MWSchemaContextComponent parentContext) {
        this.isAttribute = false;
        this.position = ANY_POSITION;
        int openBraceIndex = this.stepString.indexOf(91);
        int closeBraceIndex = this.stepString.indexOf(93);
        String qName = this.stepString;
        if (openBraceIndex != -1 && closeBraceIndex > openBraceIndex + 1) {
            try {
                this.position = Integer.valueOf(this.stepString.substring(openBraceIndex + 1, closeBraceIndex));
                qName = this.stepString.substring(0, openBraceIndex);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return this.resolveComponentContext(parentContext, qName);
    }

    private MWSchemaContextComponent resolveComponentContext(MWSchemaContextComponent parentContext, String qName) {
        String namespacePrefix = "";
        String namespaceUrl = "";
        String localName = qName;
        int colonIndex = qName.indexOf(58);
        if (colonIndex != -1) {
            namespacePrefix = qName.substring(0, colonIndex);
            namespaceUrl = parentContext.getSchema().namespaceUrlForPrefix(namespacePrefix);
            localName = localName.substring(colonIndex + 1);
        }
        this.localName = localName;
        this.namespace = parentContext.getSchema().namespaceForUrl(namespaceUrl);
        this.xpathComponent = this.isAttribute ? parentContext.nestedAttribute(namespaceUrl, localName) : parentContext.nestedElement(namespaceUrl, localName);
        this.resolved = this.xpathComponent != null;
        this.valid = this.xpathComponent != null && this.position <= this.xpathComponent.getMaxOccurs();
        return this.xpathComponent;
    }

    static int compareSchemaOrder(MWSchemaContextComponent contextComponent, MWXpathStep step1, MWXpathStep step2) {
        MWElementDeclaration element2;
        if (step1.isAttribute()) {
            if (step2.isAttribute()) {
                return 0;
            }
            return -1;
        }
        if (step1.isText()) {
            if (step2.isAttribute()) {
                return 1;
            }
            if (step2.isText()) {
                return 0;
            }
            return -1;
        }
        if (!step2.isElement()) {
            return 1;
        }
        MWElementDeclaration element1 = (MWElementDeclaration)step1.xpathComponent();
        int comparison = contextComponent.compareSchemaOrder(element1, element2 = (MWElementDeclaration)step2.xpathComponent());
        if (comparison == 0) {
            return new Integer(step1.position).compareTo(new Integer(step2.position));
        }
        return comparison;
    }
}

