/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Hashtable;

public class GridLayout
implements LayoutManager2,
Serializable {
    private int columns;
    private int componentIndex;
    private Hashtable constraintsTable = new Hashtable();
    private int hgap;
    private int rows;
    private int vgap;

    public GridLayout() {
    }

    public GridLayout(int rowCount, int columnCount) {
        this.setRows(rowCount);
        this.setColumns(columnCount);
    }

    public GridLayout(int rowCount, int columnCount, int horizontalGap, int verticalGap) {
        this(rowCount, columnCount);
        this.setHgap(horizontalGap);
        this.setVgap(verticalGap);
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints == null) {
            constraints = new GridBagConstraints();
            ((GridBagConstraints)constraints).fill = 1;
        } else if (!(constraints instanceof GridBagConstraints)) {
            throw new IllegalArgumentException("The constraints has to be GridBagConstraints");
        }
        this.constraintsTable.put(component, ((GridBagConstraints)constraints).clone());
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    public int getColumns() {
        return this.columns;
    }

    public GridBagConstraints getConstraints(Component component) {
        GridBagConstraints constraints = (GridBagConstraints)this.constraintsTable.get(component);
        if (constraints == null) {
            constraints = new GridBagConstraints();
            constraints.fill = 1;
            this.constraintsTable.put(component, constraints);
        }
        return (GridBagConstraints)constraints.clone();
    }

    public int getHgap() {
        return this.hgap;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getLayoutSize(Container parent, boolean useMinimumSize) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component component;
            Insets insets = parent.getInsets();
            int horizontalInsets = insets.left + insets.right;
            int verticalInsets = insets.top + insets.bottom;
            int componentCount = parent.getComponentCount();
            int resizabledWidthComponentCount = 0;
            int resizabledHeightComponentCount = 0;
            int rowCount = this.getRows();
            int columnCount = this.getColumns();
            int maxComponentWidth = 0;
            int maxComponentHeight = 0;
            int rigidComponentWidth = 0;
            int rigidComponentHeight = 0;
            int index = componentCount;
            while (--index >= 0) {
                component = parent.getComponent(index);
                if (component.isVisible()) continue;
                if (columnCount < 2) {
                    --rowCount;
                }
                if (rowCount < 2) {
                    --columnCount;
                }
                --componentCount;
            }
            if (rowCount > 0) {
                columnCount = (componentCount + rowCount - 1) / rowCount;
            } else if (columnCount > 0) {
                rowCount = (componentCount + columnCount - 1) / columnCount;
            } else {
                return new Dimension();
            }
            index = parent.getComponentCount();
            while (--index >= 0) {
                component = parent.getComponent(index);
                if (!component.isVisible()) continue;
                GridBagConstraints constraints = this.getConstraints(component);
                Dimension componentSize = useMinimumSize ? component.getMinimumSize() : component.getPreferredSize();
                if (constraints.fill != 1) {
                    if (rowCount < 2 && (constraints.fill == 3 || constraints.fill == 0)) {
                        rigidComponentWidth += componentSize.width;
                    } else if (constraints.fill != 0) {
                        ++resizabledWidthComponentCount;
                        maxComponentWidth = Math.max(maxComponentWidth, componentSize.width);
                    } else {
                        maxComponentWidth = Math.max(maxComponentWidth, componentSize.width);
                    }
                    if (columnCount < 2 && (constraints.fill == 2 || constraints.fill == 0)) {
                        rigidComponentHeight += componentSize.height;
                        continue;
                    }
                    if (constraints.fill != 0) {
                        ++resizabledHeightComponentCount;
                        maxComponentHeight = Math.max(maxComponentHeight, componentSize.height);
                        continue;
                    }
                    maxComponentHeight = Math.max(maxComponentHeight, componentSize.height);
                    continue;
                }
                ++resizabledWidthComponentCount;
                ++resizabledHeightComponentCount;
                maxComponentWidth = Math.max(maxComponentWidth, componentSize.width);
                maxComponentHeight = Math.max(maxComponentHeight, componentSize.height);
            }
            int width = 0;
            int height = 0;
            if (rowCount < 2) {
                width = horizontalInsets + rigidComponentWidth + maxComponentWidth * resizabledWidthComponentCount + (columnCount - 1) * this.getHgap();
                height = verticalInsets + Math.max(rigidComponentHeight, maxComponentHeight) + (rowCount - 1) * this.getVgap();
            } else {
                width = horizontalInsets + Math.max(rigidComponentWidth, maxComponentWidth) + (columnCount - 1) * this.getHgap();
                height = verticalInsets + rigidComponentHeight + maxComponentHeight * resizabledHeightComponentCount + (rowCount - 1) * this.getVgap();
            }
            return new Dimension(width, height);
        }
    }

    private Component getNextVisibleComponent(Container parent, int index) {
        Component component = null;
        int componentCount = parent.getComponentCount();
        while (this.componentIndex < componentCount) {
            if ((component = parent.getComponent(this.componentIndex++)).isVisible()) {
                return component;
            }
            component.setBounds(0, 0, 0, 0);
        }
        return null;
    }

    public int getRows() {
        return this.rows;
    }

    public int getVgap() {
        return this.vgap;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        if (parent == null) {
            return;
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            GridBagConstraints constraints;
            Dimension preferredSize;
            Component component;
            int componentCount = parent.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            Insets insets = parent.getInsets();
            boolean leftToRight = parent.getComponentOrientation().isLeftToRight();
            int horizontalInsets = insets.left + insets.right;
            int verticalInsets = insets.top + insets.bottom;
            int width = parent.getWidth() - horizontalInsets;
            int height = parent.getHeight() - verticalInsets;
            int resizabledWidthComponentCount = 0;
            int resizabledHeightComponentCount = 0;
            int rowCount = this.getRows();
            int columnCount = this.getColumns();
            int maxComponentWidth = 0;
            int maxComponentHeight = 0;
            int rigidComponentWidth = 0;
            int rigidComponentWidthCount = 0;
            int rigidComponentHeight = 0;
            int rigidComponentHeightCount = 0;
            double resizeFactorWidth = 1.0;
            double resizeFactorHeight = 1.0;
            int index = componentCount;
            while (--index >= 0) {
                component = parent.getComponent(index);
                if (component.isVisible()) continue;
                if (columnCount < 2) {
                    --rowCount;
                } else if (rowCount < 2) {
                    --columnCount;
                }
                --componentCount;
            }
            if (rowCount > 0) {
                columnCount = (componentCount + rowCount - 1) / rowCount;
            } else if (columnCount > 0) {
                rowCount = (componentCount + columnCount - 1) / columnCount;
            } else {
                return;
            }
            for (index = 0; index < parent.getComponentCount(); ++index) {
                component = parent.getComponent(index);
                if (!component.isVisible()) continue;
                preferredSize = component.getPreferredSize();
                constraints = this.getConstraints(component);
                if (constraints.fill != 1) {
                    if (rowCount < 2 && (constraints.fill == 3 || constraints.fill == 0)) {
                        rigidComponentWidth += preferredSize.width;
                        ++rigidComponentWidthCount;
                    } else if (constraints.fill != 0) {
                        ++resizabledWidthComponentCount;
                        maxComponentWidth = Math.max(maxComponentWidth, preferredSize.width);
                    } else {
                        maxComponentWidth = Math.max(maxComponentWidth, preferredSize.width);
                    }
                    if (columnCount < 2 && (constraints.fill == 2 || constraints.fill == 0)) {
                        rigidComponentHeight += preferredSize.height;
                        ++rigidComponentHeightCount;
                        continue;
                    }
                    if (constraints.fill != 0) {
                        ++resizabledHeightComponentCount;
                        maxComponentHeight = Math.max(maxComponentHeight, preferredSize.height);
                        continue;
                    }
                    maxComponentHeight = Math.max(maxComponentHeight, preferredSize.height);
                    continue;
                }
                ++resizabledWidthComponentCount;
                ++resizabledHeightComponentCount;
                maxComponentWidth = Math.max(maxComponentWidth, preferredSize.width);
                maxComponentHeight = Math.max(maxComponentHeight, preferredSize.height);
            }
            int widthLeft = width - horizontalInsets - (componentCount - 1) * this.getHgap();
            int heightLeft = height - verticalInsets - (componentCount - 1) * this.getVgap();
            if (resizabledWidthComponentCount == 0) {
                resizabledWidthComponentCount = 1;
            }
            if (rowCount < 2) {
                maxComponentWidth = (widthLeft -= rigidComponentWidth) / resizabledWidthComponentCount;
                maxComponentHeight = parent.getHeight();
            }
            if (columnCount < 2) {
                maxComponentWidth = width;
                maxComponentHeight = (heightLeft -= rigidComponentHeight) / resizabledWidthComponentCount;
            }
            if (rigidComponentWidthCount > 0 && rigidComponentWidth > width) {
                resizeFactorWidth = (double)width / (double)rigidComponentWidth;
            }
            if (rigidComponentHeightCount > 0 && rigidComponentHeight > height) {
                resizeFactorHeight = (double)height / (double)rigidComponentHeight;
            }
            int y = insets.top;
            this.componentIndex = 0;
            int x = leftToRight ? insets.left : insets.right + width - insets.left;
            width = 0;
            height = 0;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (int columnIndex = 0; columnIndex < columnCount && (component = this.getNextVisibleComponent(parent, this.componentIndex)) != null; ++columnIndex) {
                    constraints = this.getConstraints(component);
                    if (constraints.fill != 1) {
                        preferredSize = component.getPreferredSize();
                        width = constraints.fill == 3 || constraints.fill == 0 ? (int)((double)preferredSize.width * resizeFactorWidth) : maxComponentWidth;
                        height = constraints.fill == 2 || constraints.fill == 0 ? (int)((double)preferredSize.height * resizeFactorHeight) : maxComponentHeight;
                        if (leftToRight) {
                            component.setBounds(x, y, width, height);
                        } else {
                            component.setBounds(x - width, y, width, height);
                        }
                        if (columnCount > 1) {
                            height = Math.max(maxComponentHeight, height);
                        }
                    } else {
                        width = maxComponentWidth;
                        height = maxComponentHeight;
                        if (leftToRight) {
                            component.setBounds(x, y, width, height);
                        } else {
                            component.setBounds(x - width, y, width, height);
                        }
                    }
                    if (leftToRight) {
                        x += width + this.getHgap();
                        continue;
                    }
                    x -= width - this.getHgap();
                }
                x = leftToRight ? insets.left : insets.right + width - insets.left;
                y += height + this.getVgap();
            }
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraintsTable.remove(component);
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setConstraints(Component Component2, GridBagConstraints constraints) {
        this.constraintsTable.put(Component2, constraints.clone());
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }
}

