/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.io.File;
import java.net.URLClassLoader;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ProjectDeploymentXmlGenerationCoordinator;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction
extends AbstractEnablableFrameworkAction {
    ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("EXPORT_DEPLOYMENT_XML_AND_INITIALIZE_RUNTIME_DESCRIPTORS_ACTION");
        this.initializeToolTipText("EXPORT_DEPLOYMENT_XML_AND_INITIALIZE_RUNTIME_DESCRIPTORS_ACTION.toolTipText");
        this.initializeIcon("GENERATE_XML");
    }

    @Override
    protected void execute() {
        ProjectDeploymentXmlGenerationCoordinator coordinator = new ProjectDeploymentXmlGenerationCoordinator(this.getWorkbenchContext());
        ApplicationNode[] projectNodes = this.selectedProjectNodes();
        for (int i = 0; i < projectNodes.length; ++i) {
            MWProject mwProject = (MWProject)projectNodes[i].getValue();
            if (!coordinator.exportProjectDeploymentXml(mwProject)) continue;
            File deploymentXmlFile = mwProject.deploymentXMLFile();
            Project project = XMLProjectReader.read((String)deploymentXmlFile.getAbsolutePath(), (ClassLoader)this.buildClassLoader(mwProject));
            DatabaseSessionImpl session = (DatabaseSessionImpl)project.createDatabaseSession();
            session.dontLogMessages();
            session.initializeDescriptors();
            JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("EXPORT_DEPLOYMENT_XML_AND_INITIALIZE_RUNTIME_DESCRIPTORS_STATUS_BAR"));
        }
    }

    private ClassLoader buildClassLoader(MWProject project) {
        Classpath cp = new Classpath(CollectionTools.list((Iterator)project.getRepository().fullyQualifiedClasspathEntries()));
        return new URLClassLoader(cp.urls(), this.getClass().getClassLoader());
    }

    @Override
    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        return this.selectedProjectNodes().length > 0;
    }
}

