/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.CheckList;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

final class AdvancedPolicyChooser
extends AbstractDialog {
    private final ListValueModel advancedPropertiesCollection;
    private final ObjectListSelectionModel selectedItems;
    private final CellRendererAdapter cellRenderer;

    AdvancedPolicyChooser(WorkbenchContext context, ListValueModel advancedPropertiesCollection, ObjectListSelectionModel selectedItems, CellRendererAdapter cellRenderer) {
        super(context, context.getApplicationContext().getResourceRepository().getString("ADVANCED_PROPERTY_CHOOSER_TITLE"));
        this.advancedPropertiesCollection = advancedPropertiesCollection;
        this.selectedItems = selectedItems;
        this.cellRenderer = cellRenderer;
    }

    protected JComponent buildAdvancedPropertiesPanel() {
        CheckList checkList = new CheckList(this.advancedPropertiesCollection, (ListSelectionModel)this.selectedItems, this.cellRenderer);
        checkList.setBorder(SwingComponentFactory.buildStandardEmptyBorder());
        return checkList;
    }

    @Override
    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        LabelArea instructions = new LabelArea(this.resourceRepository().getString("ADVANCED_PROPERTY_CHOOSER_PLEASE_SELECT_ALL"));
        instructions.setScrollable(true);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)instructions, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)this.buildAdvancedPropertiesPanel(), constraints);
        return panel;
    }

    @Override
    protected String helpTopicId() {
        return "dialog.advancedProperties";
    }
}

