/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInstantiationPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class InstantiationPolicyPropertiesPage
extends ScrollablePropertiesPage {
    static final int EDITOR_WEIGHT = 8;
    private PropertyValueModel instantiationPolicyValueHolder;
    private PropertyValueModel policyTypeHolder;
    private PropertyValueModel factoryTypeHolder;

    InstantiationPolicyPropertiesPage(PropertyValueModel valueModel, WorkbenchContextHolder contextHolder) {
        super(valueModel, contextHolder);
    }

    private String getHelpTopicId() {
        return "descriptor.instantiation";
    }

    @Override
    protected Component buildPage() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JRadioButton useDefaultConstructor = this.buildUseDefaultConstructorButton();
        JRadioButton useMethod = this.buildUseMethodButton();
        JPanel useMethodPanel = this.buildUseMethodPanel();
        this.buildUseMethodPanelEnabler(this.buildInstantiationPolicyTypeValueHolder(), useMethodPanel.getComponents());
        JRadioButton useFactory = this.buildUseFactoryButton();
        JPanel useFactoryPanel = this.buildUseFactoryPanel();
        this.buildFactoryPanelEnabler(this.buildInstantiationPolicyTypeValueHolder(), useFactoryPanel.getComponents());
        GroupBox groupBox = new GroupBox(new AbstractButton[]{useDefaultConstructor, useMethod, useFactory}, new JComponent[]{GroupBox.NO_PANE, useMethodPanel, useFactoryPanel});
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)groupBox, constraints);
        this.addHelpTopicId(mainPanel, this.getHelpTopicId());
        return mainPanel;
    }

    protected JPanel buildUseFactoryPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel useFactoryPanel = new JPanel(new GridBagLayout());
        JLabel factoryClassLabel = this.buildLabel("INSTANTIATION_POLICY_FACTORY_CLASS");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        useFactoryPanel.add((Component)factoryClassLabel, constraints);
        this.addAlignLeft(factoryClassLabel);
        ClassChooserPanel factoryClassChooserPanel = ClassChooserTools.buildPanel(this.factoryTypeHolder, this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), factoryClassLabel, this.getWorkbenchContextHolder());
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        useFactoryPanel.add((Component)factoryClassChooserPanel, constraints);
        factoryClassLabel.setLabelFor(factoryClassChooserPanel);
        this.addPaneForAlignment(factoryClassChooserPanel);
        JComponent factoryMethodWidgets = this.buildLabeledComponent("INSTANTIATION_POLICY_FACTORY_METHOD", this.buildFactoryMethodListChooser());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        useFactoryPanel.add((Component)factoryMethodWidgets, constraints);
        JComponent instantiationMethodWidgets = this.buildLabeledComponent("INSTANTIATION_POLICY_INSTANTIATION_METHOD", this.buildFactoryInstantiationMethodListChooser());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        useFactoryPanel.add((Component)instantiationMethodWidgets, constraints);
        this.addHelpTopicId(useFactoryPanel, this.getHelpTopicId() + ".useFactory");
        return useFactoryPanel;
    }

    protected JPanel buildUseMethodPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel useMethodPanel = new JPanel(new GridBagLayout());
        ListChooser methodChooser = this.buildUseMethodListChooser();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        useMethodPanel.add((Component)methodChooser, constraints);
        methodChooser.putClientProperty("labeledBy", new JLabel(" "));
        Spacer spacer = new Spacer();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        useMethodPanel.add((Component)spacer, constraints);
        this.addAlignRight(spacer);
        this.addHelpTopicId(useMethodPanel, this.getHelpTopicId() + ".useMethod");
        return useMethodPanel;
    }

    private PropertyValueModel buildInstantiationPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "instantiationPolicy"){

            @Override
            protected Object getValueFromSubject() {
                MWDescriptorPolicy policy = ((MWMappingDescriptor)this.subject).getInstantiationPolicy();
                return policy.isActive() ? policy : null;
            }
        };
    }

    private PropertyValueModel buildInstantiationPolicyTypeValueHolder() {
        if (this.policyTypeHolder == null) {
            this.policyTypeHolder = new PropertyAspectAdapter(this.instantiationPolicyValueHolder, "policyType"){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWDescriptorInstantiationPolicy)this.subject).getPolicyType();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWDescriptorInstantiationPolicy)this.subject).setPolicyType((String)value);
                }
            };
        }
        return this.policyTypeHolder;
    }

    private JRadioButton buildUseDefaultConstructorButton() {
        return this.buildRadioButton("INSTANTIATION_POLICY_USE_DEFAULT_CONSTRUCTOR", new RadioButtonModelAdapter(this.buildInstantiationPolicyTypeValueHolder(), "Default constructor"));
    }

    private JRadioButton buildUseMethodButton() {
        return this.buildRadioButton("INSTANTIATION_POLICY_USE_METHOD", new RadioButtonModelAdapter(this.buildInstantiationPolicyTypeValueHolder(), "Method"));
    }

    private JRadioButton buildUseFactoryButton() {
        return this.buildRadioButton("INSTANTIATION_POLICY_USE_FACTORY", new RadioButtonModelAdapter(this.buildInstantiationPolicyTypeValueHolder(), "Factory"));
    }

    MWDescriptor descriptor() {
        return (MWDescriptor)this.selection();
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            @Override
            public MWClassRepository getClassRepository() {
                return InstantiationPolicyPropertiesPage.this.descriptor().getRepository();
            }
        };
    }

    private PropertyValueModel buildFactoryTypeHolder() {
        return new PropertyAspectAdapter(this.instantiationPolicyValueHolder, "factoryType"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptorInstantiationPolicy)this.subject).getFactoryType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                MWClass type = (MWClass)value;
                ((MWDescriptorInstantiationPolicy)this.subject).setFactoryType(type);
                if (type != null) {
                    try {
                        if (type.isStub()) {
                            type.refresh();
                        }
                    }
                    catch (ExternalClassNotFoundException exception) {
                        InstantiationPolicyPropertiesPage.this.showClassLoadingException();
                    }
                }
            }
        };
    }

    private PropertyValueModel buildUseMethodSelectionHolder() {
        PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter(this.instantiationPolicyValueHolder, "useMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptorInstantiationPolicy)this.subject).getUseMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWDescriptorInstantiationPolicy)this.subject).setUseMethod((MWMethod)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyValueModel, "signature");
    }

    private PropertyValueModel buildFactoryMethodSelectionHolder() {
        PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter(this.instantiationPolicyValueHolder, "factoryMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptorInstantiationPolicy)this.subject).getFactoryMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWDescriptorInstantiationPolicy)this.subject).setFactoryMethod((MWMethod)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyValueModel, "signature");
    }

    private PropertyValueModel buildInstantiationMethodSelectionHolder() {
        PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter(this.instantiationPolicyValueHolder, "instantiationMethod"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptorInstantiationPolicy)this.subject).getInstantiationMethod();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWDescriptorInstantiationPolicy)this.subject).setInstantiationMethod((MWMethod)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyValueModel, "signature");
    }

    private PropertyValueModel buildUseMethodClassHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "mwClass"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    private ListChooser buildUseMethodListChooser() {
        ListChooser listChooser = new ListChooser(this.buildUseMethodComboBoxModel(), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private CachingComboBoxModel buildUseMethodComboBoxModel() {
        return new IndirectComboBoxModel(this.buildUseMethodSelectionHolder(), this.buildUseMethodClassHolder()){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return InstantiationPolicyPropertiesPage.this.orderedFactoryInstantiationMethodChoices((MWClass)subject);
            }
        };
    }

    ListIterator orderedFactoryMethodChoices(MWClass mwClass) {
        List methodChoices = CollectionTools.sort((Iterator)mwClass.candidateFactoryMethods());
        methodChoices.add(0, null);
        return methodChoices.listIterator();
    }

    ListIterator orderedFactoryInstantiationMethodChoices(MWClass mwClass) {
        return CollectionTools.sort((Iterator)mwClass.candidateFactoryInstantiationMethodsFor(this.descriptor().getMWClass())).listIterator();
    }

    private ListChooser buildFactoryMethodListChooser() {
        ListChooser listChooser = new ListChooser(this.buildFactoryMethodComboBoxModel());
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private CachingComboBoxModel buildFactoryMethodComboBoxModel() {
        return new IndirectComboBoxModel(this.buildFactoryMethodSelectionHolder(), this.factoryTypeHolder){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return InstantiationPolicyPropertiesPage.this.orderedFactoryMethodChoices((MWClass)subject);
            }
        };
    }

    private CachingComboBoxModel buildInstantiationMethodComboBoxModel() {
        return new IndirectComboBoxModel(this.buildInstantiationMethodSelectionHolder(), this.factoryTypeHolder){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return InstantiationPolicyPropertiesPage.this.orderedFactoryInstantiationMethodChoices((MWClass)subject);
            }
        };
    }

    private ListChooser buildFactoryInstantiationMethodListChooser() {
        ListChooser listChooser = new ListChooser(this.buildInstantiationMethodComboBoxModel());
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    @Override
    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.instantiationPolicyValueHolder = this.buildInstantiationPolicyHolder();
        this.factoryTypeHolder = this.buildFactoryTypeHolder();
    }

    void showClassLoadingException() {
        LabelArea label = new LabelArea(this.resourceRepository().getString("PROBLEM_LOADING_CLASS"));
        JOptionPane.showMessageDialog(this, label, this.resourceRepository().getString("PROBLEM_LOADING_CLASS_TITLE"), 0);
        this.factoryTypeHolder.setValue(null);
    }

    private ComponentEnabler buildUseMethodPanelEnabler(PropertyValueModel useMethodHolder, Component[] components) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(useMethodHolder){

            @Override
            protected Object transform(Object value) {
                return "Method".equals(value);
            }
        };
        return new ComponentEnabler((ValueModel)booleanHolder, components);
    }

    private ComponentEnabler buildFactoryPanelEnabler(PropertyValueModel factoryHolder, Component[] components) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(factoryHolder){

            @Override
            protected Object transform(Object value) {
                return "Factory".equals(value);
            }
        };
        return new ComponentEnabler((ValueModel)booleanHolder, components);
    }
}

