/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWAbstractCompositeMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWAttributeContainerAccessor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWContainerAccessor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWMethodContainerAccessor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.AccessorEditingPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

public final class ContainerAccessorEditingDialog
extends AbstractValidatingDialog {
    private AccessorEditor accessorEditor;
    private boolean noError = false;

    public static void promptToEditContainerAccessor(MWAbstractCompositeMapping compositeMapping, WorkbenchContext context) {
        AttributeAccessorEditor editor = new AttributeAccessorEditor(compositeMapping);
        ContainerAccessorEditingDialog dialog = new ContainerAccessorEditingDialog(editor, context);
        dialog.show();
        if (dialog.wasConfirmed()) {
            editor.commit();
        }
    }

    private ContainerAccessorEditingDialog(AccessorEditor accessorEditor, WorkbenchContext context) {
        super(context);
        this.initialize(accessorEditor);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("CONTAINER_ACCESSOR_EDITING_DIALOG_TITLE"));
    }

    private void initialize(AccessorEditor accessorEditor) {
        this.accessorEditor = accessorEditor;
        this.accessorEditor.accessorGetMethodHolder().addPropertyChangeListener("value", this.buildValidatingListener());
        this.accessorEditor.accessorSetMethodHolder().addPropertyChangeListener("value", this.buildValidatingListener());
        this.accessorEditor.accessorAttributeHolder().addPropertyChangeListener("value", this.buildValidatingListener());
        this.accessorEditor.accessorTypeHolder().addPropertyChangeListener("value", this.buildValidatingListener());
        this.updateOKAction();
    }

    private PropertyChangeListener buildValidatingListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContainerAccessorEditingDialog.this.updateErrorMessage();
                ContainerAccessorEditingDialog.this.updateOKAction();
            }
        };
    }

    private void updateErrorMessage() {
        if (this.accessorEditor.accessorType() == "nullAccessor") {
            this.setErrorMessageKey("ACCESSOR_EDITING_DIALOG.NULL_ACCESSOR_ERROR");
        } else if (this.accessorEditor.accessorType() == "accessorAttribute" && this.accessorEditor.accessorAttribute() == null) {
            this.setErrorMessageKey("ACCESSOR_EDITING_DIALOG.NULL_ACCESSOR_ATTRIBUTE_ERROR");
        } else if (this.accessorEditor.accessorType() == "accessorMethods") {
            if (this.accessorEditor.accessorGetMethod() == null) {
                this.setErrorMessageKey("ACCESSOR_EDITING_DIALOG.NULL_ACCESSOR_GET_METHOD_ERROR");
            } else if (this.accessorEditor.accessorSetMethod() == null) {
                this.setErrorMessageKey("ACCESSOR_EDITING_DIALOG.NULL_ACCESSOR_SET_METHOD_ERROR");
            } else {
                this.clearErrorMessage();
            }
        } else {
            this.clearErrorMessage();
        }
    }

    @Override
    protected void setErrorMessage(String message) {
        super.setErrorMessage(message);
        this.noError = message == null;
    }

    @Override
    protected void clearErrorMessage() {
        super.clearErrorMessage();
        this.noError = true;
    }

    private void updateOKAction() {
        this.getOKAction().setEnabled(this.noError);
    }

    @Override
    protected String helpTopicId() {
        return "dialog.editAccessor";
    }

    @Override
    protected void prepareToShow() {
        super.prepareToShow();
        this.setSize(Math.max(500, this.getWidth()), this.getHeight());
        this.updateErrorMessage();
        this.updateOKAction();
    }

    @Override
    protected Component buildMainPanel() {
        return new AccessorEditingPanel(this.accessorEditor, (WorkbenchContextHolder)new DefaultWorkbenchContextHolder(this.getWorkbenchContext()));
    }

    static class MethodsAccessorEditor
    extends AbstractAccessorEditor {
        private MWAbstractCompositeMapping compositeMapping;

        MethodsAccessorEditor(MWAbstractCompositeMapping compositeMapping) {
            this.compositeMapping = compositeMapping;
        }

        protected MWAbstractCompositeMapping compositeMapping() {
            return this.compositeMapping;
        }

        @Override
        public Iterator candidateAccessorMethods() {
            return this.compositeMapping().candidateAccessorMethods();
        }

        @Override
        public Iterator candidateAccessorAttributes() {
            return this.compositeMapping().candidateAccessorAttributes();
        }

        @Override
        protected PropertyValueModel buildInternalGetMethodHolder() {
            return new PropertyAspectAdapter("containerAccessor", (Model)this.compositeMapping){

                @Override
                protected Object getValueFromSubject() {
                    MWContainerAccessor accessor = ((MWAbstractCompositeMapping)this.subject).getContainerAccessor();
                    if (accessor instanceof MWMethodContainerAccessor) {
                        return ((MWMethodContainerAccessor)accessor).getAccessorGetMethod();
                    }
                    return null;
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWAbstractCompositeMapping)this.subject).setContainerAccessorGetMethod((MWMethod)value);
                }
            };
        }

        @Override
        protected PropertyValueModel buildInternalSetMethodHolder() {
            return new PropertyAspectAdapter("containerAccessor", (Model)this.compositeMapping){

                @Override
                protected Object getValueFromSubject() {
                    MWContainerAccessor accessor = ((MWAbstractCompositeMapping)this.subject).getContainerAccessor();
                    if (accessor instanceof MWMethodContainerAccessor) {
                        return ((MWMethodContainerAccessor)accessor).getAccessorSetMethod();
                    }
                    return null;
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWAbstractCompositeMapping)this.subject).setContainerAccessorSetMethod((MWMethod)value);
                }
            };
        }

        @Override
        protected PropertyValueModel buildInternalAttributeHolder() {
            return new PropertyAspectAdapter("containerAccessor", (Model)this.compositeMapping){

                @Override
                protected Object getValueFromSubject() {
                    MWContainerAccessor accessor = ((MWAbstractCompositeMapping)this.subject).getContainerAccessor();
                    if (accessor instanceof MWAttributeContainerAccessor) {
                        return ((MWAttributeContainerAccessor)accessor).getAccessorAttribute();
                    }
                    return null;
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWAbstractCompositeMapping)this.subject).setContainerAccessorAttribute((MWClassAttribute)value);
                }
            };
        }
    }

    static class AttributeAccessorEditor
    extends AbstractAccessorEditor {
        private MWAbstractCompositeMapping compositeMapping;

        private AttributeAccessorEditor(MWAbstractCompositeMapping compositeMapping) {
            this.compositeMapping = compositeMapping;
        }

        protected MWAbstractCompositeMapping compositeMapping() {
            return this.compositeMapping;
        }

        @Override
        public Iterator candidateAccessorMethods() {
            return this.compositeMapping().candidateAccessorMethods();
        }

        @Override
        public Iterator candidateAccessorAttributes() {
            return this.compositeMapping().candidateAccessorAttributes();
        }

        @Override
        protected PropertyValueModel buildInternalGetMethodHolder() {
            return new PropertyAspectAdapter("containerAccessor", (Model)this.compositeMapping){

                @Override
                protected Object getValueFromSubject() {
                    MWContainerAccessor accessor = ((MWAbstractCompositeMapping)this.subject).getContainerAccessor();
                    if (accessor instanceof MWMethodContainerAccessor) {
                        return ((MWMethodContainerAccessor)accessor).getAccessorGetMethod();
                    }
                    return null;
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWAbstractCompositeMapping)this.subject).setContainerAccessorGetMethod((MWMethod)value);
                }
            };
        }

        @Override
        protected PropertyValueModel buildInternalSetMethodHolder() {
            return new PropertyAspectAdapter("containerAccessor", (Model)this.compositeMapping){

                @Override
                protected Object getValueFromSubject() {
                    MWContainerAccessor accessor = ((MWAbstractCompositeMapping)this.subject).getContainerAccessor();
                    if (accessor instanceof MWMethodContainerAccessor) {
                        return ((MWMethodContainerAccessor)accessor).getAccessorSetMethod();
                    }
                    return null;
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWAbstractCompositeMapping)this.subject).setContainerAccessorSetMethod((MWMethod)value);
                }
            };
        }

        @Override
        protected PropertyValueModel buildInternalAttributeHolder() {
            return new PropertyAspectAdapter("containerAccessor", (Model)this.compositeMapping){

                @Override
                protected Object getValueFromSubject() {
                    MWContainerAccessor accessor = ((MWAbstractCompositeMapping)this.subject).getContainerAccessor();
                    if (accessor instanceof MWAttributeContainerAccessor) {
                        return ((MWAttributeContainerAccessor)accessor).getAccessorAttribute();
                    }
                    return null;
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWAbstractCompositeMapping)this.subject).setContainerAccessorAttribute((MWClassAttribute)value);
                }
            };
        }
    }

    static abstract class AbstractAccessorEditor
    implements AccessorEditor {
        private PropertyValueModel accessorTypeHolder;
        private BufferedPropertyValueModel getMethodHolder;
        private BufferedPropertyValueModel.Trigger getMethodTrigger = new BufferedPropertyValueModel.Trigger();
        private BufferedPropertyValueModel setMethodHolder;
        private BufferedPropertyValueModel.Trigger setMethodTrigger = new BufferedPropertyValueModel.Trigger();
        private BufferedPropertyValueModel attributeHolder;
        private BufferedPropertyValueModel.Trigger attributeTrigger = new BufferedPropertyValueModel.Trigger();

        protected AbstractAccessorEditor() {
        }

        @Override
        public PropertyValueModel accessorTypeHolder() {
            if (this.accessorTypeHolder == null) {
                this.accessorTypeHolder = this.buildAccessorTypeHolder();
            }
            return this.accessorTypeHolder;
        }

        protected PropertyValueModel buildAccessorTypeHolder() {
            String accessorType = "nullAccessor";
            if (this.accessorAttribute() != null) {
                accessorType = "accessorAttribute";
            } else if (this.accessorGetMethod() != null && this.accessorSetMethod() != null) {
                accessorType = "accessorMethods";
            }
            return new SimplePropertyValueModel(accessorType);
        }

        @Override
        public String accessorType() {
            return (String)this.accessorTypeHolder().getValue();
        }

        @Override
        public PropertyValueModel accessorGetMethodHolder() {
            if (this.getMethodHolder == null) {
                this.getMethodHolder = this.buildGetMethodHolder();
            }
            return this.getMethodHolder;
        }

        private BufferedPropertyValueModel buildGetMethodHolder() {
            return new BufferedPropertyValueModel(this.buildInternalGetMethodHolder(), this.getMethodTrigger);
        }

        protected abstract PropertyValueModel buildInternalGetMethodHolder();

        @Override
        public MWMethod accessorGetMethod() {
            return (MWMethod)this.accessorGetMethodHolder().getValue();
        }

        @Override
        public PropertyValueModel accessorSetMethodHolder() {
            if (this.setMethodHolder == null) {
                this.setMethodHolder = this.buildSetMethodHolder();
            }
            return this.setMethodHolder;
        }

        private BufferedPropertyValueModel buildSetMethodHolder() {
            return new BufferedPropertyValueModel(this.buildInternalSetMethodHolder(), this.setMethodTrigger);
        }

        protected abstract PropertyValueModel buildInternalSetMethodHolder();

        @Override
        public MWMethod accessorSetMethod() {
            return (MWMethod)this.accessorSetMethodHolder().getValue();
        }

        @Override
        public PropertyValueModel accessorAttributeHolder() {
            if (this.attributeHolder == null) {
                this.attributeHolder = this.buildAttributeHolder();
            }
            return this.attributeHolder;
        }

        private BufferedPropertyValueModel buildAttributeHolder() {
            return new BufferedPropertyValueModel(this.buildInternalAttributeHolder(), this.attributeTrigger);
        }

        protected abstract PropertyValueModel buildInternalAttributeHolder();

        @Override
        public MWClassAttribute accessorAttribute() {
            return (MWClassAttribute)this.accessorAttributeHolder().getValue();
        }

        @Override
        public void commit() {
            if (this.accessorType() == "accessorMethods") {
                this.getMethodTrigger.accept();
                this.setMethodTrigger.accept();
            } else if (this.accessorType() == "accessorAttribute") {
                this.attributeTrigger.accept();
            }
        }
    }

    public static interface AccessorEditor
    extends AccessorEditingPanel.AccessorSpec {
        public void commit();
    }
}

