/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCompoundExpression;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTreePanel;

final class ExpressionBuilderDialog
extends AbstractDialog {
    private MWCompoundExpression expression;
    private int selectionRow;

    ExpressionBuilderDialog(MWCompoundExpression expression, int selectionRow, WorkbenchContext context) {
        super(context);
        this.expression = expression;
        this.selectionRow = selectionRow;
    }

    @Override
    public String helpTopicId() {
        return "dialog.expressionBuilder";
    }

    @Override
    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.setTitle(this.resourceRepository().getString("EXPRESSION_BUILDER_DIALOG.title"));
        GridBagConstraints constraints = new GridBagConstraints();
        ExpressionTreePanel expressionTreePanel = new ExpressionTreePanel(new DefaultWorkbenchContextHolder(this.getWorkbenchContext()), this.helpTopicId());
        expressionTreePanel.setExpression(this.expression, this.selectionRow);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)expressionTreePanel, constraints);
        return panel;
    }
}

