/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.Color;
import java.awt.Dimension;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.BoxView;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class LabelArea
extends JLabel {
    private boolean locked;
    private String originalText;
    private int preferredWidth = 300;
    private boolean scrollable;
    public static final int PREFERRED_WIDTH = 300;

    public LabelArea() {
    }

    public LabelArea(Icon icon) {
        super(icon);
    }

    public LabelArea(Icon icon, int horizontalAlignment) {
        super(icon, horizontalAlignment);
    }

    public LabelArea(String text) {
        super(text);
    }

    public LabelArea(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public LabelArea(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    private String convertToHTML() {
        if (StringTools.stringIsEmpty((String)this.originalText) || BasicHTML.isHTMLString(this.originalText)) {
            return this.originalText;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<HTML><BODY");
        if (!this.isEnabled()) {
            Class[] parameterTypes = new Class[]{Color.class};
            Object[] parameterValues = new Object[]{this.getBackground().darker()};
            String foregroundColor = (String)ClassTools.invokeStaticMethod(CSS.class, (String)"colorToHex", (Class[])parameterTypes, (Object[])parameterValues);
            sb.append(" TEXT=\"");
            sb.append(foregroundColor);
            sb.append("\"");
        }
        sb.append(">");
        int mnemonicIndex = this.getDisplayedMnemonicIndex();
        if (mnemonicIndex > -1) {
            sb.append(this.originalText.substring(0, mnemonicIndex));
            sb.append("<U>");
            sb.append(this.originalText.charAt(mnemonicIndex));
            sb.append("</U>");
            sb.append(this.originalText.substring(mnemonicIndex + 1));
        } else {
            sb.append(this.originalText);
        }
        sb.append("</BODY></HTML>");
        return sb.toString();
    }

    private int findDisplayedMnemonicIndex() {
        int mnemonic = this.getDisplayedMnemonic();
        if (this.originalText == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = this.originalText.indexOf(uc);
        int lci = this.originalText.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleLabelArea();
        }
        return this.accessibleContext;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        View rootView = (View)this.getClientProperty("html");
        if (rootView != null && !this.isPreferredSizeSet()) {
            BoxView view = (BoxView)rootView.getView(0);
            if (this.scrollable) {
                int width = (int)rootView.getMinimumSpan(0);
                int height = (int)rootView.getMinimumSpan(1);
                Dimension size = super.getPreferredSize();
                size.width = Math.min(width, size.width);
                size.height = Math.max(height, size.height);
                return size;
            }
            float width = Math.min((int)view.getPreferredSpan(0), this.preferredWidth);
            view.setSize(width, 0.0f);
            float height = view.getPreferredSpan(1);
            rootView.setSize(width, height);
        }
        return super.getPreferredSize();
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
        if (this.locked) {
            return;
        }
        try {
            this.locked = true;
            super.setDisplayedMnemonicIndex(index);
        }
        finally {
            this.locked = false;
        }
        this.setText(this.originalText);
    }

    public void setPreferredWidth(int preferredWidth) {
        if (preferredWidth < 0) {
            throw new IllegalArgumentException("Preferred width cannot be negative");
        }
        this.preferredWidth = preferredWidth;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String text) {
        this.originalText = text;
        text = this.convertToHTML();
        try {
            this.locked = true;
            super.setText(text);
            super.setDisplayedMnemonicIndex(this.findDisplayedMnemonicIndex());
        }
        finally {
            this.locked = false;
        }
    }

    protected class AccessibleLabelArea
    extends JLabel.AccessibleJLabel {
        protected AccessibleLabelArea() {
            super(LabelArea.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (LabelArea.this.originalText == null) {
                return null;
            }
            return LabelArea.this.originalText.replaceAll("<[Bb][Rr](\\s)?(/)?>|<(/)?[Pp]>", " ");
        }
    }
}

