/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.helper.IdentityHashSet;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups.BaseFetchGroupTests;
import org.junit.Test;

public class NestedFetchGroupTests
extends BaseFetchGroupTests {
    public NestedFetchGroupTests() {
    }

    public NestedFetchGroupTests(String name) {
        super(name);
    }

    public static junit.framework.Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("NestedFetchGroupTests");
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("testSetup"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("dynamicFetchGroup_EmployeeAddress"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("dynamicFetchGroup_Employee_NullAddress"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("dynamicFetchGroup_EmployeeAddressNullPhone"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("dynamicFetchGroup_EmployeeAddressEmptyPhone"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("dynamicFetchGroup_EmployeeAddressEmptyPhoneLoad"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("dynamicHierarchicalFetchGroup"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("dynamicHierarchicalFetchGroup_JOIN_FETCH_Copy"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("managerTripleNestedFetchGroupWithJoinFetch"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("allNestedFetchGroupWithJoinFetch"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("joinFetchDefaultFetchGroup"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("joinFetchOutsideOfFetchGroup"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("simpleNestedFetchGroupWithBatch"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("simpleLoadGroup"));
        suite.addTest((junit.framework.Test)new NestedFetchGroupTests("simpleFetchGroupLoadWithBatch"));
        return suite;
    }

    @Override
    public void setUp() {
        super.setUp();
        defaultPhoneFG = new FetchGroup();
        defaultPhoneFG.addAttribute("number");
        this.phoneDescriptor.getFetchGroupManager().setDefaultFetchGroup(defaultPhoneFG);
        this.reprepareReadQueries(this.phoneDescriptor);
        this.reprepareReadQueries(this.employeeDescriptor);
        NestedFetchGroupTests.assertNotNull((Object)this.phoneDescriptor.getDefaultFetchGroup());
        NestedFetchGroupTests.assertNotNull((Object)this.phoneDescriptor.getDescriptorQueryManager().getReadObjectQuery().getExecutionFetchGroup());
        NestedFetchGroupTests.assertTrue((boolean)this.phoneDescriptor.getFetchGroupManager().getFetchGroups().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dynamicFetchGroup_EmployeeAddress() throws Exception {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
            query.setParameter("GENDER", (Object)Employee.Gender.Male);
            FetchGroup fg = new FetchGroup();
            fg.addAttribute("id");
            fg.addAttribute("version");
            fg.addAttribute("firstName");
            fg.addAttribute("lastName");
            fg.addAttribute("address.city");
            fg.addAttribute("address.postalCode");
            query.setHint("eclipselink.fetch-group", (Object)fg);
            List emps = query.getResultList();
            NestedFetchGroupTests.assertNotNull((Object)emps);
            for (Employee emp : emps) {
                FetchGroupTracker tracker = (FetchGroupTracker)emp;
                NestedFetchGroupTests.assertNotNull((Object)tracker._persistence_getFetchGroup());
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("address"));
                FetchGroupTracker addrTracker = (FetchGroupTracker)emp.getAddress();
                NestedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("city"));
                NestedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("postalCode"));
                NestedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("street"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("endTime"));
                emp.getSalary();
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("address"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("endTime"));
                addrTracker = (FetchGroupTracker)emp.getAddress();
                NestedFetchGroupTests.assertNotNull((String)"Address does not have a FetchGroup", (Object)addrTracker._persistence_getFetchGroup());
                NestedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("city"));
                NestedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("postalCode"));
                NestedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("street"));
                NestedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("country"));
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    FetchGroupTracker phoneTracker = (FetchGroupTracker)phone;
                    NestedFetchGroupTests.assertNotNull((String)"PhoneNumber does not have a FetchGroup", (Object)phoneTracker._persistence_getFetchGroup());
                    NestedFetchGroupTests.assertTrue((boolean)phoneTracker._persistence_isAttributeFetched("number"));
                    NestedFetchGroupTests.assertFalse((boolean)phoneTracker._persistence_isAttributeFetched("areaCode"));
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dynamicFetchGroup_Employee_NullAddress() throws Exception {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
            query.setParameter("GENDER", (Object)Employee.Gender.Male);
            FetchGroup empGroup = new FetchGroup();
            empGroup.addAttribute("firstName");
            empGroup.addAttribute("lastName");
            empGroup.addAttribute("address");
            FetchGroup addressGroup = new FetchGroup();
            addressGroup.addAttribute("city");
            addressGroup.addAttribute("postalCode");
            empGroup.addAttribute("address");
            query.setHint("eclipselink.fetch-group", (Object)empGroup);
            List emps = query.getResultList();
            NestedFetchGroupTests.assertNotNull((Object)emps);
            for (Employee emp : emps) {
                FetchGroupTracker tracker = (FetchGroupTracker)emp;
                NestedFetchGroupTests.assertNotNull((Object)tracker._persistence_getFetchGroup());
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("id"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("version"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("endTime"));
                emp.getSalary();
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("endTime"));
                FetchGroupTracker addrTracker = (FetchGroupTracker)emp.getAddress();
                NestedFetchGroupTests.assertNull((String)"Address has an unexpected FetchGroup", (Object)addrTracker._persistence_getFetchGroup());
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    FetchGroupTracker phoneTracker = (FetchGroupTracker)phone;
                    NestedFetchGroupTests.assertNotNull((String)"PhoneNumber does not have a FetchGroup", (Object)phoneTracker._persistence_getFetchGroup());
                    NestedFetchGroupTests.assertTrue((boolean)phoneTracker._persistence_isAttributeFetched("number"));
                    NestedFetchGroupTests.assertFalse((boolean)phoneTracker._persistence_isAttributeFetched("areaCode"));
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dynamicFetchGroup_EmployeeAddressNullPhone() throws Exception {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
            query.setParameter("GENDER", (Object)Employee.Gender.Male);
            FetchGroup empGroup = new FetchGroup();
            empGroup.addAttribute("firstName");
            empGroup.addAttribute("lastName");
            empGroup.addAttribute("address");
            empGroup.addAttribute("address.city");
            empGroup.addAttribute("address.postalCode");
            FetchGroup fullPhone = this.phoneDescriptor.getFetchGroupManager().createFullFetchGroup();
            fullPhone.addAttribute("owner.id");
            empGroup.addAttribute("phoneNumbers", fullPhone);
            query.setHint("eclipselink.fetch-group", (Object)empGroup);
            List emps = query.getResultList();
            NestedFetchGroupTests.assertNotNull((Object)emps);
            for (Employee emp : emps) {
                FetchGroupTracker tracker = (FetchGroupTracker)emp;
                NestedFetchGroupTests.assertNotNull((Object)tracker._persistence_getFetchGroup());
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("id"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("version"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("endTime"));
                emp.getSalary();
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("endTime"));
                FetchGroupTracker addrTracker = (FetchGroupTracker)emp.getAddress();
                NestedFetchGroupTests.assertNotNull((String)"Address does not have a FetchGroup", (Object)addrTracker._persistence_getFetchGroup());
                NestedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("city"));
                NestedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("postalCode"));
                NestedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("street"));
                NestedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("country"));
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    FetchGroupTracker phoneTracker = (FetchGroupTracker)phone;
                    NestedFetchGroupTests.assertNull((String)"PhoneNumber has a FetchGroup", (Object)phoneTracker._persistence_getFetchGroup());
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @Test
    public void dynamicFetchGroup_EmployeeAddressEmptyPhone() {
    }

    public void dynamicFetchGroup_EmployeeAddressEmptyPhoneLoad() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internal_dynamicFetchGroup_EmployeeAddressEmptyPhone(boolean shouldLoad) {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
            query.setParameter("GENDER", (Object)Employee.Gender.Male);
            FetchGroup fg = new FetchGroup();
            fg.addAttribute("firstName");
            fg.addAttribute("lastName");
            fg.addAttribute("address.city");
            fg.addAttribute("address.postalCode");
            FetchGroup ownerId = new FetchGroup();
            ownerId.addAttribute("owner.id");
            fg.addAttribute("phoneNumbers", ownerId);
            if (shouldLoad) {
                fg.setShouldLoad(true);
            }
            query.setHint("eclipselink.fetch-group", (Object)fg);
            List emps = query.getResultList();
            NestedFetchGroupTests.assertNotNull((Object)emps);
            NestedFetchGroupTests.assertEquals((int)(1 + (shouldLoad ? 0 : emps.size() * 2)), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (Employee emp : emps) {
                FetchGroupTracker tracker = (FetchGroupTracker)emp;
                NestedFetchGroupTests.assertNotNull((Object)tracker._persistence_getFetchGroup());
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("id"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("version"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("endTime"));
                emp.getSalary();
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("salary"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("startTime"));
                NestedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("endTime"));
                FetchGroupTracker addrTracker = (FetchGroupTracker)emp.getAddress();
                NestedFetchGroupTests.assertNotNull((String)"Address does not have a FetchGroup", (Object)addrTracker._persistence_getFetchGroup());
                NestedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("city"));
                NestedFetchGroupTests.assertTrue((boolean)addrTracker._persistence_isAttributeFetched("postalCode"));
                NestedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("street"));
                NestedFetchGroupTests.assertFalse((boolean)addrTracker._persistence_isAttributeFetched("country"));
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    FetchGroupTracker phoneTracker = (FetchGroupTracker)phone;
                    NestedFetchGroupTests.assertNotNull((String)"PhoneNumber does not have a FetchGroup", (Object)phoneTracker._persistence_getFetchGroup());
                    NestedFetchGroupTests.assertFalse((boolean)phoneTracker._persistence_isAttributeFetched("number"));
                    NestedFetchGroupTests.assertFalse((boolean)phoneTracker._persistence_isAttributeFetched("areaCode"));
                    phone.getNumber();
                    NestedFetchGroupTests.assertTrue((boolean)phoneTracker._persistence_isAttributeFetched("number"));
                    NestedFetchGroupTests.assertTrue((boolean)phoneTracker._persistence_isAttributeFetched("areaCode"));
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @Test
    public void dynamicHierarchicalFetchGroup() throws Exception {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName LIKE :LNAME AND e.manager.lastName <> e.lastName");
        query.setParameter("LNAME", (Object)"%");
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("firstName");
        fg.addAttribute("lastName");
        fg.addAttribute("salary");
        fg.addAttribute("gender");
        fg.addAttribute("manager.firstName");
        fg.addAttribute("manager.lastName");
        fg.addAttribute("manager.salary");
        fg.addAttribute("manager.gender");
        fg.addAttribute("manager.manager.firstName");
        fg.addAttribute("manager.manager.lastName");
        fg.addAttribute("manager.manager.salary");
        fg.addAttribute("manager.manager.gender");
        query.setHint("eclipselink.fetch-group", (Object)fg);
        List emps = query.getResultList();
        int numSelect = this.getQuerySQLTracker(em).getTotalSQLSELECTCalls();
        for (Employee emp : emps) {
            NestedFetchGroupTests.assertFetched((Object)emp, fg);
        }
        NestedFetchGroupTests.assertEquals((int)numSelect, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
    }

    @Test
    public void dynamicHierarchicalFetchGroup_JOIN_FETCH() throws Exception {
        this.internalDynamicHierarchicalFetchGroup_JOIN_FETCH(false);
    }

    @Test
    public void dynamicHierarchicalFetchGroup_JOIN_FETCH_Copy() throws Exception {
        this.internalDynamicHierarchicalFetchGroup_JOIN_FETCH(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalDynamicHierarchicalFetchGroup_JOIN_FETCH(boolean useCopy) throws Exception {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.manager WHERE e.lastName LIKE :LNAME AND e.manager.lastName <> e.lastName");
            query.setParameter("LNAME", (Object)"%");
            FetchGroup fg = new FetchGroup();
            fg.addAttribute("firstName");
            fg.addAttribute("lastName");
            fg.addAttribute("manager.firstName");
            fg.addAttribute("manager.salary");
            fg.addAttribute("manager.manager");
            query.setHint("eclipselink.fetch-group", (Object)fg);
            EntityFetchGroup employeeFG = new EntityFetchGroup(new String[]{"id", "version", "firstName", "lastName", "manager"});
            EntityFetchGroup managerFG = new EntityFetchGroup(new String[]{"id", "version", "firstName", "salary", "manager"});
            EntityFetchGroup employeeManagerFG = this.employeeDescriptor.getFetchGroupManager().flatUnionFetchGroups((FetchGroup)employeeFG, (FetchGroup)managerFG);
            EntityFetchGroup employeeManagerManagerFG = null;
            if (useCopy) {
                employeeManagerManagerFG = this.employeeDescriptor.getFetchGroupManager().flatUnionFetchGroups((FetchGroup)new EntityFetchGroup("manager"), (FetchGroup)this.employeeDescriptor.getFetchGroupManager().getNonReferenceEntityFetchGroup());
            }
            List emps = query.getResultList();
            if (useCopy) {
                emps = (List)JpaHelper.getEntityManager((EntityManager)em).copy((Object)emps, (AttributeGroup)fg);
            }
            IdentityHashMap<Employee, Set> managedEmployeesByManager = new IdentityHashMap<Employee, Set>();
            for (Employee emp : emps) {
                Employee manager = emp.getManager();
                Set managedEmployees = (Set)managedEmployeesByManager.get(manager);
                if (managedEmployees == null) {
                    managedEmployees = new IdentityHashSet();
                    managedEmployeesByManager.put(manager, managedEmployees);
                }
                managedEmployees.add(emp);
            }
            for (Employee emp : emps) {
                Set managedEmployees = (Set)managedEmployeesByManager.get(emp);
                Employee manager = emp.getManager();
                if (managedEmployees == null) {
                    NestedFetchGroupTests.assertFetched((Object)emp, (FetchGroup)employeeFG);
                    Set managedByManagerEmployees = (Set)managedEmployeesByManager.get(manager);
                    boolean isManagersManager = false;
                    for (Employee managedEmp : managedByManagerEmployees) {
                        if (!managedEmployeesByManager.containsKey(managedEmp)) continue;
                        isManagersManager = true;
                        break;
                    }
                    if (isManagersManager) {
                        if (useCopy) {
                            NestedFetchGroupTests.assertFetched((Object)manager, (FetchGroup)employeeManagerManagerFG);
                            continue;
                        }
                        NestedFetchGroupTests.assertNoFetchGroup(manager);
                        continue;
                    }
                    if (emps.contains(manager)) {
                        NestedFetchGroupTests.assertFetched((Object)manager, (FetchGroup)employeeManagerFG);
                        continue;
                    }
                    NestedFetchGroupTests.assertFetched((Object)manager, (FetchGroup)managerFG);
                    continue;
                }
                boolean isManagersManager = false;
                for (Employee managedEmp : managedEmployees) {
                    if (!managedEmployeesByManager.containsKey(managedEmp)) continue;
                    isManagersManager = true;
                    break;
                }
                if (isManagersManager) {
                    if (useCopy) {
                        NestedFetchGroupTests.assertFetched((Object)emp, (FetchGroup)employeeManagerManagerFG);
                    } else {
                        NestedFetchGroupTests.assertNoFetchGroup(emp);
                    }
                } else {
                    NestedFetchGroupTests.assertFetched((Object)emp, (FetchGroup)employeeManagerFG);
                }
                if (useCopy) {
                    NestedFetchGroupTests.assertFetched((Object)manager, (FetchGroup)employeeManagerManagerFG);
                    continue;
                }
                NestedFetchGroupTests.assertNoFetchGroup(manager);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @Test
    public void managerDoubleNestedFetchGroupWithJoinFetch() {
        this.managerNestedFetchGroupWithJoinFetch(true);
    }

    @Test
    public void managerTripleNestedFetchGroupWithJoinFetch() {
        this.managerNestedFetchGroupWithJoinFetch(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void managerNestedFetchGroupWithJoinFetch(boolean isDouble) {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            int nSql;
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.manager.manager IS NOT NULL");
            FetchGroup managerFG = new FetchGroup();
            if (isDouble) {
                managerFG.addAttribute("manager.manager");
            } else {
                managerFG.addAttribute("manager.manager.manager");
            }
            query.setHint("eclipselink.fetch-group", (Object)managerFG);
            query.setHint("eclipselink.left-join-fetch", (Object)"e.manager");
            NestedFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
            NestedFetchGroupTests.assertSame((Object)managerFG, (Object)this.getFetchGroup(query));
            List employees = query.getResultList();
            if (isDouble) {
                nSql = this.getQuerySQLTracker(em).getTotalSQLSELECTCalls();
            } else {
                NestedFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
                nSql = 1;
            }
            Employee emp = (Employee)employees.get(0);
            NestedFetchGroupTests.assertFetched((Object)emp, managerFG);
            Employee manager = emp.getManager();
            NestedFetchGroupTests.assertEquals((int)nSql, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            NestedFetchGroupTests.assertFetched((Object)manager, managerFG);
            emp.getLastName();
            NestedFetchGroupTests.assertNoFetchGroup(emp);
            NestedFetchGroupTests.assertEquals((int)(++nSql), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            NestedFetchGroupTests.assertFetched((Object)manager, managerFG);
            manager.getLastName();
            NestedFetchGroupTests.assertNoFetchGroup(manager);
            NestedFetchGroupTests.assertEquals((int)(++nSql), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            ++nSql;
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                NestedFetchGroupTests.assertFetched((Object)phone, defaultPhoneFG);
                phone.getAreaCode();
                ++nSql;
                NestedFetchGroupTests.assertNoFetchGroup(phone);
            }
            NestedFetchGroupTests.assertEquals((int)nSql, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            ++nSql;
            for (PhoneNumber phone : manager.getPhoneNumbers()) {
                NestedFetchGroupTests.assertFetched((Object)phone, defaultPhoneFG);
                phone.getAreaCode();
                ++nSql;
                NestedFetchGroupTests.assertNoFetchGroup(phone);
            }
            NestedFetchGroupTests.assertEquals((int)nSql, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void allNestedFetchGroupWithJoinFetch() {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE NOT EXISTS(SELECT p.id FROM Project p WHERE p.teamLeader = e) AND NOT EXISTS(SELECT e2.id FROM Employee e2 WHERE e2.manager = e)");
            FetchGroup employeeFG = new FetchGroup("employee");
            employeeFG.addAttribute("lastName");
            employeeFG.addAttribute("address.country");
            employeeFG.addAttribute("address.city");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.address");
            employeeFG.addAttribute("phoneNumbers");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.phoneNumbers");
            employeeFG.addAttribute("projects.name");
            employeeFG.addAttribute("projects.teamLeader.firstName");
            employeeFG.addAttribute("projects.teamLeader.phoneNumbers.owner");
            employeeFG.addAttribute("projects.teamLeader.phoneNumbers.type");
            employeeFG.addAttribute("projects.teamLeader.phoneNumbers.areaCode");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.projects.teamLeader.phoneNumbers");
            employeeFG.addAttribute("manager.firstName");
            employeeFG.addAttribute("manager.phoneNumbers.owner");
            employeeFG.addAttribute("manager.phoneNumbers.type");
            employeeFG.addAttribute("manager.phoneNumbers.areaCode");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.manager.phoneNumbers");
            employeeFG.addAttribute("department.name");
            query.setHint("eclipselink.fetch-group", (Object)employeeFG);
            List employees = query.getResultList();
            NestedFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (Employee emp : employees) {
                Department department;
                NestedFetchGroupTests.assertFetched((Object)emp, employeeFG);
                Address address = emp.getAddress();
                if (address != null) {
                    NestedFetchGroupTests.assertFetched((Object)address, employeeFG.getGroup("address"));
                }
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    NestedFetchGroupTests.assertFetched((Object)phone, defaultPhoneFG);
                }
                for (Project project : emp.getProjects()) {
                    NestedFetchGroupTests.assertFetched((Object)project, employeeFG.getGroup("projects"));
                    Employee teamLeader = project.getTeamLeader();
                    if (teamLeader == null) continue;
                    NestedFetchGroupTests.assertFetched((Object)teamLeader, employeeFG.getGroup("projects.teamLeader"));
                    for (PhoneNumber phone : teamLeader.getPhoneNumbers()) {
                        NestedFetchGroupTests.assertFetched((Object)phone, employeeFG.getGroup("projects.teamLeader.phoneNumbers"));
                    }
                }
                Employee manager = emp.getManager();
                if (manager != null) {
                    NestedFetchGroupTests.assertFetched((Object)manager, employeeFG.getGroup("manager"));
                    for (PhoneNumber phone : manager.getPhoneNumbers()) {
                        NestedFetchGroupTests.assertFetched((Object)phone, employeeFG.getGroup("manager.phoneNumbers"));
                    }
                }
                if ((department = emp.getDepartment()) == null) continue;
                NestedFetchGroupTests.assertFetched((Object)department, employeeFG.getGroup("department"));
            }
            NestedFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @Test
    public void joinFetchDefaultFetchGroup() throws Exception {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e");
        query.setHint("eclipselink.left-join-fetch", (Object)"e.phoneNumbers");
        List employees = query.getResultList();
        for (Employee emp : employees) {
            NestedFetchGroupTests.assertNoFetchGroup(emp);
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                NestedFetchGroupTests.assertFetched((Object)phone, defaultPhoneFG);
            }
        }
    }

    @Test
    public void joinFetchOutsideOfFetchGroup() throws Exception {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e");
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("firstName");
        fg.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fg);
        query.setHint("eclipselink.left-join-fetch", (Object)"e.address");
        List employees = query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleNestedFetchGroupWithBatch() {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            Address address;
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e");
            FetchGroup employeeFG = new FetchGroup();
            employeeFG.setShouldLoad(true);
            employeeFG.addAttribute("firstName");
            employeeFG.addAttribute("lastName");
            employeeFG.addAttribute("address.country");
            employeeFG.addAttribute("address.city");
            FetchGroup phonesFG = defaultPhoneFG.clone();
            phonesFG.addAttribute("owner.id");
            employeeFG.addAttribute("phoneNumbers", phonesFG);
            FetchGroup projectsFG = new FetchGroup("projects");
            projectsFG.addAttribute("name");
            projectsFG.addAttribute("name");
            projectsFG.addAttribute("teamMembers.id");
            projectsFG.addAttribute("teamLeader.id");
            employeeFG.addAttribute("projects", projectsFG);
            query.setHint("eclipselink.fetch-group", (Object)employeeFG);
            query.setHint("eclipselink.batch", (Object)"e.address");
            query.setHint("eclipselink.batch", (Object)"e.phoneNumbers");
            query.setHint("eclipselink.batch", (Object)"e.projects");
            query.setHint("eclipselink.inheritance.outer-join", (Object)"true");
            List employees = query.getResultList();
            NestedFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (Employee emp : employees) {
                NestedFetchGroupTests.assertFetched((Object)emp, employeeFG);
                address = emp.getAddress();
                if (address != null) {
                    NestedFetchGroupTests.assertFetched((Object)address, employeeFG.getGroup("address"));
                }
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    NestedFetchGroupTests.assertFetched((Object)phone, phonesFG);
                }
                for (Project project : emp.getProjects()) {
                    NestedFetchGroupTests.assertFetched((Object)project, projectsFG);
                }
            }
            for (Employee emp : employees) {
                emp.getSalary();
                NestedFetchGroupTests.assertNoFetchGroup(emp);
                address = emp.getAddress();
                if (address != null) {
                    address.getStreet();
                    NestedFetchGroupTests.assertNoFetchGroup(address);
                }
                for (PhoneNumber phone : emp.getPhoneNumbers()) {
                    phone.getAreaCode();
                    NestedFetchGroupTests.assertNoFetchGroup(phone);
                }
                for (Project project : emp.getProjects()) {
                    project.getDescription();
                    NestedFetchGroupTests.assertNoFetchGroup(project);
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleLoadGroup() {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
            query.setParameter("GENDER", (Object)Employee.Gender.Female);
            List employees = query.getResultList();
            LoadGroup group = new LoadGroup();
            group.addAttribute("address");
            group.addAttribute("phoneNumbers");
            group.addAttribute("manager.projects");
            ((AbstractSession)((EntityManagerImpl)em.getDelegate()).getActiveSession()).load((Object)employees, (AttributeGroup)group);
            int numSelectBefore = this.getQuerySQLTracker(em).getTotalSQLSELECTCalls();
            for (Employee emp : employees) {
                emp.getAddress();
                emp.getPhoneNumbers().size();
                if (emp.getManager() == null) continue;
                emp.getManager().getProjects().size();
            }
            int numSelectAfter = this.getQuerySQLTracker(em).getTotalSQLSELECTCalls();
            NestedFetchGroupTests.assertEquals((int)numSelectBefore, (int)numSelectAfter);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleFetchGroupLoadWithBatch() {
        EntityManager em = NestedFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            FetchGroup projectGroup = new FetchGroup();
            projectGroup.addAttribute("name");
            FetchGroup employeeGroup = new FetchGroup();
            employeeGroup.addAttribute("firstName");
            employeeGroup.addAttribute("lastName");
            employeeGroup.addAttribute("projects", projectGroup);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.gender = :GENDER");
            query.setParameter("GENDER", (Object)Employee.Gender.Female);
            query.setHint("eclipselink.fetch-group", (Object)employeeGroup);
            query.setHint("eclipselink.fetch-group.load", (Object)"true");
            query.setHint("eclipselink.batch", (Object)"e.projects");
            List employees = query.getResultList();
            int numSelectBefore = this.getQuerySQLTracker(em).getTotalSQLSELECTCalls();
            for (Employee e : employees) {
                e.getProjects().size();
            }
            int numSelectAfter = this.getQuerySQLTracker(em).getTotalSQLSELECTCalls();
            NestedFetchGroupTests.assertEquals((int)numSelectBefore, (int)numSelectAfter);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

