/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAsmFactory;
import org.eclipse.persistence.internal.jpa.weaving.PersistenceWeaver;
import org.eclipse.persistence.internal.jpa.weaving.TransformerFactory;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.models.weaving.SimpleObject;
import org.eclipse.persistence.testing.models.weaving.SimpleProject;
import org.eclipse.persistence.testing.tests.weaving.SimpleClassLoader;

public class SimpleWeaverTestSuite
extends TestCase {
    public static SimpleClassLoader simpleClassLoader = null;
    public static byte[] originalBytes = null;
    public static Collection entities = null;

    public static void setUpFixtures() {
        simpleClassLoader = new SimpleClassLoader();
        InputStream is = simpleClassLoader.getResourceAsStream(SimpleObject.class.getName().replace('.', '/') + ".class");
        originalBytes = SimpleWeaverTestSuite.readStreamContentsIntoByteArray(is);
        entities = new ArrayList();
        entities.add(new MetadataAsmFactory(new MetadataLogger(null), SimpleWeaverTestSuite.class.getClassLoader()).getMetadataClass(SimpleObject.class.getName()));
    }

    public static void tearDownFixtures() {
        simpleClassLoader = null;
        originalBytes = null;
        entities = null;
    }

    public SimpleWeaverTestSuite(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Simple TopLinkWeaver Tests");
        suite.addTest((Test)new SimpleWeaverTestSuite("test TopLinkWeaver with null Session"){

            public void setUp() {
            }

            public void tearDown() {
            }

            public void runTest() {
                this.nullSessionTest();
            }
        });
        suite.addTest((Test)new SimpleWeaverTestSuite("test TopLinkWeaver with null Project"){

            public void setUp() {
            }

            public void tearDown() {
            }

            public void runTest() {
                ServerSession session = new ServerSession();
                session.setLogLevel(8);
                this.nullProjectTest((Session)session);
            }
        });
        suite.addTest((Test)new SimpleWeaverTestSuite("test TopLinkWeaver with null list of entities"){

            public void setUp() {
            }

            public void tearDown() {
            }

            public void runTest() {
                ServerSession session = new ServerSession((Project)new SimpleProject());
                session.setLogLevel(8);
                this.nullEntitiesTest((Session)session);
            }
        });
        suite.addTest((Test)new SimpleWeaverTestSuite("test TopLinkWeaver with empty list of entities"){

            public void setUp() {
            }

            public void tearDown() {
            }

            public void runTest() {
                ServerSession session = new ServerSession((Project)new SimpleProject());
                session.setLogLevel(8);
                this.emptyEntitiesTest((Session)session);
            }
        });
        suite.addTest((Test)new SimpleWeaverTestSuite("build TopLinkWeaver"){

            public void setUp() {
            }

            public void tearDown() {
            }

            public void runTest() {
                ServerSession session = new ServerSession((Project)new SimpleProject());
                session.setLogLevel(8);
                this.buildWeaver((Session)session, entities);
            }
        });
        return suite;
    }

    public void nullSessionTest() {
        boolean expectedFailure = false;
        try {
            TransformerFactory.createTransformerAndModifyProject(null, null, (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)true, (boolean)false, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException iae) {
            expectedFailure = true;
        }
        SimpleWeaverTestSuite.assertTrue((String)"TopLinkWeaver did not throw proper IllegalArgumentException for null Session in constructor", (boolean)expectedFailure);
    }

    public void nullProjectTest(Session session) {
        boolean expectedFailure = false;
        try {
            TransformerFactory.createTransformerAndModifyProject((Session)session, null, (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)true, (boolean)false, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException iae) {
            expectedFailure = true;
        }
        SimpleWeaverTestSuite.assertTrue((String)"TopLinkWeaver did not throw proper IllegalArgumentException for null Session's Project in constructor", (boolean)expectedFailure);
    }

    public void nullEntitiesTest(Session session) {
        try {
            TransformerFactory.createTransformerAndModifyProject((Session)session, null, (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)true, (boolean)false, (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            SimpleWeaverTestSuite.fail((String)(this.getName() + " failed: " + e.toString()));
        }
    }

    public void emptyEntitiesTest(Session session) {
        try {
            TransformerFactory.createTransformerAndModifyProject((Session)session, new ArrayList(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)true, (boolean)false, (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            SimpleWeaverTestSuite.fail((String)(this.getName() + " failed: " + e.toString()));
        }
    }

    public PersistenceWeaver buildWeaver(Session session, Collection entities) {
        PersistenceWeaver tw = null;
        try {
            tw = TransformerFactory.createTransformerAndModifyProject((Session)session, (Collection)entities, (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)true, (boolean)false, (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            SimpleWeaverTestSuite.fail((String)(this.getName() + " failed: " + e.toString()));
        }
        SimpleWeaverTestSuite.assertNotNull((String)"could not build TopLinkWeaver", (Object)tw);
        return tw;
    }

    public void buildWeavedClass(byte[] weavedBytes) {
        Class<?> weavedClass = null;
        try {
            weavedClass = simpleClassLoader.define_class(SimpleObject.class.getName(), weavedBytes, 0, weavedBytes.length);
        }
        catch (Exception e) {
            SimpleWeaverTestSuite.fail((String)(this.getName() + " failed: " + e.toString()));
        }
        SimpleWeaverTestSuite.assertNotNull((String)"could not build weaved class", weavedClass);
        Class<?>[] interfaces = null;
        try {
            interfaces = weavedClass.getInterfaces();
        }
        catch (Exception e) {
            SimpleWeaverTestSuite.fail((String)(this.getName() + " failed: " + e.toString()));
        }
        SimpleWeaverTestSuite.assertNotNull((String)"Weaved class has no interfaces", interfaces);
        boolean containsSerializable = false;
        boolean containsTopLinkWeaved = false;
        boolean containsChangeTracker = false;
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c = interfaces[i];
            if (c.equals(Serializable.class)) {
                containsSerializable = true;
            }
            if (!c.equals(PersistenceWeavedLazy.class)) continue;
            containsTopLinkWeaved = true;
        }
        SimpleWeaverTestSuite.assertNotNull((String)"Weaved class does not implement Serializable", (Object)containsSerializable);
        SimpleWeaverTestSuite.assertNotNull((String)"Weaved class does not implement TopLinkWeaved", (Object)containsTopLinkWeaved);
        SimpleWeaverTestSuite.assertNotNull((String)"Weaved class does not implement ChangeTracker", (Object)containsChangeTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStreamContentsIntoByteArray(InputStream is) {
        byte[] result = null;
        try {
            int bytesRead;
            int readPosition = 0;
            result = new byte[is.available()];
            while ((bytesRead = is.read(result, readPosition, result.length - readPosition)) != -1) {
                if ((readPosition += bytesRead) != result.length) continue;
                int peek = is.read();
                if (peek == -1) break;
                byte[] temp = new byte[result.length * 2];
                System.arraycopy(result, 0, temp, 0, readPosition);
                result = temp;
                result[readPosition++] = (byte)peek;
            }
            if (readPosition < result.length) {
                byte[] temp = new byte[readPosition];
                System.arraycopy(result, 0, temp, 0, readPosition);
                result = temp;
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    static {
        SimpleWeaverTestSuite.setUpFixtures();
    }
}

