/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.security;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.tests.security.DatabaseLoginWithNoEncryptorTest;
import org.eclipse.persistence.testing.tests.security.JCEEncryptionTest;
import org.eclipse.persistence.testing.tests.validation.SecurityOnFindMethodTest;
import org.eclipse.persistence.testing.tests.validation.SecurityOnInitializingAttributeMethodTest;
import org.eclipse.persistence.testing.tests.validation.SecurityWhileConvertingToMethodTest;
import org.eclipse.persistence.testing.tests.validation.SecurityWhileInitializingAttributesInInstanceVariableAccessorTest;
import org.eclipse.persistence.testing.tests.validation.SecurityWhileInitializingAttributesInMethodAccessorTest;
import org.eclipse.persistence.testing.tests.validation.SecurityWhileInitializingClassExtractionMethodTest;
import org.eclipse.persistence.testing.tests.validation.SecurityWhileInitializingCopyPolicyTest;
import org.eclipse.persistence.testing.tests.validation.SecurityWhileInitializingInstantiationPolicyTest;

public class SecurityTestModel
extends TestModel {
    public SecurityTestModel() {
        this.setDescription("This model tests the security features of TopLink.");
    }

    public void addRequiredSystems() {
    }

    public void addTests() {
        this.addTest((Test)SecurityTestModel.getJCETestSuite());
        this.addTest((Test)SecurityTestModel.getValidationSecurityTestSuite());
        this.addTest((Test)new DatabaseLoginWithNoEncryptorTest());
    }

    public static TestSuite getJCETestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JCEEncryptor");
        suite.setDescription("This suite tests the TopLink password encryption schemes");
        suite.addTest((Test)new JCEEncryptionTest());
        return suite;
    }

    public static TestSuite getValidationSecurityTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Validation Security Tests");
        suite.setDescription("This suite includes Validation tests on security (Tests originally in validation model)");
        suite.addTest((Test)new SecurityWhileInitializingInstantiationPolicyTest());
        suite.addTest((Test)new SecurityOnFindMethodTest());
        suite.addTest((Test)new SecurityOnInitializingAttributeMethodTest());
        suite.addTest((Test)new SecurityWhileConvertingToMethodTest());
        suite.addTest((Test)new SecurityWhileInitializingAttributesInInstanceVariableAccessorTest());
        suite.addTest((Test)new SecurityWhileInitializingAttributesInMethodAccessorTest());
        suite.addTest((Test)new SecurityWhileInitializingClassExtractionMethodTest());
        suite.addTest((Test)new SecurityWhileInitializingCopyPolicyTest());
        return suite;
    }
}

