/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListSplitPane;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWUserDefinedQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.QueryKeyCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class RelationalDescriptorQueryKeysPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel selectedQueryKeyHolder;
    private ListChooser fieldChooser;
    private AddRemoveListPanel queryKeyListPanel;

    public RelationalDescriptorQueryKeysPropertiesPage(PropertyValueModel node, WorkbenchContextHolder contextHolder) {
        super(node, contextHolder);
    }

    @Override
    protected void initialize(PropertyValueModel descriptorNodeHolder) {
        super.initialize(descriptorNodeHolder);
    }

    protected String helpTopicId() {
        return "descriptor.queryKeys";
    }

    @Override
    protected Component buildPage() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.selectedQueryKeyHolder = new SimplePropertyValueModel();
        this.queryKeyListPanel = new AddRemoveListPanel(this.getApplicationContext(), (AddRemovePanel.Adapter)this.buildAddRemoveListPanelAdapter(), this.buildSortedQueryKeysListValueModel(), this.resourceRepository().getString("QUERYKEYS"));
        this.queryKeyListPanel.setCellRenderer(this.buildAbstractQueryListCellRenderer());
        this.queryKeyListPanel.addListSelectionListener(this.buildListSelectionListener(this.queryKeyListPanel));
        AddRemoveListSplitPane addRemoveList = new AddRemoveListSplitPane(this.queryKeyListPanel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)addRemoveList, constraints);
        JPanel selectedQueryKeyPanel = new JPanel(new GridBagLayout());
        addRemoveList.setRightComponent(selectedQueryKeyPanel);
        JLabel fieldLabel = this.buildLabel("FIELD");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 10, 0, 0);
        selectedQueryKeyPanel.add((Component)fieldLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.fieldChooser = this.buildDatabaseFieldChooser();
        fieldLabel.setLabelFor(this.fieldChooser);
        this.fieldChooser.setEnabled(false);
        new ComponentEnabler(this.buildFieldChooserEnablerModel(this.queryKeyListPanel), Collections.singleton(this.fieldChooser));
        selectedQueryKeyPanel.add((Component)this.fieldChooser, constraints);
        this.addHelpTopicId(selectedQueryKeyPanel, this.helpTopicId() + ".field");
        Spacer spacer = new Spacer();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        selectedQueryKeyPanel.add((Component)spacer, constraints);
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    private AddRemovePanel.OptionAdapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.OptionAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                RelationalDescriptorQueryKeysPropertiesPage.this.addNewQueryKey(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                RelationalDescriptorQueryKeysPropertiesPage.this.removeSelectedQueryKeys(CollectionTools.iterator((Object[])listSelectionModel.getSelectedValues()));
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                RelationalDescriptorQueryKeysPropertiesPage.this.renameSelectedQueryKey(listSelectionModel);
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1 && !((MWQueryKey)listSelectionModel.getSelectedValue()).isAutoGenerated();
            }

            @Override
            public String optionalButtonKey() {
                return "RENAME_BUTTON";
            }
        };
    }

    private MWRelationalClassDescriptor descriptor() {
        return (MWRelationalClassDescriptor)this.getSelectionHolder().getValue();
    }

    private Iterator queryKeyNames() {
        return new TransformationIterator(this.descriptor().allQueryKeys()){

            protected Object transform(Object next) {
                return ((MWQueryKey)next).getName();
            }
        };
    }

    private ListValueModel buildSortedQueryKeysListValueModel() {
        return new SortedListValueModelAdapter(this.buildItemListValueModelAdapter());
    }

    private ListValueModel buildItemListValueModelAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildQueryKeysHolder(), "name");
    }

    private void addNewQueryKey(ObjectListSelectionModel listSelectionModel) {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("ADD_NEW_QUERYKEY"));
        builder.setTextFieldDescription(this.resourceRepository().getString("ENTER_NEW_QUERYKEY_NAME"));
        builder.setExistingNames(this.queryKeyNames());
        builder.setHelpTopicId("descriptor.queryKeys");
        NewNameDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasCanceled()) {
            return;
        }
        MWUserDefinedQueryKey newQueryKey = this.descriptor().addQueryKey(dialog.getNewName(), null);
        listSelectionModel.setSelectedValue(newQueryKey);
    }

    private void renameSelectedQueryKey(ObjectListSelectionModel listSelectionModel) {
        MWUserDefinedQueryKey queryKey = (MWUserDefinedQueryKey)listSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(this.queryKeyNames());
        builder.setOriginalName(queryKey.getName());
        builder.setTextFieldDescription(this.resourceRepository().getString("RENAME_QUERYKEY_MESSAGE"));
        builder.setTitle(this.resourceRepository().getString("RENAME_QUERYKEY_TITLE", queryKey.getName()));
        builder.setHelpTopicId("dialog.queryKeyRename");
        NewNameDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasCanceled()) {
            return;
        }
        String newQueryKeyName = dialog.getNewName();
        queryKey.setName(newQueryKeyName);
        listSelectionModel.setSelectedValue(queryKey);
    }

    private void removeSelectedQueryKeys(Iterator queryKeys) {
        while (queryKeys.hasNext()) {
            this.removeSelectedQueryKey((MWQueryKey)queryKeys.next());
        }
    }

    private void removeSelectedQueryKey(MWQueryKey queryKey) {
        if (queryKey.isAutoGenerated()) {
            JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("CANNOT_REMOVE_AUTOGENERATED"), this.resourceRepository().getString("QUERYKEY_REMOVE"), 2);
        } else {
            queryKey.getDescriptor().removeQueryKey((MWUserDefinedQueryKey)queryKey);
        }
    }

    private ListChooser buildDatabaseFieldChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(RelationalMappingComponentFactory.buildExtendedColumnComboBoxModel(this.buildFieldHolder(), this.getSelectionHolder()), this.getWorkbenchContextHolder(), RelationalMappingComponentFactory.buildColumnNodeSelector(this.getWorkbenchContextHolder()), RelationalMappingComponentFactory.buildColumnChooserDialogBuilder());
        listChooser.setRenderer(RelationalMappingComponentFactory.buildColumnListRenderer(this.getSelectionHolder(), this.resourceRepository()));
        return listChooser;
    }

    private PropertyValueModel buildFieldHolder() {
        return new PropertyAspectAdapter(this.selectedQueryKeyHolder, "column"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWQueryKey)this.subject).getColumn();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWUserDefinedQueryKey)this.subject).setColumn((MWColumn)value);
            }
        };
    }

    private CollectionValueModel buildQueryKeysHolder() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "userDefinedQueryKeys"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWRelationalClassDescriptor)this.subject).allQueryKeys();
            }
        };
    }

    private ListCellRenderer buildAbstractQueryListCellRenderer() {
        return new AdaptableListCellRenderer(new QueryKeyCellRendererAdapter(this.resourceRepository()));
    }

    private ListSelectionListener buildListSelectionListener(final AddRemoveListPanel queryKeyListPanel) {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MWQueryKey qKey = (MWQueryKey)queryKeyListPanel.getSelectedValue();
                RelationalDescriptorQueryKeysPropertiesPage.this.selectedQueryKeyHolder.setValue(qKey);
                MWRelationalClassDescriptor descriptor = (MWRelationalClassDescriptor)RelationalDescriptorQueryKeysPropertiesPage.this.getSelectionHolder().getValue();
                if (qKey == null || descriptor == null) {
                    RelationalDescriptorQueryKeysPropertiesPage.this.fieldChooser.setEnabled(false);
                } else {
                    RelationalDescriptorQueryKeysPropertiesPage.this.fieldChooser.setEnabled(!descriptor.isAggregateDescriptor());
                    RelationalDescriptorQueryKeysPropertiesPage.this.fieldChooser.setChoosable(!qKey.isAutoGenerated());
                }
            }
        };
    }

    private ValueModel buildFieldChooserEnablerModel(final AddRemoveListPanel queryKeyListPanel) {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            @Override
            protected Object getValueFromSubject() {
                if ((MWQueryKey)queryKeyListPanel.getSelectedValue() == null) {
                    return Boolean.FALSE;
                }
                return !((MWRelationalClassDescriptor)this.subject).isAggregateDescriptor();
            }
        };
    }

    public void selectQueryKey(MWQueryKey queryKey) {
        this.queryKeyListPanel.setSelectedValue(queryKey, true);
    }
}

