/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;

public class SessionConnectionPolicyPropertiesPage
extends ScrollablePropertiesPage {
    public SessionConnectionPolicyPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    private PropertyValueModel buildAcquireConnectionsLazilyCheckboxHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "lazyConnection"){

            @Override
            protected Object getValueFromSubject() {
                ServerSessionAdapter session = (ServerSessionAdapter)this.subject;
                return session.usesLazyConnection();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ServerSessionAdapter session = (ServerSessionAdapter)this.subject;
                session.setLazyConnection(Boolean.TRUE.equals(value));
            }
        };
    }

    private PropertyValueModel buildAcquireExclusiveConnectionHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "useExclusiveConnection"){

            @Override
            protected Object getValueFromSubject() {
                ServerSessionAdapter session = (ServerSessionAdapter)this.subject;
                return session.usesExclusiveConnection();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ServerSessionAdapter session = (ServerSessionAdapter)this.subject;
                session.setUseExclusiveConnection(Boolean.TRUE.equals(value));
            }
        };
    }

    @Override
    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JCheckBox acquireExclusiveConnectionCheckbox = this.buildCheckBox("SESSION_CONNECTION_POLICY_ACQUIRE_EXCLUSIVE_CONNECTION_CHECKBOX", new CheckBoxModelAdapter(this.buildAcquireExclusiveConnectionHolder()));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)acquireExclusiveConnectionCheckbox, constraints);
        JCheckBox acquireConnectionsLazilyCheckbox = this.buildCheckBox("SESSION_CONNECTION_POLICY_ACQUIRE_CONNECTIONS_LAZILY_CHECKBOX", new CheckBoxModelAdapter(this.buildAcquireConnectionsLazilyCheckboxHolder()));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)acquireConnectionsLazilyCheckbox, constraints);
        this.addHelpTopicId(panel, "session.connectionPolicy");
        return panel;
    }
}

