/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.sql.Date;
import java.sql.Struct;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.insurance.Phone;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureObjectRelationalParameters;

public class StoredProcedureVARRAYParametersTest
extends StoredProcedureObjectRelationalParameters {
    Vector phoneNumbers;
    Vector childrenNames = null;

    public StoredProcedureVARRAYParametersTest() {
    }

    public StoredProcedureVARRAYParametersTest(boolean useCustomSQL) {
        super(useCustomSQL);
    }

    @Override
    public void setup() {
        super.setup();
    }

    @Override
    public void test() {
        Vector<Object> args = new Vector<Object>();
        this.childrenNames = new Vector();
        this.childrenNames.add("Mary");
        this.childrenNames.add("Sue");
        this.phoneNumbers = new Vector();
        this.phoneNumbers.add(Phone.example2());
        this.phoneNumbers.add(Phone.example3());
        args.addElement(this.policyHolderIdToUse);
        args.addElement(null);
        args.addElement(null);
        args.addElement("Peter");
        args.addElement(null);
        args.addElement("Griffin");
        args.addElement(this.originalAddress);
        args.addElement(this.childrenNames);
        args.addElement(this.phoneNumbers);
        this.result = this.getSession().executeQuery(this.getInsertQuery(), args);
        Vector<Long> args2 = new Vector<Long>();
        args2.addElement(this.policyHolderIdToUse);
        this.results2 = (Vector)this.getSession().executeQuery(this.getReadQuery(), args2);
        this.results3 = (Vector)this.getSession().executeQuery(this.getDeleteQuery(), args);
    }

    @Override
    public void verify() {
        if (this.results2.size() != 1 && this.results3.size() != 1) {
            throw new TestErrorException("Collections returned did not contain expected number of results");
        }
        Object addressOut = ((DatabaseRecord)this.results2.get(0)).get("address");
        if (addressOut == null || !(addressOut instanceof Struct)) {
            throw new TestErrorException("Address returned by SProc_Read_PHolders was null or not a Struct :" + addressOut);
        }
        Object addressInOut = ((DatabaseRecord)this.results2.get(0)).get("address");
        if (addressInOut == null || !(addressInOut instanceof Struct)) {
            throw new TestErrorException("Address returned by SProc_Delete_PHolders was null or not a Struct " + addressInOut);
        }
        Vector childrenRead = (Vector)((DatabaseRecord)this.results2.get(0)).get("childrenNames");
        if (this.childrenNames.size() != childrenRead.size() && !this.childrenNames.get(0).equals(childrenRead.get(0))) {
            throw new TestErrorException("First Child's Name did not match what was returned out by SProc_Read_PHolders");
        }
        childrenRead = (Vector)((DatabaseRecord)this.results3.get(0)).get("childrenNames");
        if (this.childrenNames.size() != childrenRead.size() && !this.childrenNames.get(0).equals(childrenRead.get(0))) {
            throw new TestErrorException("First Child's Name did not match what was returned out by SProc_Delete_PHolders");
        }
        Vector phonesRead = (Vector)((DatabaseRecord)this.results2.get(0)).get("phones");
        if (this.phoneNumbers.size() != phonesRead.size() && !this.phoneNumbers.get(0).equals(childrenRead.get(0))) {
            throw new TestErrorException("First phone did not match what was returned out by SProc_Read_PHolders");
        }
        phonesRead = (Vector)((DatabaseRecord)this.results3.get(0)).get("phones");
        if (this.phoneNumbers.size() != phonesRead.size() && !this.phoneNumbers.get(0).equals(phonesRead.get(0))) {
            throw new TestErrorException("First phone did not match what was returned out by SProc_Delete_PHolders");
        }
    }

    @Override
    public DatabaseCall getInsertCall() {
        SQLCall call = null;
        ObjectRelationalDatabaseField ordf = new ObjectRelationalDatabaseField("");
        ordf.setSqlType(2002);
        ordf.setSqlTypeName("PHONE_TYPE");
        ordf.setType(Phone.class);
        if (this.useCustomSQL) {
            String sqlString = "BEGIN SProc_Insert_PHolders(#ssn, #occupation, #sex, #firstName, #birthDate, #lastName, #address, #childrenNames, #phones); END;";
            SQLCall sqlcall = new SQLCall(sqlString);
            sqlcall.setCustomSQLArgumentType("ssn", Long.class);
            sqlcall.setCustomSQLArgumentType("occupation", String.class);
            sqlcall.setCustomSQLArgumentType("sex", Character.class);
            sqlcall.setCustomSQLArgumentType("firstName", String.class);
            sqlcall.setCustomSQLArgumentType("birthDate", Date.class);
            sqlcall.setCustomSQLArgumentType("lastName", String.class);
            sqlcall.setCustomSQLArgumentType("address", 2002, "ADDRESS_TYPE");
            sqlcall.setCustomSQLArgumentType("childrenNames", 2003, "NAMELIST_TYPE");
            sqlcall.setCustomSQLArgumentType("phones", 2003, "PHONELIST_TYPE", (DatabaseField)ordf);
            call = sqlcall;
        } else {
            StoredProcedureCall spcall = new StoredProcedureCall();
            spcall.setProcedureName("SProc_Insert_PHolders");
            spcall.addUnamedArgument("ssn", Long.class);
            spcall.addUnamedArgument("occupation", String.class);
            spcall.addUnamedArgument("sex", Character.class);
            spcall.addUnamedArgument("firstName", String.class);
            spcall.addUnamedArgument("birthDate", Date.class);
            spcall.addUnamedArgument("lastName", String.class);
            spcall.addUnamedArgument("address", 2002, "ADDRESS_TYPE");
            spcall.addUnamedArgument("childrenNames", 2003, "NAMELIST_TYPE");
            spcall.addUnamedArgument("phones", 2003, "PHONELIST_TYPE", (DatabaseField)ordf);
            call = spcall;
        }
        return call;
    }

    @Override
    public DatabaseCall getReadCall() {
        SQLCall call = null;
        ObjectRelationalDatabaseField ordf = new ObjectRelationalDatabaseField("");
        ordf.setSqlType(2002);
        ordf.setSqlTypeName("PHONE_TYPE");
        ordf.setType(Phone.class);
        if (this.useCustomSQL) {
            String sqlString = "BEGIN SProc_Read_PHolders(####ssn, ###occupation, ###sex, ###firstName, ###birthDate, ###lastName, ###address, ###childrenNames, ###phones); END;";
            SQLCall sqlcall = new SQLCall(sqlString);
            sqlcall.setCustomSQLArgumentType("ssn", Long.class);
            sqlcall.setCustomSQLArgumentType("occupation", String.class);
            sqlcall.setCustomSQLArgumentType("sex", Character.class);
            sqlcall.setCustomSQLArgumentType("firstName", String.class);
            sqlcall.setCustomSQLArgumentType("birthDate", Date.class);
            sqlcall.setCustomSQLArgumentType("lastName", String.class);
            sqlcall.setCustomSQLArgumentType("address", 2002, "ADDRESS_TYPE");
            sqlcall.setCustomSQLArgumentType("childrenNames", 2003, "NAMELIST_TYPE", Vector.class);
            sqlcall.setCustomSQLArgumentType("phones", 2003, "PHONELIST_TYPE", Vector.class, (DatabaseField)ordf);
            call = sqlcall;
        } else {
            StoredProcedureCall spcall = new StoredProcedureCall();
            spcall.setProcedureName("SProc_Read_PHolders");
            spcall.addUnamedInOutputArgument("ssn", Long.class);
            spcall.addUnamedOutputArgument("occupation", String.class);
            spcall.addUnamedOutputArgument("sex", Character.class);
            spcall.addUnamedOutputArgument("firstName", String.class);
            spcall.addUnamedOutputArgument("birthDate", Date.class);
            spcall.addUnamedOutputArgument("lastName", String.class);
            spcall.addUnamedOutputArgument("address", 2002, "ADDRESS_TYPE");
            spcall.addUnamedOutputArgument("childrenNames", 2003, "NAMELIST_TYPE", Vector.class);
            spcall.addUnamedOutputArgument("phones", 2003, "PHONELIST_TYPE", Vector.class, (DatabaseField)ordf);
            call = spcall;
        }
        return call;
    }

    @Override
    public DatabaseCall getDeleteCall() {
        SQLCall call = null;
        ObjectRelationalDatabaseField ordf = new ObjectRelationalDatabaseField("");
        ordf.setSqlType(2002);
        ordf.setSqlTypeName("PHONE_TYPE");
        ordf.setType(Phone.class);
        if (this.useCustomSQL) {
            String sqlString = "BEGIN SProc_Delete_PHolders(####ssn, ####occupation, ####sex, ####firstName, ####birthDate, ####lastName, ####address, ####childrenNames, ####phones); END;";
            SQLCall sqlcall = new SQLCall(sqlString);
            sqlcall.setCustomSQLArgumentType("ssn", Long.class);
            sqlcall.setCustomSQLArgumentType("occupation", String.class);
            sqlcall.setCustomSQLArgumentType("sex", Character.class);
            sqlcall.setCustomSQLArgumentType("firstName", String.class);
            sqlcall.setCustomSQLArgumentType("birthDate", Date.class);
            sqlcall.setCustomSQLArgumentType("lastName", String.class);
            sqlcall.setCustomSQLArgumentType("address", 2002, "ADDRESS_TYPE");
            sqlcall.setCustomSQLArgumentType("childrenNames", 2003, "NAMELIST_TYPE", Vector.class);
            sqlcall.setCustomSQLArgumentType("phones", 2003, "PHONELIST_TYPE", Vector.class, (DatabaseField)ordf);
            call = sqlcall;
        } else {
            StoredProcedureCall sqlcall = new StoredProcedureCall();
            sqlcall.setProcedureName("SProc_Delete_PHolders");
            sqlcall.addUnamedInOutputArgument("ssn", Long.class);
            sqlcall.addUnamedInOutputArgument("occupation", String.class);
            sqlcall.addUnamedInOutputArgument("sex", Character.class);
            sqlcall.addUnamedInOutputArgument("firstName", String.class);
            sqlcall.addUnamedInOutputArgument("birthDate", Date.class);
            sqlcall.addUnamedInOutputArgument("lastName", String.class);
            sqlcall.addUnamedInOutputArgument("address", "address", 2002, "ADDRESS_TYPE");
            sqlcall.addUnamedInOutputArgument("childrenNames", "childrenNames", 2003, "NAMELIST_TYPE", Vector.class);
            sqlcall.addUnamedInOutputArgument("phones", "phones", 2003, "PHONELIST_TYPE", Vector.class, (DatabaseField)ordf);
            call = sqlcall;
        }
        return call;
    }
}

