/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cache;

import junit.framework.Test;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.tests.identitymaps.cache.CustomDeleteTest;
import org.eclipse.persistence.testing.tests.identitymaps.cache.InsertOverflowTest;
import org.eclipse.persistence.testing.tests.identitymaps.cache.InsertTest;

public class CacheIdentityMapTestSuite
extends TestSuite {
    public CacheIdentityMapTestSuite() {
        this.setDescription("This suite thoroughly tests the functionality of the cache identity maps.");
        CacheIdentityMap cache = new CacheIdentityMap(10);
        this.addTest((Test)this.getInsertOverflowTestSuite(cache));
        this.addTest((Test)this.getInsertTestSuite(cache));
        this.addTest((Test)this.getSmallCacheTestSuite(new CacheIdentityMap(2)));
    }

    public void addTests() {
        CacheIdentityMap cache = new CacheIdentityMap(10);
    }

    public TestSuite getInsertOverflowTestSuite(CacheIdentityMap cache) {
        TestSuite suite = new TestSuite();
        suite.setName("CacheIdentityMapInsertOverflowTestSuite");
        suite.setDescription("This suite tests the the insertion of a number of elements into the cache which exceed the maximum size of the cache.");
        suite.addTest((Test)new InsertOverflowTest(cache));
        return suite;
    }

    public TestSuite getInsertTestSuite(CacheIdentityMap cache) {
        TestSuite suite = new TestSuite();
        suite.setName("CacheIdentityMapInsertTestSuite");
        suite.setDescription("This suite tests the the insertion of an element into the cache.");
        suite.addTest((Test)new InsertTest(cache));
        return suite;
    }

    public TestSuite getSmallCacheTestSuite(CacheIdentityMap cache) {
        TestSuite suite = new TestSuite();
        suite.setName("SmallCacheIdentityMapTestSuite");
        suite.setDescription("This suite tests the functionality of a small cache.");
        suite.addTest((Test)new CustomDeleteTest(cache));
        return suite;
    }
}

