/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.legacy;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.legacy.Employee;
import org.eclipse.persistence.testing.models.legacy.LegacySystem;
import org.eclipse.persistence.testing.models.legacy.LegacyTables;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class LegacyTestModel
extends TestModel {
    public LegacyTestModel() {
        this.setDescription("This model tests reading/writing/deleting of the complex legacy model.");
    }

    public void addRequiredSystems() {
        LegacyTables.computerDescriptionFieldName = this.getSession().getLogin().getPlatform().isOracle() || this.getSession().getLogin().getPlatform().isSybase() || this.getSession().getLogin().getPlatform().isSQLAnywhere() ? "DESCRIP#" : "DESCRIP";
        this.addRequiredSystem(new LegacySystem());
    }

    public void addTests() {
        this.addTest((Test)LegacyTestModel.getReadObjectTestSuite());
        this.addTest((Test)LegacyTestModel.getReadAllTestSuite());
        this.addTest((Test)LegacyTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)LegacyTestModel.getInsertObjectTestSuite());
        this.addTest((Test)LegacyTestModel.getUpdateObjectTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("LegacyDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the mapping model.");
        Class<Employee> employeeClass = Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "example3")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("LegacyInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the mapping model.");
        suite.addTest((Test)new InsertObjectTest((Object)Employee.example4()));
        suite.addTest((Test)new InsertObjectTest((Object)Employee.example5()));
        suite.addTest((Test)new InsertObjectTest((Object)Employee.example6()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("LegacyReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the mapping model.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 3));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("LegacyReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the mapping model.");
        Class<Employee> employeeClass = Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "example3")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("LegacyUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the mapping model.");
        Class<Employee> employeeClass = Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "example3")));
        return suite;
    }
}

