/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;
import org.eclipse.persistence.testing.tests.proxyindirection.EmployeeImpl;
import org.eclipse.persistence.testing.tests.proxyindirection.LargeProjectImpl;
import org.eclipse.persistence.testing.tests.proxyindirection.Project;

public class UnitOfWorkUpdateFromCache
extends AutoVerifyTestCase {
    public UnitOfWorkUpdateFromCache() {
        this.setDescription("Tests replacing a Proxy Indirection object with a new object (from cache) in a UnitOfWork.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        EmployeeImpl emp4 = new EmployeeImpl();
        emp4.setFirstName("Jason");
        emp4.setLastName("Haley");
        emp4.setGender("Male");
        emp4.setAge(25);
        uow1.registerObject((Object)emp4);
        uow1.commit();
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").like("%Jason%"));
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee eClone = (Employee)uow.registerObject((Object)emp);
        LargeProjectImpl project = new LargeProjectImpl();
        project.setName("TopLink for Java 5.5");
        project.setDescription("Enterprise Object-Relational mapping framework");
        project.setBudget(100000.0);
        project.setInvestor("Oracle Corp.");
        eClone.setProject(project);
        uow.commit();
    }

    public void verify() {
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Jason"));
        Project project = emp.getProject();
        if (!project.getName().equals("TopLink for Java 5.5")) {
            throw new TestErrorException("Updating with a new object did not work properly.");
        }
    }
}

