/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.sql.Date;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.relationships.Customer;
import org.eclipse.persistence.testing.models.jpa.relationships.CustomerDetails;
import org.eclipse.persistence.testing.models.jpa.relationships.Order;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsExamples;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsTableManager;
import org.eclipse.persistence.testing.models.jpa.relationships.SalesPerson;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;

public class JUnitJPQLExamplesTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;
    static EmployeePopulator employeePopulator;

    public JUnitJPQLExamplesTestSuite() {
    }

    public JUnitJPQLExamplesTestSuite(String name) {
        super(name);
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLExamplesTestSuite");
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testSetup"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("findAllOrders"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("findEmployeesInOntario"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("findAllProvinceWithEmployees"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("findAllEmployeesWithPhoneNumbers"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("findAllEmployeesWithOutPhoneNumbers"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("findAllEmployeesWithCellPhones"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("findOrdersWithDifferentBilledCustomer"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("findEmployeeWithWorkPhone2258812"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("parameterTest"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("getOrderLargerThan"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("getSalesPersonForOrders"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("getOrderForCustomer"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testOuterJoin"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testExistsExpression"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testAllExpressions"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testCountInSubQuery"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testGroupByHavingExpression"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testGroupByHavingCount"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testConstructorQuery"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testSumExpression"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testAvgExpression"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testOrderByExpression"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testCountInSubQuery"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testOrderByExpressionWithSelect"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testDeleteExpression"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testComplexDeleteExpression"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testCountExpression"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testUpdateExpression"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("updateAllTest"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("namedQueryCloneTest"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("aggregateParameterTest"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("testEJBQLQueryString"));
        suite.addTest((Test)new JUnitJPQLExamplesTestSuite("updateEmbeddedFieldTest"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        RelationshipsExamples relationshipExamples = new RelationshipsExamples();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        new RelationshipsTableManager().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        relationshipExamples.buildExamples((Session)session);
        employeePopulator.persistExample((Session)session);
    }

    public void findAllOrders() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitJPQLExamplesTestSuite.getServerSession().readAllObjects(Order.class);
        String ejbqlString = "SELECT o FROM OrderBean o";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertEquals((String)"Find all orders test failed: data validation error", (int)result.size(), (int)4);
        Assert.assertTrue((String)"Find all orders test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)result));
    }

    public void findEmployeesInOntario() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("address").get("province").equal((Object)"ONT");
        Vector expectedResult = JUnitJPQLExamplesTestSuite.getServerSession().readAllObjects(Employee.class, whereClause);
        String ejbqlString = "SELECT e FROM Employee e WHERE e.address.province='ONT'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertEquals((String)"Find Employees in Ontario test failed: data validation error", (int)result.size(), (int)9);
        Assert.assertTrue((String)"Find Employees in Ontario test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)result));
    }

    public void findAllProvinceWithEmployees() {
        boolean testPass = false;
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("address").get("province");
        ReportQuery rq = new ReportQuery();
        rq.returnWithoutReportQueryResult();
        rq.setReferenceClass(Employee.class);
        rq.addItem("province", whereClause);
        rq.useDistinct();
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)rq);
        String ejbqlString = "SELECT DISTINCT e.address.province FROM Employee e";
        List result = em.createQuery(ejbqlString).getResultList();
        if (((Object)expectedResult).equals(result)) {
            testPass = true;
        }
        Assert.assertEquals((String)"Find Province with employees test failed: data validation error", (int)result.size(), (int)5);
        Assert.assertTrue((String)"Find Province with employees test failed", (boolean)testPass);
    }

    public void findAllEmployeesWithPhoneNumbers() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.isEmpty("phoneNumbers").not();
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.useDistinct();
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        String ejbqlString = "SELECT DISTINCT e FROM Employee e, IN (e.phoneNumbers) l";
        List firstResult = em.createQuery(ejbqlString).getResultList();
        String alternateEjbqlString = "SELECT e FROM Employee e WHERE e.phoneNumbers IS NOT EMPTY";
        List secondResult = em.createQuery(alternateEjbqlString).getResultList();
        Assert.assertEquals((String)"Ejbql statements returned different results: data validation error", (int)firstResult.size(), (int)14);
        Assert.assertTrue((String)"Equivalent Ejbql statements returned different results", (boolean)comparer.compareObjects(secondResult, (Collection)firstResult));
        Assert.assertTrue((String)"Find all employees with phone numbers test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)firstResult));
    }

    public void findAllEmployeesWithOutPhoneNumbers() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.isEmpty("phoneNumbers");
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.useDistinct();
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        String ejbqlString = "SELECT DISTINCT e FROM Employee e WHERE e.phoneNumbers IS EMPTY";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertEquals((String)"Find all employees WITHOUT phone numbers test failed: data validation error", (int)result.size(), (int)1);
        Assert.assertTrue((String)"Find all employees WITHOUT phone numbers test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)result));
    }

    public void findAllEmployeesWithCellPhones() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.anyOf("phoneNumbers").get("type").equal((Object)"Cellular");
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.useDistinct();
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        String ejbqlString = "SELECT DISTINCT e FROM Employee e JOIN e.phoneNumbers p WHERE p.type = 'Cellular'";
        List firstResult = em.createQuery(ejbqlString).getResultList();
        String alternateEjbqlString = "SELECT DISTINCT e FROM Employee e INNER JOIN e.phoneNumbers p WHERE p.type = 'Cellular'";
        List secondResult = em.createQuery(alternateEjbqlString).getResultList();
        Assert.assertEquals((String)"Find all employees with cellular phone numbers test failed: data validation error", (int)firstResult.size(), (int)4);
        Assert.assertTrue((String)"Find all employees with cellular phone numbers test failed: two equivalent ejb queries return different results", (boolean)comparer.compareObjects(secondResult, (Collection)firstResult));
        Assert.assertTrue((String)"Find all employees with cellular phone numbers test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)secondResult));
    }

    public void findOrdersWithDifferentBilledCustomer() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("customer").equal(builder.get("billedCustomer")).not();
        ReadAllQuery raq = new ReadAllQuery(Order.class);
        raq.setSelectionCriteria(whereClause);
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        String ejbqlString = "SELECT o FROM OrderBean o WHERE o.customer <> o.billedCustomer";
        List firstResult = em.createQuery(ejbqlString).getResultList();
        String alternateEjbqlString = "SELECT o FROM OrderBean o WHERE NOT o.customer.customerId = o.billedCustomer.customerId";
        List secondResult = em.createQuery(alternateEjbqlString).getResultList();
        Assert.assertTrue((String)"Find orders with different billed customers test failed: two equivalent ejb queries return different results", (boolean)comparer.compareObjects(secondResult, (Collection)firstResult));
        Assert.assertTrue((String)"Find orders with different billed customers test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)firstResult));
    }

    public void findEmployeeWithWorkPhone2258812() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause1 = builder.anyOf("phoneNumbers").get("type").equal((Object)"Work");
        Expression whereClause2 = builder.anyOf("phoneNumbers").get("number").equal((Object)"2258812");
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(whereClause1.and(whereClause2));
        raq.useDistinct();
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        String ejbqlString = "SELECT DISTINCT e FROM Employee e JOIN e.phoneNumbers p WHERE p.type = 'Work' AND p.number = '2258812' ";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertEquals((String)"Find employee with 2258812 number test failed: data validation error", (int)result.size(), (int)8);
        Assert.assertTrue((String)"Find employee with 2258812 number test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)result));
    }

    public void parameterTest() {
        EntityManager em = this.createEntityManager();
        Vector employeeList = JUnitJPQLExamplesTestSuite.getServerSession().readAllObjects(Employee.class);
        Employee expectedEmployee = (Employee)employeeList.get(0);
        int i = 1;
        while (expectedEmployee.getPhoneNumbers().size() == 0) {
            expectedEmployee = (Employee)employeeList.get(i);
            ++i;
        }
        String phoneNumber = ((PhoneNumber)expectedEmployee.getPhoneNumbers().iterator().next()).getNumber();
        String ejbqlString = "SELECT DISTINCT e FROM Employee e, IN(e.phoneNumbers) p WHERE p.number = ?1";
        String alternateEjbqlString = "SELECT DISTINCT e FROM Employee e, IN(e.phoneNumbers) p WHERE p.number = :number";
        List firstResult = em.createQuery(ejbqlString).setParameter(1, (Object)phoneNumber).getResultList();
        List secondResult = em.createQuery(alternateEjbqlString).setParameter("number", (Object)phoneNumber).getResultList();
        Assert.assertTrue((String)"Parameter test failed: two equivalent ejb queries return different results", (boolean)comparer.compareObjects(secondResult, (Collection)firstResult));
        Assert.assertTrue((String)"Parameter test failed", (boolean)comparer.compareObjects((Object)expectedEmployee, (Collection)firstResult));
    }

    public void getOrderLargerThan() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder1 = new ExpressionBuilder(Order.class);
        ExpressionBuilder builder2 = new ExpressionBuilder(Order.class);
        Expression o1Quantity = builder1.get("quantity");
        Expression o2Quantity = builder2.get("quantity");
        Expression quantityComparison = o1Quantity.greaterThan(o2Quantity);
        Expression o2CustomerName = builder2.get("customer").get("name");
        Expression nameComparison = o2CustomerName.equal((Object)"Jane Smith");
        Expression whereClause = quantityComparison.and(nameComparison);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setSelectionCriteria(whereClause);
        raq.setReferenceClass(Order.class);
        raq.useDistinct();
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        String ejbqlString = "SELECT DISTINCT o1 FROM OrderBean o1, OrderBean o2 WHERE o1.quantity > o2.quantity AND o2.customer.name = 'Jane Smith' ";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertEquals((String)"Get order larger than test failed: data validation error", (int)result.size(), (int)1);
        Assert.assertTrue((String)"Get order larger than test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)result));
    }

    public void getOrderForCustomer() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("name").equal((Object)"Jane Smith");
        ReadAllQuery raq = new ReadAllQuery(Customer.class);
        raq.setSelectionCriteria(whereClause);
        Customer expectedCustomer = (Customer)((List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)raq)).get(0);
        SalesPerson salesPerson = ((Order)expectedCustomer.getOrders().iterator().next()).getSalesPerson();
        String ejbqlString = "SELECT DISTINCT c FROM Customer c JOIN c.orders o JOIN o.salesPerson s WHERE s.id = " + salesPerson.getId();
        List firstResult = em.createQuery(ejbqlString).getResultList();
        String alternateEjbqlString = "SELECT DISTINCT c FROM Customer c, IN(c.orders) o WHERE o.salesPerson.id = " + salesPerson.getId();
        List secondResuslt = em.createQuery(alternateEjbqlString).getResultList();
        Assert.assertEquals((String)"Get order for customer test failed: data validation error", (int)firstResult.size(), (int)1);
        Assert.assertTrue((String)"Get order for customer test failed: two equivalent ejb queries return different results", (boolean)comparer.compareObjects(secondResuslt, (Collection)firstResult));
        Assert.assertTrue((String)"Get order for customer test failed", (boolean)comparer.compareObjects((Object)expectedCustomer, (Collection)firstResult));
    }

    public void getSalesPersonForOrders() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitJPQLExamplesTestSuite.getServerSession().readAllObjects(SalesPerson.class);
        String ejbqlString = "SELECT DISTINCT o.salesPerson FROM Customer AS c, IN(c.orders) o";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertEquals((String)"Get SalesPerson for Orders test failed: data validation error", (int)result.size(), (int)2);
        Assert.assertTrue((String)"Get SalesPerson for Orders test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)result));
    }

    public void testOuterJoin() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.anyOfAllowingNone("phoneNumbers").get("type").equal((Object)"Cellular");
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.setSelectionCriteria(whereClause);
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        String ejbqlString = "SELECT e FROM Employee e LEFT JOIN e.phoneNumbers p WHERE p.type = 'Cellular'";
        List firstResult = em.createQuery(ejbqlString).getResultList();
        String alternateEjbqlString = "SELECT e FROM Employee e LEFT OUTER JOIN e.phoneNumbers p WHERE p.type = 'Cellular'";
        List secondResult = em.createQuery(alternateEjbqlString).getResultList();
        Assert.assertEquals((String)"Get SalesPerson for Orders test failed: data validation error", (int)firstResult.size(), (int)4);
        Assert.assertTrue((String)"Get Outer Join test failed: two equivalent ejb queries return different results", (boolean)comparer.compareObjects(secondResult, (Collection)firstResult));
        Assert.assertTrue((String)"Get Outer Join test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)firstResult));
    }

    public void testExistsExpression() {
        EntityManager em = this.createEntityManager();
        boolean testPass = false;
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        ExpressionBuilder managerBuilder = new ExpressionBuilder(Employee.class);
        ReportQuery mainQuery = new ReportQuery();
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(Employee.class);
        Expression managerExpression = employeeBuilder.get("manager").get("id").equal(managerBuilder.get("id"));
        subQuery.addAttribute("one", (Expression)new ConstantExpression((Object)new Integer(1), (Expression)subQuery.getExpressionBuilder()));
        subQuery.setSelectionCriteria(managerExpression);
        Expression employeeExpression = employeeBuilder.exists(subQuery);
        mainQuery.setReferenceClass(Employee.class);
        mainQuery.setSelectionCriteria(employeeExpression);
        mainQuery.addAttribute("id");
        mainQuery.returnWithoutReportQueryResult();
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)mainQuery);
        String ejbqlString = "SELECT DISTINCT emp.id FROM Employee emp WHERE EXISTS ( SELECT managedEmp.id FROM Employee managedEmp WHERE managedEmp = emp.manager)";
        List result = em.createQuery(ejbqlString).getResultList();
        if (result.containsAll(expectedResult) && expectedResult.containsAll(result)) {
            testPass = true;
        }
        Assert.assertEquals((String)"Exists Expression test failed: data validation error", (int)result.size(), (int)8);
        Assert.assertTrue((String)"Exists Expression test failed", (boolean)testPass);
    }

    public void testAllExpressions() {
        EntityManager em = this.createEntityManager();
        boolean testPass = false;
        ExpressionBuilder mainQueryBuilder = new ExpressionBuilder(Employee.class);
        ExpressionBuilder subQueryBuilder = new ExpressionBuilder(Employee.class);
        ReportQuery mainQuery = new ReportQuery();
        mainQuery.setReferenceClass(Employee.class);
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(Employee.class);
        Expression subQueryExpression = subQueryBuilder.get("address").get("city").equal(mainQueryBuilder.get("address").get("city")).and(subQueryBuilder.get("salary").lessThan(1000));
        subQuery.setSelectionCriteria(subQueryExpression);
        subQuery.addAttribute("salary");
        Expression mainQueryExpression = mainQueryBuilder.get("salary").greaterThan(mainQueryBuilder.all(subQuery));
        mainQuery.addAttribute("id");
        mainQuery.setSelectionCriteria(mainQueryExpression);
        mainQuery.returnWithoutReportQueryResult();
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)mainQuery);
        String ejbqlString = "SELECT emp.id FROM Employee emp WHERE emp.salary > ALL ( SELECT e.salary FROM Employee e WHERE e.address.city = emp.address.city AND e.salary < 1000)";
        List result = em.createQuery(ejbqlString).getResultList();
        if (result.containsAll(expectedResult) && expectedResult.containsAll(result)) {
            testPass = true;
        }
        if (result.size() != 12) {
            if (JUnitJPQLExamplesTestSuite.getServerSession().getPlatform().isH2()) {
                JUnitJPQLExamplesTestSuite.warning((String)"ALL fails on H2 as H2 has an SQL bug in ALL of none");
            } else {
                JUnitJPQLExamplesTestSuite.fail((String)("All Expression test failed: data validation error: " + result.size() + " != " + 12));
            }
        }
        Assert.assertTrue((String)"All Expression test failed", (boolean)testPass);
    }

    public void testCountInSubQuery() {
        EntityManager em = this.createEntityManager();
        boolean testPass = false;
        ReportQuery mainQuery = new ReportQuery(Customer.class, new ExpressionBuilder());
        ReportQuery subQuery = new ReportQuery(Order.class, new ExpressionBuilder());
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().get("customer").get("customerId").equal(mainQuery.getExpressionBuilder().get("customerId")));
        subQuery.addCount("orderId");
        mainQuery.setSelectionCriteria(mainQuery.getExpressionBuilder().subQuery(subQuery).greaterThan(0));
        mainQuery.addAttribute("customerId");
        mainQuery.returnWithoutReportQueryResult();
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)mainQuery);
        String ejbqlString = "SELECT c.customerId FROM Customer c WHERE (SELECT COUNT(o) FROM c.orders o) > 0";
        List result = em.createQuery(ejbqlString).getResultList();
        if (result.containsAll(expectedResult) && expectedResult.containsAll(result)) {
            testPass = true;
        }
        Assert.assertEquals((String)"Count subquery test failed: data validation error", (int)result.size(), (int)2);
        Assert.assertTrue((String)"Count subquery test failed", (boolean)testPass);
    }

    public void testGroupByHavingExpression() {
        EntityManager em = this.createEntityManager();
        boolean testPass = true;
        ReadAllQuery raq = new ReadAllQuery(Employee.class, new ExpressionBuilder());
        Expression whereClause1 = raq.getExpressionBuilder().get("firstName").equal((Object)"Bob");
        Expression whereClause2 = raq.getExpressionBuilder().get("lastName").equal((Object)"Smith");
        Expression whereClause3 = raq.getExpressionBuilder().get("firstName").equal((Object)"John");
        Expression whereClause4 = raq.getExpressionBuilder().get("lastName").equal((Object)"Way");
        raq.setSelectionCriteria(whereClause1.and(whereClause2).or(whereClause3.and(whereClause4)));
        List employees = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        int firstManagerId = ((Employee)employees.get(0)).getId();
        int secondManagerId = ((Employee)employees.get(1)).getId();
        int expectedEmployeesManaged = ((Employee)employees.get(0)).getManagedEmployees().size() + ((Employee)employees.get(1)).getManagedEmployees().size();
        Vector<Integer> managerVector = new Vector<Integer>();
        managerVector.add(firstManagerId);
        managerVector.add(secondManagerId);
        ReportQuery query = new ReportQuery(Employee.class, new ExpressionBuilder());
        query.returnWithoutReportQueryResult();
        query.addGrouping(query.getExpressionBuilder().get("manager").get("id"));
        query.setHavingExpression(query.getExpressionBuilder().get("manager").get("id").in(managerVector));
        query.addAttribute("managerId", query.getExpressionBuilder().get("manager").get("id"));
        query.addAverage("salary", Double.class);
        query.addCount("id", Long.class);
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        String ejbqlString = "SELECT e.manager.id, avg(e.salary), count(e) FROM Employee e GROUP BY e.manager.id HAVING e.manager.id IN (" + firstManagerId + "," + secondManagerId + ")";
        List result = em.createQuery(ejbqlString).getResultList();
        int employeesManaged = 0;
        Iterator expectedResultIterator = expectedResult.iterator();
        Iterator resultIterator = result.iterator();
        if (expectedResult.size() == result.size()) {
            while (resultIterator.hasNext()) {
                Object[] objectArray = (Object[])expectedResultIterator.next();
                Object[] otherObjectArray = (Object[])resultIterator.next();
                testPass = testPass && objectArray[0].equals(otherObjectArray[0]);
                testPass = testPass && objectArray[1].equals(otherObjectArray[1]);
                testPass = testPass && objectArray[2].equals(otherObjectArray[2]);
                employeesManaged = ((Long)objectArray[2]).intValue() + employeesManaged;
            }
        } else {
            testPass = false;
        }
        Assert.assertEquals((String)"GroupBy Having expression test failed: data validation error", (int)employeesManaged, (int)expectedEmployeesManaged);
        Assert.assertTrue((String)"GroupBy Having expression test failed", (boolean)testPass);
    }

    public void testGroupByHavingCount() {
        EntityManager em = this.createEntityManager();
        boolean testPass = true;
        ReportQuery query = new ReportQuery(Employee.class, new ExpressionBuilder());
        query.returnWithoutReportQueryResult();
        query.addGrouping(query.getExpressionBuilder().get("address").get("province"));
        query.addAttribute("province", query.getExpressionBuilder().get("address").get("province"));
        query.addCount("provinces", query.getExpressionBuilder().get("address").get("province"), Long.class);
        query.setHavingExpression(query.getExpressionBuilder().get("address").get("province").count().greaterThan(3));
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        String ejbqlString = "SELECT e.address.province, COUNT(e) FROM Employee e GROUP BY e.address.province HAVING COUNT(e.address.province) > 3";
        List result = em.createQuery(ejbqlString).getResultList();
        Iterator expectedResultIterator = expectedResult.iterator();
        Iterator resultIterator = result.iterator();
        if (expectedResult.size() == result.size()) {
            while (resultIterator.hasNext()) {
                Object[] objectArray = (Object[])expectedResultIterator.next();
                Object[] otherObjectArray = (Object[])resultIterator.next();
                testPass = testPass && objectArray[0].equals(otherObjectArray[0]);
                testPass = testPass && objectArray[1].equals(otherObjectArray[1]);
            }
        } else {
            testPass = false;
        }
        Assert.assertEquals((String)"GroupBy Having count expression test failed: data validation error", (int)result.size(), (int)1);
        Assert.assertTrue((String)"GroupBy Having Count expression test failed", (boolean)testPass);
    }

    public void testConstructorQuery() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT NEW org.eclipse.persistence.testing.models.jpa.relationships.CustomerDetails(c.customerId, o.quantity) FROM Customer c JOIN c.orders o WHERE o.quantity > 100";
        List custDetails = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Constructor query test failed: not an instance of CustomerDetail", (boolean)(custDetails.get(0) instanceof CustomerDetails));
        Assert.assertEquals((String)"Constructor query test failed, expecting only 1 customer with order > 100", (int)custDetails.size(), (int)1);
    }

    public void testSumExpression() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery(Employee.class, new ExpressionBuilder());
        Expression whereClause = query.getExpressionBuilder().get("address").get("province").equal((Object)"QUE");
        query.addSum("areaCodeSums", query.getExpressionBuilder().anyOf("phoneNumbers").get("id"), Long.class);
        query.setSelectionCriteria(whereClause);
        query.returnWithoutReportQueryResult();
        Long expectedResult = (Long)((List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)query)).get(0);
        String ejbqlString = "SELECT SUM(p.id) FROM Employee e JOIN e.phoneNumbers p JOIN e.address a WHERE a.province = 'QUE' ";
        Long result = (Long)em.createQuery(ejbqlString).getSingleResult();
        Assert.assertEquals((String)"Average expression test failed", (Object)expectedResult, (Object)result);
    }

    public void testAvgExpression() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery(Order.class, new ExpressionBuilder());
        query.addAverage("average quantity", query.getExpressionBuilder().get("quantity"), Double.class);
        query.returnSingleResult();
        Double expectedResult = (Double)((ReportQueryResult)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)query)).get("average quantity");
        String ejbqlString = "SELECT AVG(o.quantity) FROM OrderBean o";
        Double result = (Double)em.createQuery(ejbqlString).getSingleResult();
        Assert.assertEquals((String)"Average expression test failed", (Object)expectedResult, (Object)result);
    }

    public void testCountExpression() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery(Employee.class, new ExpressionBuilder());
        Expression whereClause1 = query.getExpressionBuilder().get("address").get("province").equal((Object)"QUE");
        Expression whereClause2 = query.getExpressionBuilder().get("address").get("city").equal((Object)"Montreal");
        query.setSelectionCriteria(whereClause1.and(whereClause2));
        query.addCount("areaCodeCount", query.getExpressionBuilder().anyOf("phoneNumbers").get("areaCode"), Long.class);
        query.returnSingleResult();
        Long expectedResult = (Long)((ReportQueryResult)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)query)).get("areaCodeCount");
        String ejbqlString = "SELECT COUNT(p.areaCode) FROM Employee e JOIN e.phoneNumbers p JOIN e.address a  WHERE a.province='QUE' AND a.city='Montreal'";
        Long result = (Long)em.createQuery(ejbqlString).getSingleResult();
        String alternateEjbqlString = "SELECT COUNT(p) FROM Employee e JOIN e.phoneNumbers p JOIN e.address a  WHERE a.province='QUE' AND a.city='Montreal' AND p.areaCode IS NOT NULL";
        Long alternateResult = (Long)em.createQuery(alternateEjbqlString).getSingleResult();
        Assert.assertTrue((String)"Count expression test failed: data validation error, ReportQuery returned 0", (expectedResult.intValue() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Count expression test failed: data validation error, first JPQL returned 0", (result.intValue() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Count expression test failed: data validation error, second JPQL returned 0", (alternateResult.intValue() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Count expression test failed: two equivalent ejb queries return different results", (boolean)alternateResult.equals(result));
        Assert.assertEquals((String)"Count expression test failed", (Object)expectedResult, (Object)result);
    }

    public void testOrderByExpression() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery raq = new ReadAllQuery(PhoneNumber.class, new ExpressionBuilder());
        Expression whereClause = raq.getExpressionBuilder().get("owner").get("address").get("province").equal((Object)"ONT");
        raq.setSelectionCriteria(whereClause);
        raq.addOrdering(raq.getExpressionBuilder().get("areaCode"));
        raq.addOrdering(raq.getExpressionBuilder().get("type"));
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        String ejbqlString = "SELECT p FROM Employee e JOIN e.phoneNumbers p JOIN e.address a WHERE a.province = 'ONT' ORDER BY p.areaCode, p.type";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertEquals((String)"OrderBy expression test failed: data validation error", (int)result.size(), (int)13);
        Assert.assertTrue((String)"OrderBy expression test failed", (boolean)comparer.compareObjects(expectedResult, (Collection)result));
    }

    public void testOrderByExpressionWithSelect() {
        EntityManager em = this.createEntityManager();
        boolean testPass = true;
        ReportQuery query = new ReportQuery(PhoneNumber.class, new ExpressionBuilder());
        Expression whereClause = query.getExpressionBuilder().get("owner").get("address").get("province").equal((Object)"ONT");
        query.setSelectionCriteria(whereClause);
        query.addOrdering(query.getExpressionBuilder().get("areaCode"));
        query.addOrdering(query.getExpressionBuilder().get("type"));
        query.addAttribute("areaCode", query.getExpressionBuilder().get("areaCode"));
        query.addAttribute("type", query.getExpressionBuilder().get("type"));
        query.returnWithoutReportQueryResult();
        List expectedResult = (List)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        String ejbqlString = "SELECT p.areaCode, p.type FROM Employee e JOIN e.phoneNumbers p JOIN e.address a WHERE a.province = 'ONT' ORDER BY p.areaCode, p.type";
        List result = em.createQuery(ejbqlString).getResultList();
        Iterator expectedResultIterator = expectedResult.iterator();
        Iterator resultIterator = result.iterator();
        if (expectedResult.size() == result.size()) {
            while (resultIterator.hasNext()) {
                Object[] objectArray = (Object[])expectedResultIterator.next();
                Object[] otherObjectArray = (Object[])resultIterator.next();
                testPass = testPass && objectArray[0].equals(otherObjectArray[0]);
                testPass = testPass && objectArray[1].equals(otherObjectArray[1]);
            }
        } else {
            testPass = false;
        }
        Assert.assertEquals((String)"OrderBy expression test failed: data validation error", (int)result.size(), (int)13);
        Assert.assertTrue((String)"OrderBy with Select expression test failed", (boolean)testPass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteExpression() {
        if (JUnitJPQLExamplesTestSuite.isOnServer()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLExamplesTestSuite.getServerSession().logMessage("Test testDeleteExpression skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        try {
            this.beginTransaction((EntityManager)em);
            String orderString = "DELETE FROM OrderBean o WHERE o.customer.name ='Karen McDonald' ";
            em.createQuery(orderString).executeUpdate();
            orderString = "DELETE FROM OrderBean o WHERE o.billedCustomer.name ='Karen McDonald' ";
            em.createQuery(orderString).executeUpdate();
            String ejbqlString = "DELETE FROM Customer c WHERE c.name='Karen McDonald' ";
            int result = em.createQuery(ejbqlString).executeUpdate();
            Assert.assertEquals((String)"Delete Expression test failed: customer to delete not found", (int)1, (int)result);
            em.flush();
            ReadAllQuery raq = new ReadAllQuery(Customer.class, new ExpressionBuilder());
            Expression whereClause = raq.getExpressionBuilder().get("name").equal((Object)"Karen McDonald");
            raq.setSelectionCriteria(whereClause);
            List customerFound = (List)em.getActiveSession().executeQuery((DatabaseQuery)raq);
            Assert.assertEquals((String)"Delete Expression test failed", (int)0, (int)customerFound.size());
        }
        finally {
            this.rollbackTransaction((EntityManager)em);
        }
    }

    public void testEJBQLQueryString() {
        List emps = this.createEntityManager().createQuery("SELECT e, a FROM Employee e, Address a WHERE e.address = a").getResultList();
        JUnitJPQLExamplesTestSuite.assertFalse((String)"No employees were read, debug and look at the SQL that was generated. ", (boolean)emps.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexDeleteExpression() {
        if (JUnitJPQLExamplesTestSuite.isOnServer()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLExamplesTestSuite.getServerSession().logMessage("Test testComplexDeleteExpression skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        try {
            this.beginTransaction((EntityManager)em);
            String orderString = "DELETE FROM OrderBean o WHERE o.customer.name ='Karen McDonald' ";
            em.createQuery(orderString).executeUpdate();
            orderString = "DELETE FROM OrderBean o WHERE o.billedCustomer.name ='Karen McDonald' ";
            em.createQuery(orderString).executeUpdate();
            String ejbqlString = "DELETE FROM Customer c WHERE c.name='Karen McDonald' AND c.orders IS EMPTY";
            int result = em.createQuery(ejbqlString).executeUpdate();
            Assert.assertEquals((String)"Complex Delete Expression test failed: customer to delete not found", (int)1, (int)result);
            em.flush();
            ReadAllQuery raq = new ReadAllQuery(Customer.class, new ExpressionBuilder());
            Expression whereClause1 = raq.getExpressionBuilder().get("name").equal((Object)"Karen McDonald");
            Expression whereClause2 = raq.getExpressionBuilder().isEmpty("orders");
            raq.setSelectionCriteria(whereClause1.and(whereClause2));
            List customerFound = (List)em.getActiveSession().executeQuery((DatabaseQuery)raq);
            Assert.assertEquals((String)"Complex Delete Expression test failed", (int)0, (int)customerFound.size());
        }
        finally {
            this.rollbackTransaction((EntityManager)em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateExpression() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLExamplesTestSuite.getServerSession().logMessage("Test testUpdateExpression skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        Integer result = null;
        this.beginTransaction(em);
        try {
            String ejbqlString = "UPDATE Customer c SET c.name = 'Test Case' WHERE c.name = 'Jane Smith' AND 0 < (SELECT COUNT(o) FROM Customer cust JOIN cust.orders o)";
            result = em.createQuery(ejbqlString).executeUpdate();
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        Assert.assertEquals((String)"Update expression test failed", (Object)1, (Object)result);
    }

    public void updateAllTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLExamplesTestSuite.getServerSession().logMessage("Test updateAllTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        String empName = "Saunders";
        String manName = "Smitty";
        String ejbqlString = "SELECT DISTINCT e FROM Employee e WHERE e.lastName = '" + empName + "'";
        Employee employee = (Employee)em.createQuery(ejbqlString).getSingleResult();
        Address addr = (Address)em.find(Address.class, (Object)employee.getAddress().getID());
        String ejbqlString2 = "SELECT DISTINCT e FROM Employee e WHERE e.lastName = '" + manName + "'";
        Employee manager = (Employee)em.createQuery(ejbqlString2).getSingleResult();
        this.beginTransaction(em);
        em.createQuery("UPDATE Employee e SET e.manager = :manager WHERE e.address = :addr ").setParameter("manager", (Object)manager).setParameter("addr", (Object)addr).executeUpdate();
        this.commitTransaction(em);
        String ejbqlString3 = "SELECT DISTINCT e.manager FROM Employee e WHERE e.lastName = '" + empName + "'";
        String result = ((Employee)em.createQuery(ejbqlString3).getSingleResult()).getLastName();
        Assert.assertTrue((String)"UpdateAll test failed", (boolean)result.equals(manName));
    }

    public void updateEmbeddedFieldTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLExamplesTestSuite.getServerSession().logMessage("Test updateEmbeddedFieldTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.set(1905, 11, 31, 0, 0, 0);
        Date startDate = new Date(startCalendar.getTime().getTime());
        this.beginTransaction(em);
        em.createQuery("UPDATE Employee e SET e.period.startDate= :startDate").setParameter("startDate", (Object)startDate).executeUpdate();
        this.commitTransaction(em);
    }

    public void namedQueryCloneTest() {
        EntityManager em = this.createEntityManager();
        List result1 = em.createNamedQuery("findAllCustomers").getResultList();
        List result2 = em.createNamedQuery("findAllCustomers").setMaxResults(1).getResultList();
        List result3 = em.createNamedQuery("findAllCustomers").getResultList();
        Assert.assertEquals((String)"Named query clone test failed: the first result should be 4", (int)result1.size(), (int)4);
        Assert.assertEquals((String)"Named query clone test failed: the second result should be 1", (int)result2.size(), (int)1);
        Assert.assertEquals((String)"Named query clone test failed: the third result should be 4", (int)result3.size(), (int)4);
    }

    public void aggregateParameterTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery query = new ReportQuery(Employee.class, builder);
        query.returnWithoutReportQueryResult();
        query.addItem("employee", (Expression)builder);
        EmploymentPeriod period = new EmploymentPeriod();
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.set(1901, 11, 31, 0, 0, 0);
        endCalendar.set(1995, 0, 12, 0, 0, 0);
        period.setStartDate(new Date(startCalendar.getTime().getTime()));
        period.setEndDate(new Date(endCalendar.getTime().getTime()));
        Expression exp = builder.get("period").equal(builder.getParameter("period"));
        query.setSelectionCriteria(exp);
        query.addArgument("period", EmploymentPeriod.class);
        Vector<EmploymentPeriod> args = new Vector<EmploymentPeriod>();
        args.add(period);
        Vector expectedResult = (Vector)JUnitJPQLExamplesTestSuite.getServerSession().executeQuery((DatabaseQuery)query, args);
        List result = em.createQuery("SELECT e FROM Employee e WHERE e.period = :period ").setParameter("period", (Object)period).getResultList();
        Assert.assertTrue((String)"aggregateParameterTest failed", (boolean)comparer.compareObjects(expectedResult, (Collection)result));
    }
}

