/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.DifferentiatorAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.EqualityDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.MapEntryDiff;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class MapEntryDifferentiator
implements Differentiator {
    private Differentiator keyDifferentiator;
    private Differentiator valueDifferentiator;

    public MapEntryDifferentiator() {
        this(EqualityDifferentiator.instance(), EqualityDifferentiator.instance());
    }

    public MapEntryDifferentiator(Differentiator keyDifferentiator, Differentiator valueDifferentiator) {
        this.keyDifferentiator = keyDifferentiator;
        this.valueDifferentiator = valueDifferentiator;
    }

    @Override
    public Diff diff(Object object1, Object object2) {
        return this.diff(object1, object2, DifferentiatorAdapter.NORMAL);
    }

    @Override
    public Diff keyDiff(Object object1, Object object2) {
        return this.diff(object1, object2, DifferentiatorAdapter.KEY);
    }

    private Diff diff(Object object1, Object object2, DifferentiatorAdapter adapter) {
        if (object1 == null || object2 == null) {
            throw new NullPointerException();
        }
        Map.Entry entry1 = (Map.Entry)object1;
        Map.Entry entry2 = (Map.Entry)object2;
        Diff keyDiff = adapter.diff(this.keyDifferentiator, entry1.getKey(), entry2.getKey());
        Diff valueDiff = adapter.diff(this.valueDifferentiator, entry1.getValue(), entry2.getValue());
        return new MapEntryDiff(entry1, entry2, keyDiff, valueDiff, this);
    }

    @Override
    public boolean comparesValueObjects() {
        return false;
    }

    public Differentiator getKeyDifferentiator() {
        return this.keyDifferentiator;
    }

    public void setKeyDifferentiator(Differentiator keyDifferentiator) {
        this.keyDifferentiator = keyDifferentiator;
    }

    public Differentiator getValueDifferentiator() {
        return this.valueDifferentiator;
    }

    public void setValueDifferentiator(Differentiator valueDifferentiator) {
        this.valueDifferentiator = valueDifferentiator;
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.valueDifferentiator);
    }
}

