/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.test.AllTests;
import org.eclipse.persistence.tools.oracleddl.test.TestHelper;
import org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder.DatabaseTypeBuilderTestSuite;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MixedCaseObjectTableTypeTestSuite {
    static final String MIXEDCASE_TYPE1 = "mixedCase1";
    static final String CREATE_MIXEDCASE_TYPE1 = "CREATE OR REPLACE TYPE mixedCase1 AS OBJECT (\n\tempno  NUMBER(4),\n\tename  VARCHAR2(10))";
    static final String MIXEDCASE_TYPE2 = "MIXEDCASE1TABLE";
    static final String CREATE_MIXEDCASE_TYPE2 = "CREATE OR REPLACE TYPE MIXEDCASE1TABLE as table of mixedCase1";
    static final String DROP_MIXEDCASE_TYPE1 = "DROP TYPE mixedCase1";
    static final String DROP_MIXEDCASE_TYPE2 = "DROP TYPE MIXEDCASE1TABLE";
    static DatabaseTypeBuilder dtBuilder = DatabaseTypeBuilderTestSuite.dtBuilder;
    static Connection conn = AllTests.conn;
    static ObjectTableType objectTableType = null;
    static boolean ddlCreate = false;
    static boolean ddlDrop = false;
    static boolean ddlDebug = false;

    @BeforeClass
    public static void setUp() throws SQLException, ClassNotFoundException {
        String ddlDebugProp;
        String ddlDropProp;
        conn = TestHelper.buildConnection();
        dtBuilder = new DatabaseTypeBuilder();
        String ddlCreateProp = System.getProperty("db.ddl.create", "false");
        if ("true".equalsIgnoreCase(ddlCreateProp)) {
            ddlCreate = true;
        }
        if ("true".equalsIgnoreCase(ddlDropProp = System.getProperty("db.ddl.drop", "false"))) {
            ddlDrop = true;
        }
        if ("true".equalsIgnoreCase(ddlDebugProp = System.getProperty("db.ddl.debug", "false"))) {
            ddlDebug = true;
        }
        if (ddlCreate) {
            TestHelper.runDdl(conn, CREATE_MIXEDCASE_TYPE1, ddlDebug);
            TestHelper.runDdl(conn, CREATE_MIXEDCASE_TYPE2, ddlDebug);
        }
        dtBuilder = new DatabaseTypeBuilder();
        boolean worked = true;
        String msg = null;
        try {
            objectTableType = (ObjectTableType)dtBuilder.buildTypes(conn, null, MIXEDCASE_TYPE2).get(0);
        }
        catch (Exception e) {
            worked = false;
            msg = e.getMessage();
        }
        if (!worked) {
            Assert.fail((String)msg);
        }
    }

    @AfterClass
    public static void tearDown() {
        if (ddlDrop) {
            TestHelper.runDdl(conn, DROP_MIXEDCASE_TYPE2, ddlDebug);
            TestHelper.runDdl(conn, DROP_MIXEDCASE_TYPE1, ddlDebug);
        }
    }

    @Test
    public void testMixedCase() {
        Assert.assertEquals((String)"incorrect object type name", (Object)MIXEDCASE_TYPE2, (Object)objectTableType.getTypeName());
    }
}

