/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.io.EOFException;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.persistence.TransactionRequiredException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;

public class JUnitJPQLValidationTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public JUnitJPQLValidationTestSuite() {
    }

    public JUnitJPQLValidationTestSuite(String name) {
        super(name);
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLValidationTestSuite");
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testSetup"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("generalExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("recognitionExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("missingSelectExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("malformedJPQLExceptionTest1"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("malformedJPQLExceptionTest2"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("malformedJPQLExceptionTest3"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("malformedJPQLExceptionTest4"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("malformedJPQLExceptionTest5"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("malformedJPQLExceptionTest6"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("malformedJPQLExceptionTest7"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("malformedJPQLExceptionTest8"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("noAliasWithWHEREAndParameterExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("multipleDeclarationOfIdentificationVariable"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("aliasResolutionException"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("illegalArgumentExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("createNamedQueryThrowsIllegalArgumentExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("flushTxExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testExecuteUpdateTxException"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("noResultExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testGetSingleResultOnUpdate"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testGetSingleResultOnDelete"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testExecuteUpdateOnSelect"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("flushOptimisticLockExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("commitOptimisticLockExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("JTAOptimisticLockExceptionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testParameterNameValidation"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testInExpressionValidation"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testOrderableTypeInOrderByItem"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testNonExistentOrderByAlias"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testInvalidNavigation"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testInvalidCollectionNavigation"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testUnknownAttribute"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testUnknownEnumConstant"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testCommitRollbackException"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testParameterPositionValidation"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testParameterPositionValidation2"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testParameterTypeValidation"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testEjbqlCaseSensitivity"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testEjbqlUnsupportJoinArgument"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testInvalidSetClause"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testUnsupportedCountDistinctOnOuterJoinedCompositePK"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("testInvalidHint"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("invalidCharTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("invalidOnClauseTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("invalidSQLExpressionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("invalidColumnExpressionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("invalidFunctionExpressionTest"));
        suite.addTest((Test)new JUnitJPQLValidationTestSuite("invalidOperatorExpressionTest"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
    }

    public void ensureInvalid(String jpql) {
        try {
            this.createEntityManager().createQuery(jpql).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Illegal Argument Exception must be thrown");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void illegalArgumentExceptionTest() {
        this.ensureInvalid("SELECT FROM EMPLOYEE emp");
    }

    public void generalExceptionTest() {
        this.ensureInvalid("SELECT FROM EMPLOYEE emp");
    }

    public void recognitionExceptionTest() {
        this.ensureInvalid("SELECT OBJECT(emp) FROW Employee emp");
    }

    public void invalidCharTest() {
        this.ensureInvalid("Select !e from Employee e where ! e = e");
    }

    public void invalidOnClauseTest() {
        if (!this.isHermesParser()) {
            JUnitJPQLValidationTestSuite.warning((String)"invalidOnClauseTest only works with Hermes");
            return;
        }
        this.ensureInvalid("Select e from Employee e on e.id = 5");
        this.ensureInvalid("Select e from Employee e on");
        this.ensureInvalid("Select e from Employee e like");
        this.ensureInvalid("Select e from Employee e upper");
        this.ensureInvalid("Select e from Employee e case");
        this.ensureInvalid("Select e from Employee e select");
    }

    public void invalidSQLExpressionTest() {
        if (!this.isHermesParser()) {
            JUnitJPQLValidationTestSuite.warning((String)"invalidSQLExpressionTest only works with Hermes");
            return;
        }
        this.ensureInvalid("Select e from Employee e where sql");
        this.ensureInvalid("Select e from Employee e where sql(");
        this.ensureInvalid("Select e from Employee e where sql()");
        this.ensureInvalid("Select e from Employee e where sql(')");
    }

    public void invalidColumnExpressionTest() {
        if (!this.isHermesParser()) {
            JUnitJPQLValidationTestSuite.warning((String)"invalidColumnExpressionTest only works with Hermes");
            return;
        }
        this.ensureInvalid("Select e from Employee e where column");
        this.ensureInvalid("Select e from Employee e where column(");
        this.ensureInvalid("Select e from Employee e where column()");
        this.ensureInvalid("Select e from Employee e where column(')");
        this.ensureInvalid("Select e from Employee e where column('foo')");
        this.ensureInvalid("Select e from Employee e where column('foo', e.id, e.id)");
        this.ensureInvalid("Select e from Employee e where column('foo', 5)");
    }

    public void invalidOperatorExpressionTest() {
        if (!this.isHermesParser()) {
            JUnitJPQLValidationTestSuite.warning((String)"invalidColumnExpressionTest only works with Hermes");
            return;
        }
        this.ensureInvalid("Select e from Employee e where operator");
        this.ensureInvalid("Select e from Employee e where operator(");
        this.ensureInvalid("Select e from Employee e where operator()");
        this.ensureInvalid("Select e from Employee e where operator(')");
    }

    public void invalidFunctionExpressionTest() {
        if (!this.isHermesParser()) {
            JUnitJPQLValidationTestSuite.warning((String)"invalidFunctionExpressionTest only works with Hermes");
            return;
        }
        this.ensureInvalid("Select e from Employee e where function");
        this.ensureInvalid("Select e from Employee e where function(");
        this.ensureInvalid("Select e from Employee e where function()");
        this.ensureInvalid("Select e from Employee e where function(')");
    }

    public void missingSelectExceptionTest() {
        this.ensureInvalid("OBJECT(emp) FROM Employee emp");
    }

    public void malformedJPQLExceptionTest1() {
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName == \"F";
        try {
            List result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Recognition Exception must be thrown");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void malformedJPQLExceptionTest2() {
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName = \"Fred\" AND 1";
        try {
            List result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Recognition Exception must be thrown");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void malformedJPQLExceptionTest3() {
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName = \"Fred\" OR \"Freda\"";
        try {
            List result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Recognition Exception must be thrown");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void malformedJPQLExceptionTest4() {
        String ejbqlString = "SLEECT OBJECT(emp) FROM Employee emp WHERE emp.firstName = \"Fred\" OR \"Freda\"";
        try {
            List result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Recognition Exception must be thrown");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void malformedJPQLExceptionTest5() {
        List result;
        String ejbqlString = "SELECT c FORM Customer c";
        try {
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using invalid keyword FORM");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        ejbqlString = "SELECT COUNT(c FROM Customer c";
        try {
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using invalid keyword FROM");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        ejbqlString = "SELECT c* FROM Customer c";
        try {
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using invalid keyword *");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void malformedJPQLExceptionTest6() {
        List result;
        String ejbqlString = "SELECT c FROM Customer c WHERE c.name is not nall";
        try {
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using invalid keyword nall");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        ejbqlString = "SELECT c FROM Customer c WHERE c.name is net null";
        try {
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using invalid keyword net");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        ejbqlString = "SELECT c FROM Customer c WHERE c.name is EMPYT";
        try {
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using invalid keyword EMPYT");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        ejbqlString = "SELECT c FROM Customer c WHERE c.name in 3.5";
        try {
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using invalid keyword 3.5");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        ejbqlString = "SELECT c FROM Customer c WHERE c.name MEMBER 6";
        try {
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using invalid keyword 6");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        ejbqlString = "SELECT c FROM Customer c WHERE c.name NOT BETEEN 6 and 7";
        try {
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using invalid keyword BETEEN");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void malformedJPQLExceptionTest7() {
        String ejbqlString = "SELECT e FROM";
        try {
            List result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Expected unexpected end of query exception.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void malformedJPQLExceptionTest8() {
        String ejbqlString = "SELECT e FROM";
        try {
            List result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Expected unexpected end of query exception.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void noAliasWithWHEREAndParameterExceptionTest() {
        String ejbqlString = "FROM Employee WHERE firstName = ?1";
        try {
            List result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Recognition Exception must be thrown");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void aliasResolutionException() {
        String ejbqlString = null;
        try {
            ejbqlString = "SELECT employee FROM Employee employee WHERE emp.firstName = 'Fred'";
            this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using an invalid identification variable in the WHERE clause.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        try {
            ejbqlString = "SELECT OBJECT(nullRoot) FROM Employee emp";
            this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query selecting an invalid identification variable.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        try {
            ejbqlString = "SELECT emp FROM Employee emp JOIN e.projects p WHERE p.name = 'Enterprise'";
            this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using an invalid identification variable in a JOIN clause.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void unknownAbstractSchemaTypeTest() {
        String ejbqlString = " SELECT OBJECT(i) FROM Integer i WHERE i.city = \"Ottawa\"";
        try {
            List result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Missing exception for query using unknown abstract schema type");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void multipleDeclarationOfIdentificationVariable() {
        String ejbqlString;
        try {
            ejbqlString = "SELECT o FROM Order o, Customer o";
            List result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Multiple declaration of identification variable must be thrown");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        if (this.isHermesParser()) {
            ejbqlString = "SELECT c FROM Customer c Join c.orders o WHERE NOT EXISTS (SELECT o FROM c.orders o)";
            List list = this.createEntityManager().createQuery(ejbqlString).getResultList();
        }
    }

    public void testParameterNameValidation() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.lastName like :name ");
        try {
            query.setParameter("l", (Object)"%ay");
            query.getResultList();
        }
        catch (IllegalArgumentException ex) {
            JUnitJPQLValidationTestSuite.assertTrue((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter name is used", (boolean)ex.getMessage().contains("using a name"));
            return;
        }
        JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter name is used");
    }

    public void testParameterPositionValidation() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.firstName like ?1 ");
        try {
            query.setParameter(2, (Object)"%ay");
            query.getResultList();
        }
        catch (IllegalArgumentException ex) {
            JUnitJPQLValidationTestSuite.assertTrue((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter name is used", (boolean)ex.getMessage().contains("parameter at position"));
            return;
        }
        JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter position is used");
    }

    public void testParameterPositionValidation2() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.firstName = ?1 AND e.lastName = ?3 ");
        try {
            query.setParameter(1, (Object)"foo");
            query.setParameter(2, (Object)"");
            query.setParameter(3, (Object)"bar");
            query.getResultList();
        }
        catch (IllegalArgumentException ex) {
            JUnitJPQLValidationTestSuite.assertTrue((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter name is used", (boolean)ex.getMessage().contains("parameter at position"));
            return;
        }
        JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException, when incorrect parameter position is used");
    }

    public void testParameterTypeValidation() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.firstName = :fname AND e.lastName = :lname ");
        try {
            query.setParameter("fname", (Object)"foo");
            query.setParameter("lname", (Object)new Integer(1));
            query.getResultList();
        }
        catch (IllegalArgumentException ex) {
            JUnitJPQLValidationTestSuite.assertTrue((String)"Failed to throw expected IllegalArgumentException, when parameter with incorrect type is used", (boolean)ex.getMessage().contains("attempted to set a value of type"));
            return;
        }
        JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException, when parameter with incorrect type is used");
    }

    public void testModArgumentValidation() {
        List result;
        String ejbqlString;
        try {
            ejbqlString = "SELECT p FROM LargeProject p WHERE MOD(p.budget, 10) = 5";
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        try {
            ejbqlString = "SELECT p FROM LargeProject p WHERE MOD(10, p.budget) = 5";
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void testInExpressionValidation() {
        try {
            String ejbqlString = "SELECT e FROM Employee e WHERE e.firstName IN (1, 2)";
            List result = this.createEntityManager().createQuery(ejbqlString).getResultList();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void testOrderableTypeInOrderByItem() {
        EntityManager em = this.createEntityManager();
        if (this.isHermesParser()) {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY e.address");
            query.getResultList();
        }
    }

    public void testNonExistentOrderByAlias() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY firstName");
            query.getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query having an ORDER BY item with a non-existent alias");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void testInvalidNavigation() {
        EntityManager em = this.createEntityManager();
        try {
            em.createQuery("SELECT e.firstName.invalid FROM Employee e").getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query navigating a state field of type String in the SELECT clause.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        try {
            em.createQuery("SELECT e FROM Employee e WHERE e.firstName.invalid = 1").getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query navigating a state field of type String in the WHERE clause.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void testInvalidCollectionNavigation() {
        String jpql;
        EntityManager em = this.createEntityManager();
        try {
            jpql = "SELECT e.phoneNumbers.type FROM Employee e";
            em.createQuery(jpql).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query navigating a collection valued association field in the SELECT clause.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        try {
            jpql = "SELECT e FROM Employee e WHERE e.phoneNumbers.type = 'Work'";
            em.createQuery(jpql).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query navigating a collection valued association field in the WHERE clause.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void testInvalidHint() {
        Query query;
        String jpql;
        EntityManager em = this.createEntityManager();
        try {
            jpql = "SELECT e.phoneNumbers.type FROM Employee e";
            query = em.createQuery(jpql);
            query.setHint("eclipselink.batch", (Object)"e.phoneNumbers");
            query.getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for invalid query hint.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            jpql = "SELECT e FROM Employee e";
            query = em.createQuery(jpql);
            query.setHint("eclipselink.batch", (Object)"e.phoneNumbers.areaCode");
            query.getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for invalid query hint.");
        }
        catch (QueryException ex) {
            // empty catch block
        }
        try {
            jpql = "SELECT e FROM Employee e";
            query = em.createQuery(jpql);
            query.setHint("eclipselink.cache-usage", (Object)"foobar");
            query.getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for invalid query hint.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.closeEntityManager(em);
    }

    public void testUnknownAttribute() {
        EntityManager em = this.createEntityManager();
        try {
            em.createQuery("SELECT e.unknown FROM Employee e").getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query selecting an unknown state or association field.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        try {
            em.createQuery("SELECT e FROM Employee e WHERE e.unknown = 1").getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a query using an unknown state or association field in the WHERE clause.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void testUnknownEnumConstant() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.status = EmployeeStatus.FULL_TIME");
            query.getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for a queryunknown enumerated class constant.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    public void flushOptimisticLockExceptionTest() {
        if (JUnitJPQLValidationTestSuite.isOnServer()) {
            return;
        }
        EntityManager firstEm = this.createEntityManager();
        EntityManager secondEm = JUnitJPQLValidationTestSuite.createAlternateEntityManager();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName='Bob' ";
        secondEm.getTransaction().begin();
        try {
            firstEm.getTransaction().begin();
            try {
                Employee firstEmployee = (Employee)firstEm.createQuery(ejbqlString).getSingleResult();
                firstEmployee.setLastName("test");
                Employee secondEmployee = (Employee)secondEm.createQuery(ejbqlString).getSingleResult();
                secondEmployee.setLastName("test");
                firstEm.flush();
                firstEm.getTransaction().commit();
            }
            catch (RuntimeException ex) {
                if (firstEm.getTransaction().isActive()) {
                    firstEm.getTransaction().rollback();
                }
                firstEm.close();
                throw ex;
            }
            secondEm.flush();
            JUnitJPQLValidationTestSuite.fail((String)"javax.persistence.OptimisticLockException must be thrown during flush");
        }
        catch (PersistenceException e) {
            if (secondEm.getTransaction().isActive()) {
                secondEm.getTransaction().rollback();
            }
            secondEm.close();
            this.undoEmployeeChanges();
            if (this.isKnownMySQLIssue(e.getCause())) {
                JUnitJPQLValidationTestSuite.warning((String)"EOFException found on MySQL db.  This is a known problem with the MySQL Database");
            }
            Assert.assertTrue((boolean)(e instanceof OptimisticLockException));
        }
    }

    public void commitOptimisticLockExceptionTest() {
        if (JUnitJPQLValidationTestSuite.isOnServer()) {
            return;
        }
        EntityManager firstEm = this.createEntityManager();
        EntityManager secondEm = JUnitJPQLValidationTestSuite.createAlternateEntityManager();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName='Bob' ";
        secondEm.getTransaction().begin();
        try {
            firstEm.getTransaction().begin();
            try {
                Employee firstEmployee = (Employee)firstEm.createQuery(ejbqlString).getSingleResult();
                firstEmployee.setLastName("test");
                Employee secondEmployee = (Employee)secondEm.createQuery(ejbqlString).getSingleResult();
                secondEmployee.setLastName("test");
                firstEm.getTransaction().commit();
            }
            catch (RuntimeException ex) {
                if (firstEm.getTransaction().isActive()) {
                    firstEm.getTransaction().rollback();
                }
                firstEm.close();
                throw ex;
            }
            secondEm.getTransaction().commit();
        }
        catch (Exception e) {
            if (secondEm.getTransaction().isActive()) {
                secondEm.getTransaction().rollback();
            }
            secondEm.close();
            this.undoEmployeeChanges();
            if (this.isKnownMySQLIssue(e.getCause())) {
                JUnitJPQLValidationTestSuite.warning((String)"EOFException found on MySQL db.  This is a known problem with the MySQL Database");
            } else {
                Assert.assertTrue((String)("Exception not instance of opt Lock exception: " + e.getCause()), (boolean)(e.getCause() instanceof OptimisticLockException));
            }
            return;
        }
        JUnitJPQLValidationTestSuite.fail((String)"javax.persistence.OptimisticLockException must be thrown during commit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void JTAOptimisticLockExceptionTest() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            try {
                Employee emp = (Employee)em.createQuery("SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName='Bob' ").getSingleResult();
                em.createQuery("Update Employee set lastName = 'test-bad' WHERE firstName='Bob' ").executeUpdate();
                emp.setLastName("test");
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                Throwable lockException;
                this.closeEntityManagerAndTransaction(em);
                for (lockException = ex; lockException != null && !(lockException instanceof OptimisticLockException); lockException = lockException.getCause()) {
                }
                if (lockException instanceof OptimisticLockException) {
                    this.clearCache();
                    return;
                }
                throw ex;
            }
            JUnitJPQLValidationTestSuite.fail((String)"Lock exception should have been thrown");
        }
        finally {
            this.clearCache();
        }
    }

    public boolean isKnownMySQLIssue(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (!(exception instanceof OptimisticLockException) && JUnitTestCase.getServerSession().getPlatform().isMySQL()) {
            for (Throwable e1 = exception; e1 != null; e1 = e1.getCause()) {
                if (!(e1 instanceof EOFException)) continue;
                return true;
            }
        }
        return false;
    }

    public void flushTxExceptionTest() {
        try {
            this.createEntityManager().flush();
        }
        catch (TransactionRequiredException transactionRequiredException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecuteUpdateTxException() {
        boolean testPass = false;
        String ejbqlString = "DELETE FROM Employee e WHERE e.lastName=\"doesNotExist\"";
        EntityManager em = this.createEntityManager();
        try {
            Integer result = em.createQuery(ejbqlString).executeUpdate();
            if (!this.isTransactionActive(em)) {
                this.beginTransaction(em);
            }
            this.rollbackTransaction(em);
        }
        catch (TransactionRequiredException e) {
            testPass = true;
        }
        finally {
            this.closeEntityManager(em);
        }
        Assert.assertTrue((String)"TransactionRequiredException is expected", (boolean)testPass);
    }

    public void createNamedQueryThrowsIllegalArgumentExceptionTest() {
        try {
            List result = this.createEntityManager().createNamedQuery("test").getResultList();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void noResultExceptionTest() {
        String ejbqlString = "SELECT OBJECT (emp) FROM Employee emp WHERE emp.lastName=\"doestNotExist\" ";
        try {
            Object result = this.createEntityManager().createQuery(ejbqlString).getSingleResult();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NoResultException));
        }
    }

    public void testGetSingleResultOnUpdate() {
        boolean testPass = false;
        String ejbqlString = "UPDATE Employee e SET e.salary = (e.salary + 1000) WHERE e.lastName='Chanley' ";
        try {
            Object result = this.createEntityManager().createQuery(ejbqlString).getSingleResult();
        }
        catch (IllegalStateException e) {
            testPass = true;
        }
        Assert.assertTrue((boolean)testPass);
    }

    public void testGetSingleResultOnDelete() {
        boolean testPass = false;
        String ejbqlString = "DELETE FROM Employee e WHERE e.lastName='Chanley' ";
        try {
            Object result = this.createEntityManager().createQuery(ejbqlString).getSingleResult();
        }
        catch (IllegalStateException e) {
            testPass = true;
        }
        Assert.assertTrue((boolean)testPass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecuteUpdateOnSelect() {
        boolean testPass = false;
        String ejbqlString = "SELECT emp FROM Employee emp  WHERE emp.lastName='Smith' ";
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.createQuery(ejbqlString).executeUpdate();
            this.commitTransaction(em);
        }
        catch (IllegalStateException e) {
            testPass = true;
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
        Assert.assertTrue((boolean)testPass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommitRollbackException() {
        if (JUnitJPQLValidationTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT OBJECT (emp) FROM Employee emp WHERE emp.firstName='Bob'";
        DirectToFieldMapping idMapping = null;
        String defaultFieldName = "";
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)em.createQuery(ejbqlString).getSingleResult();
            idMapping = (DirectToFieldMapping)((EntityManagerImpl)em.getDelegate()).getServerSession().getClassDescriptor(Employee.class).getMappingForAttributeName("id");
            defaultFieldName = idMapping.getFieldName();
            idMapping.setFieldName("fake_id");
            emp.setId(Integer.valueOf(323));
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
            Assert.assertTrue((boolean)(e instanceof RollbackException));
        }
        finally {
            block14: {
                em = this.createEntityManager();
                this.beginTransaction(em);
                try {
                    idMapping.setFieldName(defaultFieldName);
                    this.commitTransaction(em);
                }
                catch (Exception e) {
                    if (!this.isTransactionActive(em)) break block14;
                    this.rollbackTransaction(em);
                    this.closeEntityManager(em);
                }
            }
        }
    }

    public void testEjbqlCaseSensitivity() {
        boolean testPass = true;
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT OBJECT (E) FROM Employee e";
        try {
            List result = em.createQuery(ejbqlString).getResultList();
        }
        catch (Exception e) {
            testPass = false;
        }
        Assert.assertTrue((boolean)testPass);
    }

    public void undoEmployeeChanges() {
        block2: {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                String ejbqlString = "SELECT OBJECT (emp) FROM Employee emp WHERE emp.firstName ='Bob' ";
                Employee emp = (Employee)em.createQuery(ejbqlString).getSingleResult();
                emp.setLastName("Smith");
                em.flush();
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (!this.isTransactionActive(em)) break block2;
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
        }
    }

    public void testEjbqlUnsupportJoinArgument() {
        List result;
        String ejbqlString;
        try {
            ejbqlString = "SELECT e.firstName FROM Employee e JOIN e.period ep";
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"JOINing of embedded entities is not allowed must be thrown");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        try {
            ejbqlString = "SELECT e.firstName FROM Employee e JOIN FETCH e.period";
            result = this.createEntityManager().createQuery(ejbqlString).getResultList();
            JUnitJPQLValidationTestSuite.fail((String)"JOINing of embedded entities is not allowed must be thrown");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidSetClause() {
        String ejbqlString;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ejbqlString = "UPDATE Employee e SET e.projects = NULL";
            em.createQuery(ejbqlString).executeUpdate();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for query  updating a collection valued relationship.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ejbqlString = "UPDATE Employee e SET e.department.name = 'CHANGED'";
            em.createQuery(ejbqlString).executeUpdate();
            JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for query  updating a sate field of a related instance.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    public void testUnsupportedCountDistinctOnOuterJoinedCompositePK() {
        try {
            String jpql = "SELECT COUNT(DISTINCT p) FROM Employee e LEFT JOIN e.phoneNumbers p GROUP BY e.lastName";
            this.createEntityManager().createQuery(jpql).getResultList();
            if (!((DatabasePlatform)this.getPlatform()).supportsCountDistinctWithMultipleFields()) {
                JUnitJPQLValidationTestSuite.fail((String)"Failed to throw expected IllegalArgumentException for query  having a COUNT DISTINCT on a joined variable with a composite primary key.");
            }
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof JPQLException));
        }
        catch (QueryException queryException) {
            // empty catch block
        }
    }

    public static EntityManager createAlternateEntityManager() {
        return Persistence.createEntityManagerFactory((String)"default1", (Map)JUnitTestCaseHelper.getDatabaseProperties()).createEntityManager();
    }
}

