/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking.cascaded;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Child;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class CascadedVersionLockingMultiplePrivateOwnedTest
extends TestCase {
    protected EmployeeProject project;
    protected ClassDescriptor employeeDescriptor;
    protected ClassDescriptor projectDescriptor;
    protected ClassDescriptor childDescriptor;
    protected ClassDescriptor phoneNumberDescriptor;
    protected DatabaseSession customSession;

    public CascadedVersionLockingMultiplePrivateOwnedTest() {
        this.setDescription("Test the correct number of CascadeLockingPolicy objects are created for multiple private ownership");
    }

    public void setup() {
        ClassDescriptor[] descriptors;
        this.project = new EmployeeProject();
        this.employeeDescriptor = this.project.getDescriptor(Employee.class);
        this.projectDescriptor = this.project.getDescriptor(Project.class);
        this.childDescriptor = this.project.getDescriptor(Child.class);
        this.phoneNumberDescriptor = this.project.getDescriptor(PhoneNumber.class);
        for (ClassDescriptor descriptor : descriptors = new ClassDescriptor[]{this.employeeDescriptor, this.projectDescriptor, this.childDescriptor, this.phoneNumberDescriptor}) {
            VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
            String versionFieldName = descriptor.getTableName() + ".VERSION";
            lockingPolicy.setWriteLockFieldName(versionFieldName);
            lockingPolicy.storeInCache();
            descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        }
        ((VersionLockingPolicy)this.projectDescriptor.getOptimisticLockingPolicy()).setIsCascaded(true);
        ((VersionLockingPolicy)this.childDescriptor.getOptimisticLockingPolicy()).setIsCascaded(true);
        ForeignReferenceMapping childrenMapping = (ForeignReferenceMapping)this.employeeDescriptor.getMappingForAttributeName("children");
        childrenMapping.setIsPrivateOwned(false);
        ForeignReferenceMapping teamLeaderMapping = (ForeignReferenceMapping)this.projectDescriptor.getMappingForAttributeName("teamLeader");
        teamLeaderMapping.setIsPrivateOwned(true);
        ForeignReferenceMapping parentMapping = (ForeignReferenceMapping)this.childDescriptor.getMappingForAttributeName("parent");
        parentMapping.setIsPrivateOwned(true);
        ForeignReferenceMapping phoneNumbersMapping = (ForeignReferenceMapping)this.employeeDescriptor.getMappingForAttributeName("phoneNumbers");
        phoneNumbersMapping.setIsPrivateOwned(true);
        this.customSession = this.project.createDatabaseSession();
        this.customSession.setLogin((Login)this.getSession().getLogin().clone());
    }

    public void test() {
        this.customSession.login();
    }

    public void verify() {
        CascadedVersionLockingMultiplePrivateOwnedTest.assertEquals((String)"Project should have 0 policies", (int)0, (int)this.projectDescriptor.getCascadeLockingPolicies().size());
        CascadedVersionLockingMultiplePrivateOwnedTest.assertEquals((String)"Child should have 0 policies", (int)0, (int)this.childDescriptor.getCascadeLockingPolicies().size());
        CascadedVersionLockingMultiplePrivateOwnedTest.assertEquals((String)"Employee should have 2 policies", (int)2, (int)this.employeeDescriptor.getCascadeLockingPolicies().size());
        CascadedVersionLockingMultiplePrivateOwnedTest.assertEquals((String)"PhoneNumber should have 1 policy", (int)1, (int)this.phoneNumberDescriptor.getCascadeLockingPolicies().size());
    }

    public void reset() {
        this.project = null;
        this.projectDescriptor = null;
        this.childDescriptor = null;
        this.employeeDescriptor = null;
        this.phoneNumberDescriptor = null;
        if (this.customSession != null && this.customSession.isConnected()) {
            this.customSession.logout();
        }
        this.customSession = null;
    }
}

