/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class PessimisticLockBatchAttributeTest
extends TestCase {
    public UnitOfWork uow;
    public short lockMode = (short)2;
    CMPPolicy oldCMPPolicy;

    public PessimisticLockBatchAttributeTest() {
        this.setDescription("Verfies that objects pessimistically locked by one user in a batch read are not accessable to others.");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        PessimisticLockingPolicy policy = new PessimisticLockingPolicy();
        policy.setLockingMode(this.lockMode);
        CMPPolicy cmpPolicy = new CMPPolicy();
        cmpPolicy.setPessimisticLockingPolicy(policy);
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("phoneNumbers")).getSelectionQuery()).setLockMode((short)-1);
        ClassDescriptor phoneDescriptor = this.getSession().getDescriptor(PhoneNumber.class);
        this.oldCMPPolicy = phoneDescriptor.getCMPPolicy();
        phoneDescriptor.setCMPPolicy(cmpPolicy);
        phoneDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.uow != null) {
            this.uow.release();
        }
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("phoneNumbers")).getSelectionQuery()).setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("phoneNumbers")).getSelectionQuery()).dontRefreshIdentityMapResult();
        ClassDescriptor phoneDescriptor = this.getSession().getDescriptor(PhoneNumber.class);
        phoneDescriptor.setCMPPolicy(this.oldCMPPolicy);
        phoneDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
    }

    public void test() throws Exception {
        if (!this.getSession().getPlatform().isOracle() && !this.getSession().getPlatform().isSQLServer()) {
            throw new TestWarningException("This test only runs on Oracle wears writes do not block reads.");
        }
        this.uow = this.getSession().acquireUnitOfWork();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.addBatchReadAttribute(query.getExpressionBuilder().get("phoneNumbers"));
        Vector result = (Vector)this.uow.executeQuery((DatabaseQuery)query);
        Vector phones = ((Employee)result.elementAt(0)).getPhoneNumbers();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        try {
            boolean isLocked = false;
            ReadObjectQuery uow2Query = new ReadObjectQuery(Employee.class);
            Employee employee = (Employee)uow2.executeQuery((DatabaseQuery)uow2Query);
            try {
                employee.getPhoneNumbers();
            }
            catch (EclipseLinkException exception) {
                isLocked = true;
            }
            if (!isLocked) {
                throw new TestErrorException("Triggering an attribute that was locked by another in a batch read should trigger a no_wait exception.");
            }
            this.uow.release();
            this.uow = null;
            try {
                employee.getPhoneNumbers();
            }
            catch (EclipseLinkException exception) {
                throw new TestErrorException("Now that a batch attribute locked by UOW1 has been released it should be readable now.");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (uow2 != null) {
                uow2.release();
            }
        }
    }
}

