/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.types;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.types.TypeTester;
import org.eclipse.persistence.testing.tests.types.WriteTypeObjectTest;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TimeDateTester
extends TypeTester {
    public java.sql.Date sqlDate;
    public Date utilDate;
    public Time time;
    public Timestamp timestamp;

    public TimeDateTester() {
        super("NEW");
    }

    public TimeDateTester(String nameOfTest, int year, int month, int date, int hrs, int min, int sec, int nano) {
        super(nameOfTest);
        Calendar c = Calendar.getInstance();
        c.set(year, month, date, hrs, min, sec);
        c.set(14, nano / 1000000);
        this.utilDate = c.getTime();
        this.sqlDate = Helper.dateFromYearMonthDate((int)year, (int)month, (int)date);
        this.time = Helper.timeFromHourMinuteSecond((int)hrs, (int)min, (int)sec);
        this.timestamp = Helper.timestampFromYearMonthDateHourMinuteSecondNanos((int)year, (int)month, (int)date, (int)hrs, (int)min, (int)sec, (int)nano);
    }

    public TimeDateTester(String nameOfTest, Calendar dateTime) {
        this(nameOfTest, dateTime.get(1), dateTime.get(2), dateTime.get(5), dateTime.get(10), dateTime.get(12), dateTime.get(13), 0);
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(TimeDateTester.class);
        descriptor.setTableName("TIMEDATE");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("utilDate", "UTILDATE");
        descriptor.addDirectMapping("sqlDate", "SQLDATE");
        descriptor.addDirectMapping("time", "TTIME");
        descriptor.addDirectMapping("timestamp", "TSTAMP");
        return descriptor;
    }

    public static RelationalDescriptor descriptorWithAccessors() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(TimeDateTester.class);
        descriptor.setTableName("TIMEDATE");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("utilDate", "getUtilDate", "setUtilDate", "UTILDATE");
        descriptor.addDirectMapping("sqlDate", "getSQLDate", "setSQLDate", "SQLDATE");
        descriptor.addDirectMapping("time", "getTime", "setTime", "TTIME");
        descriptor.addDirectMapping("timestamp", "getTimestamp", "setTimestamp", "TSTAMP");
        return descriptor;
    }

    public java.sql.Date getSQLDate() {
        return this.sqlDate;
    }

    public Time getTime() {
        return this.time;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Date getUtilDate() {
        return this.utilDate;
    }

    public void setSQLDate(java.sql.Date aDate) {
        this.sqlDate = aDate;
    }

    public void setTime(Time aTime) {
        this.time = aTime;
    }

    public void setTimestamp(Timestamp aTimestamp) {
        this.timestamp = aTimestamp;
    }

    public void setUtilDate(Date aDate) {
        this.utilDate = aDate;
    }

    public static TableDefinition tableDefinition(Session session) {
        TableDefinition definition = TypeTester.tableDefinition();
        definition.setName("TIMEDATE");
        definition.addField("UTILDATE", Timestamp.class);
        definition.addField("SQLDATE", java.sql.Date.class);
        definition.addField("TTIME", Time.class);
        definition.addField("TSTAMP", Timestamp.class);
        return definition;
    }

    public static Vector testInstances() {
        Vector<TimeDateTester> tests = new Vector<TimeDateTester>();
        tests.addElement(new TimeDateTester("NOW", Calendar.getInstance()));
        tests.addElement(new TimeDateTester("ZERO", 1900, 0, 1, 0, 0, 0, 0));
        tests.addElement(new TimeDateTester("New Years Eve", 1997, 11, 31, 23, 59, 59, 900000000));
        tests.addElement(new TimeDateTester("New Years Day", 1998, 1, 1, 0, 0, 1, 0));
        tests.addElement(new TimeDateTester("New Years Eve 1999", 1999, 11, 31, 23, 59, 59, 0));
        tests.addElement(new TimeDateTester("New Years Day 2000", 2000, 1, 1, 0, 0, 1, 0));
        tests.addElement(new TimeDateTester("Doug's Birth", 1970, 8, 13, 16, 34, 0, 0));
        tests.addElement(new TimeDateTester("Doug's 100th Birthday", 2070, 8, 13, 16, 34, 0, 0));
        Calendar yearsBack100 = Calendar.getInstance();
        yearsBack100.set(1, yearsBack100.get(1) - 100);
        tests.addElement(new TimeDateTester("100 Years ago", yearsBack100));
        Calendar yearsAhead100 = Calendar.getInstance();
        yearsAhead100.set(1, yearsAhead100.get(1) + 100);
        tests.addElement(new TimeDateTester("100 Years from now", yearsAhead100));
        tests.addElement(new TimeDateTester("Before 1970", 1902, 8, 13, 16, 34, 25, 900000000));
        return tests;
    }

    public String toString() {
        return this.getTestName() + " -> " + this.timestamp;
    }

    @Override
    protected void verify(WriteTypeObjectTest testCase) throws TestException {
        try {
            super.verify(testCase);
        }
        catch (TestException e) {
            if (this.caughtException != null && this.caughtException.toString().equals("EXCEPTION: org.eclipse.persistence.exceptions.DatabaseException \nDESCRIPTION: null \nINTERNAL EXCEPTION: java.sql.SQLException: JZ0S8: An escape sequence in a SQL Query was malformed.\nERROR CODE: 0\n\n")) {
                throw new TestProblemException("JConnect does not do dates in non-native SQL:\n" + this.caughtException.getInternalException());
            }
            Timestamp objectTimeInCache = this.getTimestamp();
            if (testCase.getObjectFromDatabase() == null) {
                throw e;
            }
            Timestamp objectTimeInDB = ((TimeDateTester)testCase.getObjectFromDatabase()).getTimestamp();
            int nunoSecond = objectTimeInCache.getNanos() / 100000000;
            objectTimeInCache.setNanos(0);
            if (this.getTimestamp().equals(objectTimeInDB)) {
                throw new TestWarningException("The nanoseconds should be: " + nunoSecond + " but were read back as: " + objectTimeInDB.getNanos());
            }
            throw e;
        }
    }
}

