/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ClassNameTools;
import org.eclipse.persistence.tools.utility.ClassTools;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class ClassNameToolsTests
extends TestCase {
    public ClassNameToolsTests(String name) {
        super(name);
    }

    public void testIsArray() {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isArray((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isArray((String)int[].class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isArray((String)int[][].class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isArray((String)String.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isArray((String)String[].class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isArray((String)String[][].class.getName()));
    }

    public void testIsArrayCharArray() {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isArray((char[])Integer.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isArray((char[])int[].class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isArray((char[])int[][].class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isArray((char[])String.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isArray((char[])String[].class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isArray((char[])String[][].class.getName().toCharArray()));
    }

    public void testArrayDepth() {
        ClassNameToolsTests.assertEquals((int)0, (int)ClassNameTools.arrayDepth((String)Vector.class.getName()));
        ClassNameToolsTests.assertEquals((int)0, (int)ClassNameTools.arrayDepth((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertEquals((int)0, (int)ClassNameTools.arrayDepth((String)Void.TYPE.getName()));
        ClassNameToolsTests.assertEquals((int)1, (int)ClassNameTools.arrayDepth((String)Vector[].class.getName()));
        ClassNameToolsTests.assertEquals((int)1, (int)ClassNameTools.arrayDepth((String)int[].class.getName()));
        ClassNameToolsTests.assertEquals((int)3, (int)ClassNameTools.arrayDepth((String)Vector[][][].class.getName()));
        ClassNameToolsTests.assertEquals((int)3, (int)ClassNameTools.arrayDepth((String)int[][][].class.getName()));
    }

    public void testArrayDepthCharArray() {
        ClassNameToolsTests.assertEquals((int)0, (int)ClassNameTools.arrayDepth((char[])Vector.class.getName().toCharArray()));
        ClassNameToolsTests.assertEquals((int)0, (int)ClassNameTools.arrayDepth((char[])Integer.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertEquals((int)0, (int)ClassNameTools.arrayDepth((char[])Void.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertEquals((int)1, (int)ClassNameTools.arrayDepth((char[])Vector[].class.getName().toCharArray()));
        ClassNameToolsTests.assertEquals((int)1, (int)ClassNameTools.arrayDepth((char[])int[].class.getName().toCharArray()));
        ClassNameToolsTests.assertEquals((int)3, (int)ClassNameTools.arrayDepth((char[])Vector[][][].class.getName().toCharArray()));
        ClassNameToolsTests.assertEquals((int)3, (int)ClassNameTools.arrayDepth((char[])int[][][].class.getName().toCharArray()));
    }

    public void testElementTypeName() {
        ClassNameToolsTests.assertEquals((String)Vector.class.getName(), (String)ClassNameTools.elementTypeName((String)Vector.class.getName()));
        ClassNameToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassNameTools.elementTypeName((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertEquals((String)Void.TYPE.getName(), (String)ClassNameTools.elementTypeName((String)Void.TYPE.getName()));
        ClassNameToolsTests.assertEquals((String)Vector.class.getName(), (String)ClassNameTools.elementTypeName((String)Vector[].class.getName()));
        ClassNameToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassNameTools.elementTypeName((String)int[].class.getName()));
        ClassNameToolsTests.assertEquals((String)Vector.class.getName(), (String)ClassNameTools.elementTypeName((String)Vector[][][].class.getName()));
        ClassNameToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassNameTools.elementTypeName((String)int[][][].class.getName()));
    }

    public void testElementTypeNameCharArray() {
        TestTools.assertEquals(Vector.class.getName(), ClassNameTools.elementTypeName((char[])Vector.class.getName().toCharArray()));
        TestTools.assertEquals(Integer.TYPE.getName(), ClassNameTools.elementTypeName((char[])Integer.TYPE.getName().toCharArray()));
        TestTools.assertEquals(Void.TYPE.getName(), ClassNameTools.elementTypeName((char[])Void.TYPE.getName().toCharArray()));
        TestTools.assertEquals(Vector.class.getName(), ClassNameTools.elementTypeName((char[])Vector[].class.getName().toCharArray()));
        TestTools.assertEquals(Integer.TYPE.getName(), ClassNameTools.elementTypeName((char[])int[].class.getName().toCharArray()));
        TestTools.assertEquals(Vector.class.getName(), ClassNameTools.elementTypeName((char[])Vector[][][].class.getName().toCharArray()));
        TestTools.assertEquals(Integer.TYPE.getName(), ClassNameTools.elementTypeName((char[])int[][][].class.getName().toCharArray()));
    }

    public void testComponentTypeName() {
        ClassNameToolsTests.assertEquals(null, (String)ClassNameTools.componentTypeName((String)Object.class.getName()));
        ClassNameToolsTests.assertEquals((String)Object.class.getName(), (String)ClassNameTools.componentTypeName((String)Object[].class.getName()));
        ClassNameToolsTests.assertEquals((String)Object[].class.getName(), (String)ClassNameTools.componentTypeName((String)Object[][].class.getName()));
        ClassNameToolsTests.assertEquals(null, (String)ClassNameTools.componentTypeName((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassNameTools.componentTypeName((String)int[].class.getName()));
        ClassNameToolsTests.assertEquals((String)int[].class.getName(), (String)ClassNameTools.componentTypeName((String)int[][].class.getName()));
    }

    public void testComponentTypeNameCharArray() {
        ClassNameToolsTests.assertNull((Object)ClassNameTools.componentTypeName((char[])Object.class.getName().toCharArray()));
        TestTools.assertEquals(Object.class.getName(), ClassNameTools.componentTypeName((char[])Object[].class.getName().toCharArray()));
        TestTools.assertEquals(Object[].class.getName(), ClassNameTools.componentTypeName((char[])Object[][].class.getName().toCharArray()));
        ClassNameToolsTests.assertNull((Object)ClassNameTools.componentTypeName((char[])Integer.TYPE.getName().toCharArray()));
        TestTools.assertEquals(Integer.TYPE.getName(), ClassNameTools.componentTypeName((char[])int[].class.getName().toCharArray()));
        TestTools.assertEquals(int[].class.getName(), ClassNameTools.componentTypeName((char[])int[][].class.getName().toCharArray()));
    }

    public void testTypeDeclaration() throws Exception {
        TestTools.assertEquals("int", ClassNameTools.typeDeclaration((char[])"int".toCharArray()));
        TestTools.assertEquals("int[]", ClassNameTools.typeDeclaration((char[])"[I".toCharArray()));
        TestTools.assertEquals("int[][]", ClassNameTools.typeDeclaration((char[])"[[I".toCharArray()));
        TestTools.assertEquals("java.lang.Object", ClassNameTools.typeDeclaration((char[])"java.lang.Object".toCharArray()));
        TestTools.assertEquals("java.lang.Object[]", ClassNameTools.typeDeclaration((char[])"[Ljava.lang.Object;".toCharArray()));
        TestTools.assertEquals("java.lang.Object[][]", ClassNameTools.typeDeclaration((char[])"[[Ljava.lang.Object;".toCharArray()));
    }

    public void testTypeDeclarationCharArray() throws Exception {
        ClassNameToolsTests.assertEquals((String)"int", (String)ClassNameTools.typeDeclaration((String)"int"));
        ClassNameToolsTests.assertEquals((String)"int[]", (String)ClassNameTools.typeDeclaration((String)"[I"));
        ClassNameToolsTests.assertEquals((String)"int[][]", (String)ClassNameTools.typeDeclaration((String)"[[I"));
        ClassNameToolsTests.assertEquals((String)"java.lang.Object", (String)ClassNameTools.typeDeclaration((String)"java.lang.Object"));
        ClassNameToolsTests.assertEquals((String)"java.lang.Object[]", (String)ClassNameTools.typeDeclaration((String)"[Ljava.lang.Object;"));
        ClassNameToolsTests.assertEquals((String)"java.lang.Object[][]", (String)ClassNameTools.typeDeclaration((String)"[[Ljava.lang.Object;"));
    }

    public void testSimpleName() throws Exception {
        ClassNameToolsTests.assertEquals((String)"Object", (String)ClassNameTools.simpleName((String)Object.class.getName()));
        ClassNameToolsTests.assertEquals((String)"Object[]", (String)ClassNameTools.simpleName((String)Object[].class.getName()));
        ClassNameToolsTests.assertEquals((String)"Object[][]", (String)ClassNameTools.simpleName((String)Object[][].class.getName()));
        ClassNameToolsTests.assertEquals((String)Map.class.getSimpleName(), (String)ClassNameTools.simpleName((String)Map.class.getName()));
        ClassNameToolsTests.assertEquals((String)Map.Entry.class.getSimpleName(), (String)ClassNameTools.simpleName((String)Map.Entry.class.getName()));
        ClassNameToolsTests.assertEquals((String)"int", (String)ClassNameTools.simpleName((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertEquals((String)"int[]", (String)ClassNameTools.simpleName((String)int[].class.getName()));
        ClassNameToolsTests.assertEquals((String)"int[][]", (String)ClassNameTools.simpleName((String)int[][].class.getName()));
        Object anonObject = new Object(){};
        ClassNameToolsTests.assertEquals((String)"", (String)ClassNameTools.simpleName((String)anonObject.getClass().getName()));
        class Local {
            Local() {
            }
        }
        Local localObject = new Local();
        ClassNameToolsTests.assertEquals((String)"Local", (String)ClassNameTools.simpleName((String)localObject.getClass().getName()));
    }

    public void testSimpleNameCharArray() throws Exception {
        TestTools.assertEquals("Object", ClassNameTools.simpleName((char[])Object.class.getName().toCharArray()));
        TestTools.assertEquals("Object[]", ClassNameTools.simpleName((char[])Object[].class.getName().toCharArray()));
        TestTools.assertEquals("Object[][]", ClassNameTools.simpleName((char[])Object[][].class.getName().toCharArray()));
        TestTools.assertEquals(Map.class.getSimpleName(), ClassNameTools.simpleName((char[])Map.class.getName().toCharArray()));
        TestTools.assertEquals(Map.Entry.class.getSimpleName(), ClassNameTools.simpleName((char[])Map.Entry.class.getName().toCharArray()));
        TestTools.assertEquals("int", ClassNameTools.simpleName((char[])Integer.TYPE.getName().toCharArray()));
        TestTools.assertEquals("int[]", ClassNameTools.simpleName((char[])int[].class.getName().toCharArray()));
        TestTools.assertEquals("int[][]", ClassNameTools.simpleName((char[])int[][].class.getName().toCharArray()));
        Object anonObject = new Object(){};
        TestTools.assertEquals("", ClassNameTools.simpleName((char[])anonObject.getClass().getName().toCharArray()));
        class Local {
            Local() {
            }
        }
        Local localObject = new Local();
        TestTools.assertEquals("Local", ClassNameTools.simpleName((char[])localObject.getClass().getName().toCharArray()));
    }

    public void testPackageName() throws Exception {
        ClassNameToolsTests.assertEquals((String)Object.class.getPackage().getName(), (String)ClassNameTools.packageName((String)Object.class.getName()));
        ClassNameToolsTests.assertEquals((String)"", (String)ClassNameTools.packageName((String)Object[].class.getName()));
        ClassNameToolsTests.assertEquals((String)"", (String)ClassNameTools.packageName((String)Object[][].class.getName()));
        ClassNameToolsTests.assertEquals((String)Map.class.getPackage().getName(), (String)ClassNameTools.packageName((String)Map.class.getName()));
        ClassNameToolsTests.assertEquals((String)Map.Entry.class.getPackage().getName(), (String)ClassNameTools.packageName((String)Map.Entry.class.getName()));
        ClassNameToolsTests.assertEquals((String)"", (String)ClassNameTools.packageName((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertEquals((String)"", (String)ClassNameTools.packageName((String)int[].class.getName()));
        ClassNameToolsTests.assertEquals((String)"", (String)ClassNameTools.packageName((String)int[][].class.getName()));
        ClassNameToolsTests.assertEquals((String)"", (String)ClassNameTools.packageName((String)Void.TYPE.getName()));
        Object anonObject = new Object(){};
        ClassNameToolsTests.assertEquals((String)anonObject.getClass().getPackage().getName(), (String)ClassNameTools.packageName((String)anonObject.getClass().getName()));
    }

    public void testPackageNameCharArray() throws Exception {
        TestTools.assertEquals(Object.class.getPackage().getName(), ClassNameTools.packageName((char[])Object.class.getName().toCharArray()));
        TestTools.assertEquals("", ClassNameTools.packageName((char[])Object[].class.getName().toCharArray()));
        TestTools.assertEquals("", ClassNameTools.packageName((char[])Object[][].class.getName().toCharArray()));
        TestTools.assertEquals(Map.class.getPackage().getName(), ClassNameTools.packageName((char[])Map.class.getName().toCharArray()));
        TestTools.assertEquals(Map.Entry.class.getPackage().getName(), ClassNameTools.packageName((char[])Map.Entry.class.getName().toCharArray()));
        TestTools.assertEquals("", ClassNameTools.packageName((char[])Integer.TYPE.getName().toCharArray()));
        TestTools.assertEquals("", ClassNameTools.packageName((char[])int[].class.getName().toCharArray()));
        TestTools.assertEquals("", ClassNameTools.packageName((char[])int[][].class.getName().toCharArray()));
        TestTools.assertEquals("", ClassNameTools.packageName((char[])Void.TYPE.getName().toCharArray()));
        Object anonObject = new Object(){};
        TestTools.assertEquals(anonObject.getClass().getPackage().getName(), ClassNameTools.packageName((char[])anonObject.getClass().getName().toCharArray()));
    }

    public void testIsTopLevel() throws Exception {
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isTopLevel((String)Map.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((String)Map.Entry.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((String)Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((String)array.getClass().getName()));
    }

    public void testIsTopLevelCharArray() throws Exception {
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isTopLevel((char[])Map.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((char[])Map.Entry.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((char[])Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((char[])Class.forName("java.util.Vector$1").getName().toCharArray()));
        Object[] array = new Map[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((char[])array.getClass().getName().toCharArray()));
        array = new Map.Entry[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((char[])array.getClass().getName().toCharArray()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((char[])array.getClass().getName().toCharArray()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isTopLevel((char[])array.getClass().getName().toCharArray()));
    }

    public void testIsMember() throws Exception {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)Map.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((String)Map.Entry.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)array.getClass().getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((String)"java.util.Map$a1"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((String)"java.util.Map$1aa$aaa"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((String)"java.util.Map$1$aaa"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((String)"java.util.Map$a1$aaa$bbb"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((String)"java.util.Map$1a1$aaa"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)"java.util.Map$1a"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((String)"java.util.Map$a12345$b12345"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)"java.util.Map$12345a"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)"java.util.Map$333"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((String)"java.util.Map3$333"));
    }

    public void testIsMemberCharArray() throws Exception {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])Map.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((char[])Map.Entry.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])Class.forName("java.util.Vector$1").getName().toCharArray()));
        Object[] array = new Map[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])array.getClass().getName().toCharArray()));
        array = new Map.Entry[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])array.getClass().getName().toCharArray()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])array.getClass().getName().toCharArray()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])array.getClass().getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((char[])"java.util.Map$a1".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((char[])"java.util.Map$1aa$aaa".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((char[])"java.util.Map$1$aaa".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((char[])"java.util.Map$a1$aaa$bbb".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((char[])"java.util.Map$1a1$aaa".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])"java.util.Map$1a".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isMember((char[])"java.util.Map$a12345$b12345".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])"java.util.Map$12345a".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])"java.util.Map$333".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isMember((char[])"java.util.Map3$333".toCharArray()));
    }

    public void testIsLocal() throws Exception {
        class LocalClass {
            LocalClass() {
            }

            void foo() {
                System.getProperty("foo");
            }
        }
        new LocalClass().foo();
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)Map.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)Map.Entry.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isLocal((String)Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)array.getClass().getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)"java.util.Map$a1"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)"java.util.Map$a1$aaa$bbb"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)"java.util.Map$11$aaa"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isLocal((String)"java.util.Map$1a"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isLocal((String)"java.util.Map$2abc"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isLocal((String)"java.util.Map$2abc1"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)"java.util.Map$a12345$b12345"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isLocal((String)"java.util.Map$12345$1234a"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)"java.util.Map$333"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((String)"java.util.Map3$333"));
    }

    public void testIsLocalCharArray() throws Exception {
        class LocalClass {
            LocalClass() {
            }

            void foo() {
                System.getProperty("foo");
            }
        }
        new LocalClass().foo();
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])Map.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])Map.Entry.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isLocal((char[])Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])Class.forName("java.util.Vector$1").getName().toCharArray()));
        Object[] array = new Map[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])array.getClass().getName().toCharArray()));
        array = new Map.Entry[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])array.getClass().getName().toCharArray()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])array.getClass().getName().toCharArray()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])array.getClass().getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])"java.util.Map$a1".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])"java.util.Map$a1$aaa$bbb".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])"java.util.Map$11$aaa".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isLocal((char[])"java.util.Map$1a".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isLocal((char[])"java.util.Map$2abc".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isLocal((char[])"java.util.Map$2abc1".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])"java.util.Map$a12345$b12345".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isLocal((char[])"java.util.Map$12345$1234a".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])"java.util.Map$333".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isLocal((char[])"java.util.Map3$333".toCharArray()));
    }

    public void testIsAnonymous() throws Exception {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)Map.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)Map.Entry.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAnonymous((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)array.getClass().getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)"java.util.Map$a1"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)"java.util.Map$a1$aaa$bbb"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)"java.util.Map$1a1$aaa"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)"java.util.Map$1$a"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)"java.util.Map$1a"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)"java.util.Map$a12345$b12345"));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((String)"java.util.Map$12345$a1234"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAnonymous((String)"java.util.Map$333"));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAnonymous((String)"java.util.Map3$333"));
    }

    public void testIsAnonymousCharArray() throws Exception {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])Map.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])Map.Entry.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAnonymous((char[])Class.forName("java.util.Vector$1").getName().toCharArray()));
        Object[] array = new Map[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])array.getClass().getName().toCharArray()));
        array = new Map.Entry[]{};
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])array.getClass().getName().toCharArray()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])array.getClass().getName().toCharArray()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])array.getClass().getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])"java.util.Map$a1".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])"java.util.Map$a1$aaa$bbb".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])"java.util.Map$1a1$aaa".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])"java.util.Map$1$a".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])"java.util.Map$1a".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])"java.util.Map$a12345$b12345".toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAnonymous((char[])"java.util.Map$12345$a1234".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAnonymous((char[])"java.util.Map$333".toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAnonymous((char[])"java.util.Map3$333".toCharArray()));
    }

    public void testIsReference() throws Exception {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isReference((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((String)Map.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((String)Map.Entry.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((String)Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((String)array.getClass().getName()));
    }

    public void testIsReferenceCharArray() throws Exception {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isReference((char[])Integer.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((char[])Map.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((char[])Map.Entry.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((char[])Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((char[])Class.forName("java.util.Vector$1").getName().toCharArray()));
        Object[] array = new Map[]{};
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((char[])array.getClass().getName().toCharArray()));
        array = new Map.Entry[]{};
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((char[])array.getClass().getName().toCharArray()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((char[])array.getClass().getName().toCharArray()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isReference((char[])array.getClass().getName().toCharArray()));
    }

    public void testIsPrimitive() {
        ClassNameToolsTests.assertTrue((boolean)Void.TYPE.isPrimitive());
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitive((String)Void.TYPE.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitive((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitive((String)Float.TYPE.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitive((String)Boolean.TYPE.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitive((String)Number.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitive((String)String.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitive((String)Boolean.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitive((String)Integer.class.getName()));
    }

    public void testIsPrimitiveCharArray() {
        ClassNameToolsTests.assertTrue((boolean)Void.TYPE.isPrimitive());
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitive((char[])Void.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitive((char[])Integer.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitive((char[])Float.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitive((char[])Boolean.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitive((char[])Number.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitive((char[])String.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitive((char[])Boolean.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitive((char[])Integer.class.getName().toCharArray()));
    }

    public void testIsPrimitiveWrapper() {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((String)Void.TYPE.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((String)Float.TYPE.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((String)Boolean.TYPE.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((String)Field.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((String)String.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitiveWrapper((String)Boolean.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitiveWrapper((String)Integer.class.getName()));
    }

    public void testIsPrimitiveWrapperCharArray() {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((char[])Void.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((char[])Integer.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((char[])Float.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((char[])Boolean.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((char[])Field.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isPrimitiveWrapper((char[])String.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitiveWrapper((char[])Boolean.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isPrimitiveWrapper((char[])Integer.class.getName().toCharArray()));
    }

    public void testIsVariablePrimitive() {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitive((String)Void.TYPE.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitive((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitive((String)Float.TYPE.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitive((String)Boolean.TYPE.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitive((String)Number.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitive((String)String.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitive((String)Boolean.class.getName()));
    }

    public void testIsVariablePrimitiveCharArray() {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitive((char[])Void.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitive((char[])Integer.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitive((char[])Float.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitive((char[])Boolean.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitive((char[])Number.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitive((char[])String.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitive((char[])Boolean.class.getName().toCharArray()));
    }

    public void testIsVariablePrimitiveWrapper() {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitiveWrapper((String)Void.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitiveWrapper((String)Integer.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitiveWrapper((String)Float.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitiveWrapper((String)Boolean.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitiveWrapper((String)Number.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitiveWrapper((String)String.class.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitiveWrapper((String)Object.class.getName()));
    }

    public void testIsVariablePrimitiveWrapperCharArray() {
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitiveWrapper((char[])Void.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitiveWrapper((char[])Integer.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitiveWrapper((char[])Float.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isVariablePrimitiveWrapper((char[])Boolean.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitiveWrapper((char[])Number.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitiveWrapper((char[])String.class.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isVariablePrimitiveWrapper((char[])Object.class.getName().toCharArray()));
    }

    public void testWrapperClassName() {
        ClassNameToolsTests.assertEquals((String)Void.class.getName(), (String)ClassNameTools.primitiveWrapperClassName((String)Void.TYPE.getName()));
        ClassNameToolsTests.assertEquals((String)Integer.class.getName(), (String)ClassNameTools.primitiveWrapperClassName((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertEquals((String)Float.class.getName(), (String)ClassNameTools.primitiveWrapperClassName((String)Float.TYPE.getName()));
        ClassNameToolsTests.assertEquals((String)Boolean.class.getName(), (String)ClassNameTools.primitiveWrapperClassName((String)Boolean.TYPE.getName()));
        ClassNameToolsTests.assertNull((Object)ClassNameTools.primitiveWrapperClassName((String)String.class.getName()));
    }

    public void testWrapperClassNameCharArray() {
        TestTools.assertEquals(Void.class.getName(), ClassNameTools.primitiveWrapperClassName((char[])Void.TYPE.getName().toCharArray()));
        TestTools.assertEquals(Integer.class.getName(), ClassNameTools.primitiveWrapperClassName((char[])Integer.TYPE.getName().toCharArray()));
        TestTools.assertEquals(Float.class.getName(), ClassNameTools.primitiveWrapperClassName((char[])Float.TYPE.getName().toCharArray()));
        TestTools.assertEquals(Boolean.class.getName(), ClassNameTools.primitiveWrapperClassName((char[])Boolean.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertNull((Object)ClassNameTools.primitiveWrapperClassName((char[])String.class.getName().toCharArray()));
    }

    public void testPrimitiveClassName() {
        ClassNameToolsTests.assertEquals((String)Void.TYPE.getName(), (String)ClassNameTools.primitiveClassName((String)Void.class.getName()));
        ClassNameToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassNameTools.primitiveClassName((String)Integer.class.getName()));
        ClassNameToolsTests.assertEquals((String)Float.TYPE.getName(), (String)ClassNameTools.primitiveClassName((String)Float.class.getName()));
        ClassNameToolsTests.assertEquals((String)Boolean.TYPE.getName(), (String)ClassNameTools.primitiveClassName((String)Boolean.class.getName()));
        ClassNameToolsTests.assertNull((Object)ClassNameTools.primitiveClassName((String)String.class.getName()));
    }

    public void testPrimitiveClassNameCharArray() {
        TestTools.assertEquals(Void.TYPE.getName(), ClassNameTools.primitiveClassName((char[])Void.class.getName().toCharArray()));
        TestTools.assertEquals(Integer.TYPE.getName(), ClassNameTools.primitiveClassName((char[])Integer.class.getName().toCharArray()));
        TestTools.assertEquals(Float.TYPE.getName(), ClassNameTools.primitiveClassName((char[])Float.class.getName().toCharArray()));
        TestTools.assertEquals(Boolean.TYPE.getName(), ClassNameTools.primitiveClassName((char[])Boolean.class.getName().toCharArray()));
        ClassNameToolsTests.assertNull((Object)ClassNameTools.primitiveClassName((char[])String.class.getName().toCharArray()));
    }

    public void testIsAutoboxEquivalent() {
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAutoboxEquivalent((String)Integer.class.getName(), (String)Integer.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAutoboxEquivalent((String)Integer.TYPE.getName(), (String)Integer.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAutoboxEquivalent((String)Integer.class.getName(), (String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAutoboxEquivalent((String)Integer.TYPE.getName(), (String)Boolean.class.getName()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAutoboxEquivalent((String)String.class.getName(), (String)String.class.getName()));
    }

    public void testIsAutoboxEquivalentCharArray() {
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAutoboxEquivalent((char[])Integer.class.getName().toCharArray(), (char[])Integer.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAutoboxEquivalent((char[])Integer.TYPE.getName().toCharArray(), (char[])Integer.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAutoboxEquivalent((char[])Integer.class.getName().toCharArray(), (char[])Integer.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertFalse((boolean)ClassNameTools.isAutoboxEquivalent((char[])Integer.TYPE.getName().toCharArray(), (char[])Boolean.class.getName().toCharArray()));
        ClassNameToolsTests.assertTrue((boolean)ClassNameTools.isAutoboxEquivalent((char[])String.class.getName().toCharArray(), (char[])String.class.getName().toCharArray()));
    }

    public void testForCode() {
        ClassNameToolsTests.assertEquals((String)"byte", (String)ClassNameTools.forCode((char)'B'));
        ClassNameToolsTests.assertEquals((String)"char", (String)ClassNameTools.forCode((char)'C'));
        ClassNameToolsTests.assertEquals((String)"double", (String)ClassNameTools.forCode((char)'D'));
        ClassNameToolsTests.assertEquals((String)"float", (String)ClassNameTools.forCode((char)'F'));
        ClassNameToolsTests.assertEquals((String)"int", (String)ClassNameTools.forCode((char)'I'));
        ClassNameToolsTests.assertEquals((String)"long", (String)ClassNameTools.forCode((char)'J'));
        ClassNameToolsTests.assertEquals((String)"short", (String)ClassNameTools.forCode((char)'S'));
        ClassNameToolsTests.assertEquals((String)"boolean", (String)ClassNameTools.forCode((char)'Z'));
        ClassNameToolsTests.assertEquals((String)"void", (String)ClassNameTools.forCode((char)'V'));
        ClassNameToolsTests.assertNull((Object)ClassNameTools.forCode((char)'X'));
        ClassNameToolsTests.assertEquals((String)"byte", (String)ClassNameTools.forCode((int)66));
        ClassNameToolsTests.assertEquals((String)"char", (String)ClassNameTools.forCode((int)67));
        ClassNameToolsTests.assertEquals((String)"double", (String)ClassNameTools.forCode((int)68));
        ClassNameToolsTests.assertEquals((String)"float", (String)ClassNameTools.forCode((int)70));
        ClassNameToolsTests.assertEquals((String)"int", (String)ClassNameTools.forCode((int)73));
        ClassNameToolsTests.assertEquals((String)"long", (String)ClassNameTools.forCode((int)74));
        ClassNameToolsTests.assertEquals((String)"short", (String)ClassNameTools.forCode((int)83));
        ClassNameToolsTests.assertEquals((String)"boolean", (String)ClassNameTools.forCode((int)90));
        ClassNameToolsTests.assertEquals((String)"void", (String)ClassNameTools.forCode((int)86));
        ClassNameToolsTests.assertNull((Object)ClassNameTools.forCode((int)88));
    }

    public void testForCodeCharArray() {
        TestTools.assertEquals("byte", ClassNameTools.forCodeCharArray((char)'B'));
        TestTools.assertEquals("char", ClassNameTools.forCodeCharArray((char)'C'));
        TestTools.assertEquals("double", ClassNameTools.forCodeCharArray((char)'D'));
        TestTools.assertEquals("float", ClassNameTools.forCodeCharArray((char)'F'));
        TestTools.assertEquals("int", ClassNameTools.forCodeCharArray((char)'I'));
        TestTools.assertEquals("long", ClassNameTools.forCodeCharArray((char)'J'));
        TestTools.assertEquals("short", ClassNameTools.forCodeCharArray((char)'S'));
        TestTools.assertEquals("boolean", ClassNameTools.forCodeCharArray((char)'Z'));
        TestTools.assertEquals("void", ClassNameTools.forCodeCharArray((char)'V'));
        ClassNameToolsTests.assertNull((Object)ClassNameTools.forCodeCharArray((char)'X'));
        TestTools.assertEquals("byte", ClassNameTools.forCodeCharArray((int)66));
        TestTools.assertEquals("char", ClassNameTools.forCodeCharArray((int)67));
        TestTools.assertEquals("double", ClassNameTools.forCodeCharArray((int)68));
        TestTools.assertEquals("float", ClassNameTools.forCodeCharArray((int)70));
        TestTools.assertEquals("int", ClassNameTools.forCodeCharArray((int)73));
        TestTools.assertEquals("long", ClassNameTools.forCodeCharArray((int)74));
        TestTools.assertEquals("short", ClassNameTools.forCodeCharArray((int)83));
        TestTools.assertEquals("boolean", ClassNameTools.forCodeCharArray((int)90));
        TestTools.assertEquals("void", ClassNameTools.forCodeCharArray((int)86));
        ClassNameToolsTests.assertNull((Object)ClassNameTools.forCodeCharArray((int)88));
    }

    public void testPrimitiveClassCode() {
        ClassNameToolsTests.assertEquals((char)'I', (char)ClassNameTools.primitiveClassCode((String)Integer.TYPE.getName()));
        ClassNameToolsTests.assertEquals((char)'I', (char)ClassNameTools.primitiveClassCode((String)"int"));
        ClassNameToolsTests.assertEquals((char)'B', (char)ClassNameTools.primitiveClassCode((String)Byte.TYPE.getName()));
        ClassNameToolsTests.assertEquals((char)'B', (char)ClassNameTools.primitiveClassCode((String)"byte"));
        ClassNameToolsTests.assertEquals((char)'\u0000', (char)ClassNameTools.primitiveClassCode((String)Object.class.getName()));
    }

    public void testPrimitiveClassCodeCharArray() {
        ClassNameToolsTests.assertEquals((char)'I', (char)ClassNameTools.primitiveClassCode((char[])Integer.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertEquals((char)'I', (char)ClassNameTools.primitiveClassCode((char[])"int".toCharArray()));
        ClassNameToolsTests.assertEquals((char)'B', (char)ClassNameTools.primitiveClassCode((char[])Byte.TYPE.getName().toCharArray()));
        ClassNameToolsTests.assertEquals((char)'B', (char)ClassNameTools.primitiveClassCode((char[])"byte".toCharArray()));
        ClassNameToolsTests.assertEquals((char)'\u0000', (char)ClassNameTools.primitiveClassCode((char[])Object.class.getName().toCharArray()));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(ClassNameTools.class);
                ClassNameToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        ClassNameToolsTests.assertTrue((boolean)exCaught);
    }
}

