/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value.swing;

import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;

public class NumberSpinnerModelAdapter
extends SpinnerNumberModel {
    private final Number defaultValue;
    private final ModifiablePropertyValueModel<Number> numberHolder;
    private final PropertyChangeListener numberChangeListener;
    private static final long serialVersionUID = 1L;

    public NumberSpinnerModelAdapter(ModifiablePropertyValueModel<Number> numberHolder) {
        this(numberHolder, 0);
    }

    public NumberSpinnerModelAdapter(ModifiablePropertyValueModel<Number> numberHolder, int defaultValue) {
        this(numberHolder, null, null, (Number)1, (Number)defaultValue);
    }

    public NumberSpinnerModelAdapter(ModifiablePropertyValueModel<Number> numberHolder, int minimum, int maximum, int stepSize) {
        this(numberHolder, minimum, maximum, stepSize, minimum);
    }

    public NumberSpinnerModelAdapter(ModifiablePropertyValueModel<Number> numberHolder, int minimum, int maximum, int stepSize, int defaultValue) {
        this(numberHolder, Integer.valueOf(minimum), Integer.valueOf(maximum), (Number)stepSize, (Number)defaultValue);
    }

    public NumberSpinnerModelAdapter(ModifiablePropertyValueModel<Number> numberHolder, double minimum, double maximum, double stepSize) {
        this(numberHolder, minimum, maximum, stepSize, minimum);
    }

    public NumberSpinnerModelAdapter(ModifiablePropertyValueModel<Number> numberHolder, double minimum, double maximum, double stepSize, double defaultValue) {
        this(numberHolder, Double.valueOf(minimum), Double.valueOf(maximum), (Number)stepSize, (Number)defaultValue);
    }

    public NumberSpinnerModelAdapter(ModifiablePropertyValueModel<Number> numberHolder, Comparable<?> minimum, Comparable<?> maximum, Number stepSize, Number defaultValue) {
        super(numberHolder.getValue() == null ? (Number)defaultValue : (Number)((Number)numberHolder.getValue()), minimum, maximum, stepSize);
        this.numberHolder = numberHolder;
        this.numberChangeListener = this.buildNumberChangeListener();
        this.defaultValue = defaultValue;
    }

    protected PropertyChangeListener buildNumberChangeListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildNumberChangeListener_());
    }

    protected PropertyChangeListener buildNumberChangeListener_() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent event) {
                NumberSpinnerModelAdapter.this.synchronize(event.getNewValue());
            }

            public String toString() {
                return "number listener";
            }
        };
    }

    @Override
    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.numberHolder.getValue()));
        }
        return super.getValue();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.numberHolder.setValue((Number)value);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.getChangeListeners().length == 0) {
            this.numberHolder.addPropertyChangeListener("value", this.numberChangeListener);
            this.synchronize(this.numberHolder.getValue());
        }
        super.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.getChangeListeners().length == 0) {
            this.numberHolder.removePropertyChangeListener("value", this.numberChangeListener);
        }
    }

    protected Number getDefaultValue() {
        return this.defaultValue;
    }

    protected Object spinnerValueOf(Object value) {
        return value == null ? this.getDefaultValue() : value;
    }

    void synchronize(Object value) {
        Object newValue = this.spinnerValueOf(value);
        if (!this.getValue().equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.numberHolder);
    }
}

