/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.TemporalType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityIDGeneratedValue;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlField;
import org.eclipse.persistence.tools.mapping.orm.ExternalSequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityIDGeneratedValue;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlField;
import org.eclipse.persistence.tools.mapping.orm.dom.SequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.TableGenerator;
import org.w3c.dom.Element;

final class BasicMapping
extends ConvertibleMapping
implements ExternalBasicMapping {
    static final String BASIC = "basic";
    static final String ENUMERATED = "enumerated";
    static final String FETCH = "fetch";
    static final String LOB = "lob";
    static final String MUTABLE = "mutable";
    static final String OPTIONAL = "optional";
    static final String RETURN_INSERT = "return-insert";
    static final String RETURN_ONLY = "return-only";
    static final String RETURN_UPDATE = "return-update";
    static final String TEMPORAL = "temporal";

    BasicMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public ExternalEntityIDGeneratedValue addGeneratedValue() {
        EntityIDGeneratedValue generatedValue = this.buildGeneratedValue();
        generatedValue.addSelf();
        return generatedValue;
    }

    @Override
    public ExternalSequenceGenerator addSequenceGenerator() {
        SequenceGenerator sequenceGenerator = this.buildSequenceGenerator();
        sequenceGenerator.addSelf();
        return sequenceGenerator;
    }

    @Override
    public ExternalTableGenerator addTableGenerator() {
        TableGenerator tableGenerator = this.buildTableGenerator();
        tableGenerator.addSelf();
        return tableGenerator;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add(FETCH);
        names.add(OPTIONAL);
        names.add("access");
        names.add(MUTABLE);
        names.add("attribute-type");
        return names;
    }

    private EntityColumn buildColumn() {
        return new EntityColumn(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("column");
        names.add("field");
        names.add("generated-value");
        names.add(LOB);
        names.add(TEMPORAL);
        names.add(ENUMERATED);
        names.add("convert");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("table-generator");
        names.add("sequence-generator");
        names.add("property");
        names.add("access-methods");
        names.add(RETURN_INSERT);
        names.add(RETURN_UPDATE);
        return names;
    }

    private EntityIDGeneratedValue buildGeneratedValue() {
        return new EntityIDGeneratedValue(this);
    }

    private ExternalNoSqlField buildNoSqlField() {
        return new NoSqlField(this);
    }

    private SequenceGenerator buildSequenceGenerator() {
        return new SequenceGenerator(this);
    }

    private TableGenerator buildTableGenerator() {
        return new TableGenerator(this);
    }

    @Override
    public ExternalEntityColumn getColumn() {
        return this.buildColumn();
    }

    @Override
    protected String getElementName() {
        return BASIC;
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.getChildEnumNode(ENUMERATED, EnumType.class);
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute(FETCH, FetchType.class);
    }

    @Override
    public ExternalEntityIDGeneratedValue getGeneratedValue() {
        if (this.hasChild("generated-value")) {
            return this.buildGeneratedValue();
        }
        return null;
    }

    @Override
    public String getNoSqlField() {
        ExternalNoSqlField field = this.buildNoSqlField();
        return field.getName();
    }

    @Override
    public ExternalSequenceGenerator getSequenceGenerator() {
        Element element = this.getChild("sequence-generator");
        if (element == null) {
            return null;
        }
        return this.buildSequenceGenerator();
    }

    @Override
    public ExternalTableGenerator getTableGenerator() {
        Element element = this.getChild("table-generator");
        if (element == null) {
            return null;
        }
        return this.buildTableGenerator();
    }

    @Override
    public TemporalType getTemporalType() {
        return this.getChildEnumNode(TEMPORAL, TemporalType.class);
    }

    @Override
    public final boolean isBasicMapping() {
        return true;
    }

    @Override
    public Boolean isLob() {
        return this.getChildBooleanNode(LOB);
    }

    @Override
    public Boolean isMutable() {
        return this.getBooleanAttribute(MUTABLE);
    }

    @Override
    public Boolean isOptional() {
        return this.getBooleanAttribute(OPTIONAL);
    }

    @Override
    public void removeGeneratedValue() {
        EntityIDGeneratedValue generatedValue = this.buildGeneratedValue();
        generatedValue.removeSelf();
    }

    @Override
    public void removeSequenceGenerator() {
        SequenceGenerator generator = this.buildSequenceGenerator();
        generator.removeSelf();
    }

    @Override
    public void removeTableGenerator() {
        TableGenerator generator = this.buildTableGenerator();
        generator.removeSelf();
    }

    @Override
    public Boolean returnOnInsert() {
        return this.hasChild(RETURN_INSERT);
    }

    @Override
    public Boolean returnOnlyOnInsert() {
        Element returnInsertElement = this.getChild(RETURN_INSERT);
        if (returnInsertElement != null) {
            return this.getBooleanAttribute(returnInsertElement, RETURN_ONLY);
        }
        return null;
    }

    @Override
    public Boolean returnOnUpdate() {
        return this.hasChild(RETURN_UPDATE);
    }

    @Override
    public void setAttributeType(String attributeType) {
        this.setAttribute("attribute-type", attributeType);
    }

    @Override
    public void setColumn(String columnName) {
        this.removeChild("column");
        if (columnName != null) {
            EntityColumn entityColumn = this.buildColumn();
            entityColumn.addSelf();
            entityColumn.setName(columnName);
        }
    }

    @Override
    public void setEnumeratedType(EnumType type) {
        this.updateChildTextNode(ENUMERATED, (Enum<?>)type);
    }

    @Override
    public void setFetchType(FetchType type) {
        this.setAttribute(FETCH, (Enum<?>)type);
    }

    @Override
    public void setLob(Boolean lob) {
        this.updateChildTextNode(LOB, lob);
    }

    @Override
    public void setMutable(Boolean mutable) {
        this.setAttribute(MUTABLE, mutable);
    }

    @Override
    public void setNoSqlField(String field) {
        ExternalNoSqlField noSqlField = this.buildNoSqlField();
        noSqlField.setName(field);
    }

    @Override
    public void setOptional(Boolean optional) {
        this.setAttribute(OPTIONAL, optional);
    }

    @Override
    public void setReturnOnInsert(Boolean returnOnInsert) {
        if (returnOnInsert == Boolean.TRUE) {
            this.addChild(RETURN_INSERT);
        } else {
            this.removeChild(RETURN_INSERT);
        }
    }

    @Override
    public void setReturnOnlyOnInsert(Boolean returnOnlyOnInsert) {
        if (returnOnlyOnInsert != null) {
            Element returnInsertElement = this.addChild(RETURN_INSERT);
            this.setAttribute(returnInsertElement, RETURN_ONLY, returnOnlyOnInsert);
        }
    }

    @Override
    public void setReturnOnUpdate(Boolean returnOnUpdate) {
        if (returnOnUpdate == Boolean.TRUE) {
            this.addChild(RETURN_UPDATE);
        } else {
            this.removeChild(RETURN_UPDATE);
        }
    }

    @Override
    public void setSequenceGenerator(String generatorName) {
        this.updateChildTextNode("sequence-generator", generatorName);
    }

    @Override
    public void setTableGenerator(String generatorName) {
        this.updateChildTextNode("table-generator", generatorName);
    }

    @Override
    public void setTemporalType(TemporalType type) {
        this.updateChildTextNode(TEMPORAL, (Enum<?>)type);
    }
}

