/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalManyToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.RelationshipMapping;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class ManyToOneMapping
extends RelationshipMapping
implements ExternalManyToOneMapping {
    static final String ID = "id";
    static final String MANY_TO_ONE = "many-to-one";
    static final String MAPPED_BY = "mapped-by-id";
    static final String MAPS_ID = "maps-id";

    ManyToOneMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public void addJoinColumn(int index, String name) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.addSelf();
        joinColumn.setName(name);
    }

    @Override
    public void addJoinField(int index, String name) {
        ExternalNoSqlJoinField joinField = this.buildJoinField(index);
        joinField.setName(name);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("target-entity");
        names.add("fetch");
        names.add("optional");
        names.add("access");
        names.add(MAPPED_BY);
        names.add(MAPS_ID);
        names.add(ID);
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("join-column");
        names.add("join-table");
        names.add("join-fetch");
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, index);
    }

    private ExternalNoSqlJoinField buildJoinField(int index) {
        return new NoSqlJoinField(this, index);
    }

    @Override
    protected String getElementName() {
        return MANY_TO_ONE;
    }

    @Override
    public Boolean getId() {
        return this.getBooleanAttribute(ID);
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        Element element = this.getChild("join-column", index);
        if (element == null) {
            return null;
        }
        return this.buildJoinColumn(index);
    }

    @Override
    public String getMappedByMappingName() {
        return this.getAttribute(MAPPED_BY);
    }

    @Override
    public String getMapsId() {
        return this.getAttribute(MAPS_ID);
    }

    @Override
    public ListIterable<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            JoinColumn joinColumn = this.buildJoinColumn(index);
            joinColumns.add(0, joinColumn);
        }
        return new ListListIterable(joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public ListIterable<ExternalNoSqlJoinField> joinFields() {
        int count = this.joinFieldSize();
        ArrayList<ExternalNoSqlJoinField> joinFields = new ArrayList<ExternalNoSqlJoinField>(count);
        int index = count;
        while (--index >= 0) {
            ExternalNoSqlJoinField joinField = this.buildJoinField(index);
            joinFields.add(0, joinField);
        }
        return new ListListIterable(joinFields);
    }

    @Override
    public int joinFieldSize() {
        return this.getChildrenSize("join-field");
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeJoinField(int index) {
        this.removeChild("join-field", index);
    }

    @Override
    public void setId(Boolean id) {
        this.setAttribute(ID, id);
    }

    @Override
    public void setMappedByMappingName(String name) {
        this.setAttribute(MAPPED_BY, name);
    }

    @Override
    public void setMapsId(String mapsId) {
        this.setAttribute(MAPS_ID, mapsId);
    }
}

