/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.AccessType;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityListener;
import org.eclipse.persistence.tools.mapping.orm.ExternalPersistenceUnit;
import org.eclipse.persistence.tools.mapping.orm.ExternalTenantDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityListener;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.TenantDiscriminatorColumn;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class PersistenceUnit
extends AbstractExternalForm
implements ExternalPersistenceUnit {
    static final String ACCESS = "access";
    static final String CASCADE_PERSIST = "cascade-persist";
    static final String CATALOG = "catalog";
    static final String DELIMITED_IDENTIFIERS = "delimited-identifiers";
    static final String DESCRIPTION = "description";
    static final String EXCLUDE_DEFAULT_MAPPINGS = "exclude-default-mappings";
    static final String PERSISTENCE_UNIT_DEFAULTS = "persistence-unit-defaults";
    static final String PERSISTENCE_UNIT_METADATA = "persistence-unit-metadata";
    static final String SCHEMA = "schema";
    static final String XML_MAPPING_METADATA_COMPLETE = "xml-mapping-metadata-complete";

    PersistenceUnit(ORMConfiguration parent) {
        super(parent);
    }

    @Override
    public ExternalTenantDiscriminatorColumn addDiscriminatorColumn(int index) {
        TenantDiscriminatorColumn column = this.buildDiscriminatorColumn(index);
        column.addSelf();
        return column;
    }

    @Override
    public void addEntityListener(int index, String className) {
        EntityListener entityListener = this.buildEntityListener(index);
        entityListener.addSelf();
        entityListener.setClassName(className);
    }

    private TenantDiscriminatorColumn buildDiscriminatorColumn(int index) {
        return new TenantDiscriminatorColumn(this, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DESCRIPTION);
        names.add(XML_MAPPING_METADATA_COMPLETE);
        names.add(EXCLUDE_DEFAULT_MAPPINGS);
        names.add(PERSISTENCE_UNIT_DEFAULTS);
        return names;
    }

    private EntityListener buildEntityListener(int index) {
        return new EntityListener(this, index);
    }

    @Override
    public ListIterable<ExternalTenantDiscriminatorColumn> discriminatorColumns() {
        int count = this.discriminatorColumnSize();
        ArrayList<TenantDiscriminatorColumn> columns = new ArrayList<TenantDiscriminatorColumn>(count);
        int index = count;
        while (--index >= 0) {
            TenantDiscriminatorColumn column = this.buildDiscriminatorColumn(index);
            columns.add(0, column);
        }
        return new ListListIterable(columns);
    }

    @Override
    public int discriminatorColumnSize() {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element == null) {
            return 0;
        }
        return this.getChildrenSize((Node)element, "tenant-discriminator-column");
    }

    @Override
    public ExternalTenantDiscriminatorColumn getDiscriminatorColumn(int index) {
        Element puElem = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (puElem == null) {
            return null;
        }
        Element element = this.getChild(puElem, "tenant-discriminator-column", index);
        if (element == null) {
            return null;
        }
        return this.buildDiscriminatorColumn(index);
    }

    @Override
    public ListIterable<ExternalEntityListener> entityListeners() {
        int count = this.entityListenersSize();
        ArrayList<EntityListener> entityListeners = new ArrayList<EntityListener>(count);
        int index = count;
        while (--index >= 0) {
            EntityListener entityListener = this.buildEntityListener(index);
            entityListeners.add(0, entityListener);
        }
        return new ListListIterable(entityListeners);
    }

    @Override
    public int entityListenersSize() {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element == null) {
            return 0;
        }
        if ((element = this.getChild((Node)element, EntityListener.ENTITY_LISTENERS)) == null) {
            return 0;
        }
        return this.getChildrenSize((Node)element, EntityListener.ENTITY_LISTENER);
    }

    @Override
    public AccessType getDefaultAccessType() {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element != null) {
            return this.getChildEnumNode(element, ACCESS, AccessType.class);
        }
        return null;
    }

    @Override
    public String getDefaultCatalogName() {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element != null) {
            return this.getChildTextNode(element, CATALOG);
        }
        return null;
    }

    @Override
    public String getDefaultDescription() {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element != null) {
            return this.getChildTextNode(element, DESCRIPTION);
        }
        return null;
    }

    @Override
    public String getDefaultSchemaName() {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element != null) {
            return this.getChildTextNode(element, SCHEMA);
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode(DESCRIPTION);
    }

    @Override
    protected String getElementName() {
        return PERSISTENCE_UNIT_METADATA;
    }

    @Override
    public ExternalEntityListener getEntityListener(int index) {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element == null) {
            return null;
        }
        if ((element = this.getChild((Node)element, EntityListener.ENTITY_LISTENERS)) == null) {
            return null;
        }
        if ((element = this.getChild(element, EntityListener.ENTITY_LISTENER, index)) == null) {
            return null;
        }
        return this.buildEntityListener(index);
    }

    @Override
    public boolean isDefault() {
        return this.getAllChildrenSize() == 0;
    }

    @Override
    public boolean isDelimitedIdentifers() {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element != null) {
            return this.hasChild(element, DELIMITED_IDENTIFIERS);
        }
        return false;
    }

    @Override
    public boolean isExcludeDefaultMappings() {
        return this.hasChild(EXCLUDE_DEFAULT_MAPPINGS);
    }

    @Override
    public boolean isMappingMetaDataComplete() {
        return this.hasChild(XML_MAPPING_METADATA_COMPLETE);
    }

    @Override
    public void removeDiscriminatorColumn(int index) {
        TenantDiscriminatorColumn entityListener = this.buildDiscriminatorColumn(index);
        entityListener.removeSelf();
        Element parentElement = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (parentElement != null && !this.hasAnyChildren(parentElement)) {
            this.remove(parentElement);
            if (!this.hasAnyChildren()) {
                this.removeSelf();
            }
        }
    }

    @Override
    public void removeEntityListener(int index) {
        EntityListener entityListener = this.buildEntityListener(index);
        entityListener.removeSelf();
        Element parentElement = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        Element element = this.getChild((Node)parentElement, EntityListener.ENTITY_LISTENERS);
        if (parentElement != null && element != null && !this.hasAnyChildren(element)) {
            this.remove(parentElement, element);
        }
        if (parentElement != null && !this.hasAnyChildren(parentElement)) {
            this.remove(parentElement);
            if (!this.hasAnyChildren()) {
                this.removeSelf();
            }
        }
    }

    @Override
    public void setDefaultAccessType(AccessType type) {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element == null && type == null) {
            return;
        }
        if (element == null) {
            element = this.addChild(PERSISTENCE_UNIT_DEFAULTS);
        }
        this.updateTextNode(element, ACCESS, (Enum<?>)type);
        if (!this.hasAnyChildren(element)) {
            this.remove(element);
            if (!this.hasAnyChildren()) {
                this.removeSelf();
            }
        }
    }

    @Override
    public void setDefaultCatalogName(String catalogName) {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element == null && catalogName == null) {
            return;
        }
        if (element == null) {
            element = this.addChild(PERSISTENCE_UNIT_DEFAULTS);
        }
        this.updateTextNode(element, CATALOG, catalogName);
        if (!this.hasAnyChildren(element)) {
            this.remove(element);
            if (!this.hasAnyChildren()) {
                this.removeSelf();
            }
        }
    }

    @Override
    public void setDefaultDescription(String description) {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element == null && description == null) {
            return;
        }
        if (element == null) {
            element = this.addChild(PERSISTENCE_UNIT_DEFAULTS);
        }
        this.updateTextNode(element, DESCRIPTION, description);
        if (!this.hasAnyChildren(element)) {
            this.remove(element);
            if (!this.hasAnyChildren()) {
                this.removeSelf();
            }
        }
    }

    @Override
    public void setDefaultSchemaName(String schemaName) {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element == null && schemaName == null) {
            return;
        }
        if (element == null) {
            element = this.addChild(PERSISTENCE_UNIT_DEFAULTS);
        }
        this.updateTextNode(element, SCHEMA, schemaName);
        if (!this.hasAnyChildren(element)) {
            this.remove(element);
            if (!this.hasAnyChildren()) {
                this.removeSelf();
            }
        }
    }

    @Override
    public void setDelimitedIdentifers(boolean delimitIdentifiers) {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (delimitIdentifiers) {
            if (element == null) {
                element = this.addChild(PERSISTENCE_UNIT_DEFAULTS);
            }
            this.addChild(element, DELIMITED_IDENTIFIERS);
        } else if (element != null) {
            this.removeChild(element, DELIMITED_IDENTIFIERS);
            if (!this.hasAnyChildren(element)) {
                this.remove(element);
                if (!this.hasAnyChildren()) {
                    this.removeSelf();
                }
            }
        }
    }

    @Override
    public void setDescription(String description) {
        if (description == null) {
            this.removeChild(DESCRIPTION);
            if (!this.hasAnyChildren()) {
                this.removeSelf();
            }
        } else {
            Element element = this.getChild(DESCRIPTION);
            if (element == null) {
                this.addChild(DESCRIPTION);
            }
            this.updateChildTextNode(DESCRIPTION, description);
        }
    }

    @Override
    public void setExcludeDefaultMappings(boolean excludeDefaultMappings) {
        if (excludeDefaultMappings) {
            this.addChild(EXCLUDE_DEFAULT_MAPPINGS);
        } else {
            this.removeChild(EXCLUDE_DEFAULT_MAPPINGS);
            if (!this.hasAnyChildren()) {
                this.removeSelf();
                if (!this.hasAnyChildren()) {
                    this.removeSelf();
                }
            }
        }
    }

    @Override
    public void setMappingMetaDataComplete(boolean metaDataComplete) {
        if (metaDataComplete) {
            this.addChild(XML_MAPPING_METADATA_COMPLETE);
        } else {
            this.removeChild(XML_MAPPING_METADATA_COMPLETE);
            if (!this.hasAnyChildren()) {
                this.removeSelf();
                if (!this.hasAnyChildren()) {
                    this.removeSelf();
                }
            }
        }
    }

    @Override
    public void setUsesCascadePersistByDefault(boolean cascadePersistByDefault) {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element == null && !cascadePersistByDefault) {
            return;
        }
        if (element == null) {
            element = this.addChild(PERSISTENCE_UNIT_DEFAULTS);
        }
        if (cascadePersistByDefault) {
            this.addChild(element, CASCADE_PERSIST);
        } else {
            this.removeChild(element, CASCADE_PERSIST);
            if (!this.hasAnyChildren(element)) {
                this.remove(element);
                if (!this.hasAnyChildren()) {
                    this.removeSelf();
                }
            }
        }
    }

    @Override
    public boolean usesCascadePersistByDefault() {
        Element element = this.getChild(PERSISTENCE_UNIT_DEFAULTS);
        if (element != null) {
            return this.hasChild(element, CASCADE_PERSIST);
        }
        return false;
    }
}

