/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.FetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalTransformationMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalTransformer;
import org.eclipse.persistence.tools.mapping.orm.ExternalWriteTransformer;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.NonTransientMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.ReadTransformer;
import org.eclipse.persistence.tools.mapping.orm.dom.WriteTransfomer;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class TransformationMapping
extends NonTransientMapping
implements ExternalTransformationMapping {
    static final String ACCESS = "access";
    static final String FETCH = "fetch";
    static final String MUTABLE = "mutable";
    static final String OPTIONAL = "optional";
    static final String TRANSFORMATION = "transformation";

    TransformationMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public ExternalTransformer addReadTransformer() {
        ReadTransformer transformer = this.buildReadTransformer();
        transformer.addSelf();
        return transformer;
    }

    @Override
    public ExternalWriteTransformer addWriteTransformer(int index) {
        WriteTransfomer writeTransformer = this.buildWriteTransformer(index);
        writeTransformer.addSelf();
        return writeTransformer;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add(FETCH);
        names.add(OPTIONAL);
        names.add(ACCESS);
        names.add(MUTABLE);
        names.add("attribute-type");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("read-transformer");
        names.add("write-transformer");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private ReadTransformer buildReadTransformer() {
        return new ReadTransformer(this);
    }

    private WriteTransfomer buildWriteTransformer(int index) {
        return new WriteTransfomer(this, index);
    }

    @Override
    protected String getElementName() {
        return TRANSFORMATION;
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute(FETCH, FetchType.class);
    }

    @Override
    public ExternalTransformer getReadTransformer() {
        if (this.hasChild("read-transformer")) {
            return this.buildReadTransformer();
        }
        return null;
    }

    @Override
    public ExternalWriteTransformer getWriteTransformer(int index) {
        Element element = this.getChild("write-transformer", index);
        if (element == null) {
            return null;
        }
        return this.buildWriteTransformer(index);
    }

    @Override
    public Boolean isMutable() {
        return this.getBooleanAttribute(MUTABLE);
    }

    @Override
    public Boolean isOptional() {
        return this.getBooleanAttribute(OPTIONAL);
    }

    @Override
    public void removeReadTransformer() {
        ReadTransformer transformer = this.buildReadTransformer();
        transformer.removeSelf();
    }

    @Override
    public void removeWriteTransformer(int index) {
        WriteTransfomer writeTransformer = this.buildWriteTransformer(index);
        writeTransformer.removeSelf();
    }

    @Override
    public void setAttributeType(String attributeType) {
        this.setAttribute("attribute-type", attributeType);
    }

    @Override
    public void setFetchType(FetchType type) {
        this.setAttribute(FETCH, (Enum<?>)type);
    }

    @Override
    public void setIsMutable(Boolean mutable) {
        this.setAttribute(MUTABLE, mutable);
    }

    @Override
    public void setOptional(Boolean optional) {
        this.setAttribute(OPTIONAL, optional);
    }

    @Override
    public ListIterable<ExternalWriteTransformer> writeTransformers() {
        int count = this.writeTransformersSize();
        ArrayList<WriteTransfomer> writeTransformers = new ArrayList<WriteTransfomer>(count);
        int index = count;
        while (--index >= 0) {
            WriteTransfomer joinColumn = this.buildWriteTransformer(index);
            writeTransformers.add(0, joinColumn);
        }
        return new ListListIterable(writeTransformers);
    }

    @Override
    public int writeTransformersSize() {
        return this.getChildrenSize("write-transformer");
    }
}

