/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.persistence.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.persistence.ValidationMode;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceUnit;
import org.eclipse.persistence.tools.mapping.persistence.ExternalProperty;
import org.eclipse.persistence.tools.mapping.persistence.dom.PersistenceConfiguration;
import org.eclipse.persistence.tools.mapping.persistence.dom.Property;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class PersistenceUnit
extends AbstractExternalForm
implements ExternalPersistenceUnit {
    private int index;
    static final String CACHE_TYPE = "cache-type";
    static final String CLASS = "class";
    static final String DESCRIPTION = "description";
    static final String EXCLUDE_UNLISTED_CLASSES = "exclude-unlisted-classes";
    static final String JAR_FILE = "jar-file";
    static final String JTA_DATA_SOURCE = "jta-data-source";
    static final String MAPPING_FILE = "mapping-file";
    static final String NAME = "name";
    static final String NON_JTA_DATA_SOURCE = "non-jta-data-source";
    static final String PERSISTENCE_UNIT = "persistence-unit";
    static final String PROVIDER = "provider";
    static final String TRANSACTION_TYPE = "transaction-type";
    static final String VALIDATION_MODE = "validation-mode";

    PersistenceUnit(PersistenceConfiguration parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public ExternalProperty addProperty(int index, String name, String value) {
        Property property = this.buildProperty(index);
        property.addSelf();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    @Override
    public ExternalProperty addProperty(String name, String value) {
        Property property = this.buildProperty(this.propertiesSize());
        property.addSelf();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    @Override
    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        return this.addChild(this.getParent(), elementName, this.index, elementNamesOrder);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DESCRIPTION);
        names.add(PROVIDER);
        names.add(JTA_DATA_SOURCE);
        names.add(NON_JTA_DATA_SOURCE);
        names.add(MAPPING_FILE);
        names.add(JAR_FILE);
        names.add(CLASS);
        names.add(EXCLUDE_UNLISTED_CLASSES);
        names.add(CACHE_TYPE);
        names.add(VALIDATION_MODE);
        names.add("properties");
        return names;
    }

    private Property buildProperty(int index) {
        return new Property(this, index);
    }

    @Override
    public ExternalPersistenceUnit.CacheType getCachType() {
        return this.getChildEnumNode(CACHE_TYPE, ExternalPersistenceUnit.CacheType.class);
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode(DESCRIPTION);
    }

    @Override
    public Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return PERSISTENCE_UNIT;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getJdbcDriver() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.driver");
        return property != null ? property.getValue() : null;
    }

    @Override
    public String getJdbcPassword() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.password");
        return property != null ? property.getValue() : null;
    }

    @Override
    public String getJdbcUrl() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.url");
        return property != null ? property.getValue() : null;
    }

    @Override
    public String getJdbcUser() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.user");
        return property != null ? property.getValue() : null;
    }

    @Override
    public String getJtaDatasource() {
        return this.getChildTextNode(JTA_DATA_SOURCE);
    }

    @Override
    public String getName() {
        return this.getAttribute(NAME);
    }

    @Override
    public String getNonJtaDatasource() {
        return this.getChildTextNode(NON_JTA_DATA_SOURCE);
    }

    @Override
    public Integer getPessimisticLockTimeout() {
        ExternalProperty property = this.getProperty("javax.persistence.lock.timeout");
        if (property != null) {
            try {
                return Integer.valueOf(property.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public List<ExternalProperty> getProperties(String name) {
        ArrayList<ExternalProperty> properties = new ArrayList<ExternalProperty>();
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            properties.add(property);
        }
        return properties;
    }

    @Override
    public ExternalProperty getProperty(int index) {
        Element element = this.getChild("properties");
        if (element == null) {
            return null;
        }
        if ((element = this.getChild(element, "property", index)) == null) {
            return null;
        }
        return this.buildProperty(index);
    }

    @Override
    public ExternalProperty getProperty(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public ExternalProperty getProperty(String name, int index) {
        ExternalProperty property = this.getProperty(index);
        if (property != null && ObjectTools.equals((Object)name, (Object)property.getName())) {
            return property;
        }
        return null;
    }

    @Override
    public ExternalProperty getProperty(String name, String value) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name) || !ObjectTools.equals((Object)property.getValue(), (Object)value)) continue;
            return property;
        }
        return null;
    }

    @Override
    public String getProvider() {
        return this.getChildTextNode(PROVIDER);
    }

    @Override
    public Integer getQueryTimeout() {
        ExternalProperty property = this.getProperty("javax.persistence.query.timeout");
        if (property != null) {
            try {
                return Integer.valueOf(property.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public ExternalPersistenceUnit.TransactionType getTransactionType() {
        return this.getEnumAttribute(TRANSACTION_TYPE, ExternalPersistenceUnit.TransactionType.class);
    }

    @Override
    public ValidationMode getValidationMode() {
        return this.getChildEnumNode(VALIDATION_MODE, ValidationMode.class);
    }

    @Override
    public ListIterable<String> includedClasses() {
        return new ListListIterable(this.getChildrenTextNode(CLASS));
    }

    @Override
    public int includedClassesSize() {
        return this.getChildrenSize(CLASS);
    }

    @Override
    public ListIterable<String> jarFiles() {
        return new ListListIterable(this.getChildrenTextNode(JAR_FILE));
    }

    @Override
    public int jarFilesSize() {
        return this.getChildrenSize(JAR_FILE);
    }

    @Override
    public ListIterable<String> mappingFiles() {
        return new ListListIterable(this.getChildrenTextNode(MAPPING_FILE));
    }

    @Override
    public int mappingFilesSize() {
        return this.getChildrenSize(MAPPING_FILE);
    }

    @Override
    public ListIterable<ExternalProperty> properties() {
        int count = this.propertiesSize();
        ArrayList<Property> properties = new ArrayList<Property>(count);
        int index = count;
        while (--index >= 0) {
            Property externalProperty = this.buildProperty(index);
            properties.add(0, externalProperty);
        }
        return new ListListIterable(properties);
    }

    @Override
    public int propertiesSize() {
        Element element = this.getChild("properties");
        if (element != null) {
            return this.getChildrenSize((Node)element, "property");
        }
        return 0;
    }

    @Override
    public int propertiesSize(String name) {
        int count = 0;
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void removeProperty(int index) {
        Property property = this.buildProperty(index);
        property.removeSelf();
    }

    @Override
    public void removeProperty(String name, String value) {
        Property property = (Property)this.getProperty(name, value);
        property.removeSelf();
    }

    @Override
    public void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setCacheType(ExternalPersistenceUnit.CacheType type) {
        this.updateChildTextNode(CACHE_TYPE, type);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode(DESCRIPTION, description);
    }

    @Override
    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.updateChildTextNode(EXCLUDE_UNLISTED_CLASSES, excludeUnlistedClasses);
    }

    @Override
    public void setIncludedClasses(ListIterator<String> classes) {
        this.removeChildren(CLASS);
        while (classes.hasNext()) {
            this.addChildTextNode(CLASS, classes.next());
        }
    }

    @Override
    public void setJarFiles(ListIterator<String> jarFiles) {
        this.removeChildren(JAR_FILE);
        while (jarFiles.hasNext()) {
            this.addChildTextNode(JAR_FILE, jarFiles.next());
        }
    }

    @Override
    public void setJtaDatasource(String jtaDatasource) {
        this.updateChildTextNode(JTA_DATA_SOURCE, jtaDatasource);
    }

    @Override
    public void setMappingFiles(ListIterator<String> mappingFiles) {
        this.removeChildren(MAPPING_FILE);
        while (mappingFiles.hasNext()) {
            this.addChildTextNode(MAPPING_FILE, mappingFiles.next());
        }
    }

    @Override
    public void setName(String name) {
        this.setAttribute(NAME, name);
    }

    @Override
    public void setNonJtaDatasource(String nonJtaDatasource) {
        this.updateChildTextNode(NON_JTA_DATA_SOURCE, nonJtaDatasource);
    }

    @Override
    public void setPessimisticLockTimeout(Integer length) {
        ExternalProperty property = this.getProperty("javax.persistence.lock.timeout");
        if (length == null && property != null) {
            this.removeProperty("javax.persistence.lock.timeout", property.getValue());
        } else if (length != null && property == null) {
            this.addProperty("javax.persistence.lock.timeout", length.toString());
        } else if (length != null && property != null) {
            property.setValue(length.toString());
        }
    }

    @Override
    public void setProvider(String provider) {
        this.updateChildTextNode(PROVIDER, provider);
    }

    @Override
    public void setQueryTimeout(Integer length) {
        ExternalProperty property = this.getProperty("javax.persistence.query.timeout");
        if (length == null && property != null) {
            this.removeProperty("javax.persistence.query.timeout", property.getValue());
        } else if (length != null && property == null) {
            this.addProperty("javax.persistence.query.timeout", length.toString());
        } else if (length != null && property != null) {
            property.setValue(length.toString());
        }
    }

    @Override
    public void setTransactionType(ExternalPersistenceUnit.TransactionType transactionType) {
        this.setAttribute(TRANSACTION_TYPE, transactionType);
    }

    @Override
    public void setValidationMode(ValidationMode type) {
        this.updateChildTextNode(VALIDATION_MODE, (Enum<?>)type);
    }

    @Override
    public boolean shouldExcludeUnlistedClasses() {
        Boolean value = this.getChildBooleanNode(EXCLUDE_UNLISTED_CLASSES);
        return value == null ? false : value;
    }
}

