/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.command;

/**
 * @see AbstractSingleUseQueueingCommandExecutor
 */
public class SingleUseQueueingCommandExecutor
	extends AbstractSingleUseQueueingCommandExecutor<StatefulCommandExecutor>
{
	public SingleUseQueueingCommandExecutor() {
		this(ExtendedCommandExecutor.Default.instance());
	}

	public SingleUseQueueingCommandExecutor(CommandExecutor commandExecutor) {
		this(new SimpleStatefulCommandExecutor(commandExecutor));
	}

	public SingleUseQueueingCommandExecutor(StatefulCommandExecutor commandExecutor) {
		super(commandExecutor);
	}
}