/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.event.ChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.AbstractChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.ChangeListener;

/**
 * Extend {@link ItemAspectListValueModelAdapter} to listen to all of the changes
 * of each item in the wrapped list model.
 */
public class ItemChangeListValueModelAdapter<E>
	extends ItemAspectListValueModelAdapter<E>
{
	/** Listener that listens to all the items in the list. */
	protected final ChangeListener itemChangeListener;


	// ********** constructors **********

	/**
	 * Construct an adapter for the specified items.
	 */
	public ItemChangeListValueModelAdapter(ListValueModel<E> listHolder) {
		super(listHolder);
		this.itemChangeListener = this.buildItemChangeListener();
	}


	// ********** initialization **********

	protected ChangeListener buildItemChangeListener() {
		return new ItemChangeListener();
	}

	protected class ItemChangeListener
		extends AbstractChangeListener
	{
		@Override
		protected void modelChanged(ChangeEvent event) {
			ItemChangeListValueModelAdapter.this.itemAspectChanged(event);
		}
	}


	// ********** behavior **********

	@Override
	protected void engageItem_(Model item) {
		item.addChangeListener(this.itemChangeListener);
	}

	@Override
	protected void disengageItem_(Model item) {
		item.removeChangeListener(this.itemChangeListener);
	}
}