/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.iterable.ListIterable;


/**
 * This interface and inherited behavior describe the configurable properties defined for a stored
 * procedure query in the EclipseLink 1.1 ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.Entity
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalStoredProcedureQuery extends ExternalNamedQuery {

	/**
	 * Adds a query parameter to this stored procedure.
	 */
	ExternalStoredProcedureParameter addParameter(int index);

	/**
	 * Returns whether this procedure returns a result set.
	 */
	Boolean doesReturnResultSet();

	/**
	 * Returns the parameter at the given index.
	 */
	ExternalStoredProcedureParameter getParameter(int index);

	/**
	 * Returns the name of this the stored procedure.
	 */
	String getProcedureName();

	/**
	 * Returns the result set mapping class name.
	 */
	String getResultClassName();

	/**
	 * Returns the result set mapping.
	 */
	String getResultSetMapping();

	/**
	 * Returns all the parameters in this stored procedure.
	 */
	ListIterable<ExternalStoredProcedureParameter> parameters();

	/**
	 * Returns the number of parameters in this stored procedure.
	 */
	int parametersSize();

	/**
	 * Removes the parameter at the specified index from the stored procedure.
	 */
	void removeParameter(int index);

	/**
	 * Sets whether this procedure returns a result set.
	 */
	void setDoesReturnResultSet(Boolean returnResultSet);

	/**
	 * Sets the name of the procedure.
	 */
	void setProcedureName(String name);

	/**
	 * Sets the result mapping class.
	 */
	void setResultClassName(String resultSetMappingClass);

	/**
	 * Sets the result set mapping.
	 */
	void setResultSetMapping(String resultSetMapping);
}