/*******************************************************************************
 * Copyright (c) 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.db;

import java.sql.Connection;
import org.eclipse.persistence.tools.db.model.ELDatabase;
import org.eclipse.persistence.tools.gen.db.ConnectionListener;
import org.eclipse.persistence.tools.gen.db.ConnectionProfile;
import org.eclipse.persistence.tools.gen.db.Database;
import org.eclipse.persistence.tools.utility.status.IStatus;

/**
 * The concrete implementation of {@link ConnectionProfile}.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 */
public class EclipseLinkConnectionProfile implements ConnectionProfile {

	private EclipseLinkDatabase database;
	private ELDatabase mwDatabase;

	public EclipseLinkConnectionProfile(EclipseLinkDatabase database, ELDatabase mwDatabase) {
		super();
		this.database = database;
		this.mwDatabase = mwDatabase;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void addConnectionListener(ConnectionListener listener) {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean canWorkOffline() {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void connect() {
		// NO-OP, always connected.
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void disconnect() {
		// NO-OP, never disconnects.
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ConnectionProfile getConnectionProfile() {
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Database getDatabase() {
		return this.database;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDatabaseName() {
		return getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDatabaseProduct() {
		return getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDatabaseVendor() {
		return this.mwDatabase.getDatabasePlatform().getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDatabaseVersion() {
		return this.mwDatabase.getDatabasePlatform().getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDriverClassName() {
		return this.mwDatabase.getDevelopmentLoginSpec().getDriverClassName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDriverDefinitionID() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDriverJarList() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDriverName() {
		return this.mwDatabase.getDevelopmentLoginSpec().getDriverClassName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getIdentifier() {
		// connection profiles do not have "identifiers"
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getIdentifier(String javaIdentifier) {
		// connection profiles do not have "identifiers"
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getInstanceID() {
		return getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Connection getJDBCConnection() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return database.getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getProviderID() {
		return getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getURL() {
		return this.mwDatabase.getDevelopmentLoginSpec().getURL();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getUserName() {
		return this.mwDatabase.getDevelopmentLoginSpec().getUserName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getUserPassword() {
		return this.mwDatabase.getDevelopmentLoginSpec().getPassword();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isActive() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isConnected() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isDisconnected() {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isInactive() {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isWorkingOffline() {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeConnectionListener(ConnectionListener listener) {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public IStatus saveWorkOfflineData() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean supportsWorkOfflineMode() {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean treatIdentifiersAsDelimited() {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public IStatus workOffline() {
		return null;
	}
}