/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;

public final class LegacyProjectMigrationDialog
extends AbstractDialog {
    private boolean saveLater;

    LegacyProjectMigrationDialog(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.saveLater = false;
    }

    @Override
    protected Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("PROJECT_LEGACY_MIGRATION_DIALOG_TITLE"));
        JLabel iconLabel = new JLabel(this.resourceRepository().getIcon("warning.large"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 10, 0, 0);
        mainPanel.add((Component)iconLabel, constraints);
        LabelArea label = new LabelArea(this.resourceRepository().getString("PROJECT_LEGACY_MIGRATION_DIALOG_WARNING"));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 10, 0, 10);
        mainPanel.add((Component)label, constraints);
        return mainPanel;
    }

    @Override
    protected String helpTopicId() {
        return "dialog.projectLegacyMigration";
    }

    @Override
    protected Component initialFocusComponent() {
        return this.getButtonFor(this.getOKAction());
    }

    @Override
    protected Iterator buildCustomActions() {
        ArrayList<Action> customActions = new ArrayList<Action>();
        customActions.add(this.buildSaveLaterAction());
        return customActions.iterator();
    }

    @Override
    protected String buildOKText() {
        return this.resourceRepository().getString("PROJECT_LEGACY_MIGRATION_DIALOG_SAVE_NOW");
    }

    protected Action buildSaveLaterAction() {
        return new AbstractAction(this.buildSaveLaterText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacyProjectMigrationDialog.this.saveLaterPressed();
            }
        };
    }

    protected String buildSaveLaterText() {
        return this.resourceRepository().getString("PROJECT_LEGACY_MIGRATION_DIALOG_SAVE_LATER");
    }

    protected void saveLaterPressed() {
        this.saveLater = true;
        this.dispose();
    }

    @Override
    public boolean wasConfirmed() {
        return super.wasConfirmed() || this.saveLater;
    }

    public boolean saveLater() {
        return this.saveLater;
    }
}

