/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassIndicatorPolicySubPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RootListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public abstract class InheritancePolicyPropertiesPage
extends ScrollablePropertiesPage {
    protected static final int EDITOR_WEIGHT = 6;
    private PropertyValueModel inheritancePolicyHolder;
    private PropertyValueModel isRootHolder;
    protected ClassIndicatorPolicySubPanel classIndicatorPolicyPanel;

    public InheritancePolicyPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    @Override
    protected void initialize(PropertyValueModel descriptorNodeHolder) {
        super.initialize(descriptorNodeHolder);
        this.inheritancePolicyHolder = this.buildInheritancePolicyHolder();
        this.isRootHolder = this.buildIsRootHolder();
    }

    protected MWMappingDescriptor getDescriptor() {
        return (MWMappingDescriptor)this.getSelectionHolder().getValue();
    }

    protected MWDescriptorInheritancePolicy getInheritancePolicy() {
        return (MWDescriptorInheritancePolicy)this.inheritancePolicyHolder.getValue();
    }

    protected abstract String helpTopicIdPrefix();

    protected String helpTopicId() {
        return this.helpTopicIdPrefix() + ".inheritance";
    }

    protected void addRootListener(final RootListener listener) {
        this.getIsRootHolder().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = Boolean.TRUE.equals(evt.getNewValue());
                listener.updateRootStatus(enabled);
            }
        });
    }

    protected void addAllRootListeners(Collection listeners) {
        for (RootListener listener : listeners) {
            this.addRootListener(listener);
        }
    }

    private void setEverythingEnabled(Container container, boolean enabled) {
        container.setEnabled(enabled);
        for (int index = 0; index < container.getComponentCount(); ++index) {
            Component component = container.getComponent(index);
            component.setEnabled(enabled);
            if (!(component instanceof Container)) continue;
            this.setEverythingEnabled((Container)component, enabled);
        }
    }

    protected PropertyChangeListener buildIsChildListener(final Container container) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = Boolean.FALSE.equals(evt.getNewValue());
                InheritancePolicyPropertiesPage.this.setEverythingEnabled(container, enabled);
            }
        };
    }

    protected RadioButtonModelAdapter buildIsRootParentDescriptorRadioButtonModel(PropertyValueModel isRootHolder) {
        return new RadioButtonModelAdapter(isRootHolder, Boolean.TRUE);
    }

    protected RadioButtonModelAdapter buildIsChildDescriptorRadioButtonModel(PropertyValueModel isRootHolder) {
        return new RadioButtonModelAdapter(isRootHolder, Boolean.FALSE);
    }

    protected PropertyValueModel buildIsRootHolder() {
        return new PropertyAspectAdapter(this.inheritancePolicyHolder, "isRoot"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptorInheritancePolicy)this.subject).isRoot();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWDescriptorInheritancePolicy)this.subject).setIsRoot(((Boolean)value).booleanValue());
            }
        };
    }

    private PropertyValueModel buildProjectHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getProject();
            }
        };
    }

    public static DefaultListChooserDialog.Builder buildParentDescriptorChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("PARENT_DESCRIPTOR_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("PARENT_DESCRIPTOR_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(InheritancePolicyPropertiesPage.buildDescriptorStringConverter());
        return builder;
    }

    private static StringConverter buildDescriptorStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWDescriptor)o).shortName();
            }
        };
    }

    private ListChooser buildParentDescriptorChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildParentDescriptorComboBoxModel(), this.getWorkbenchContextHolder(), MappingComponentFactory.buildDescriptorNodeSelector(this.getWorkbenchContextHolder()), InheritancePolicyPropertiesPage.buildParentDescriptorChooserDialogBuilder());
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new DescriptorCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private CachingComboBoxModel buildParentDescriptorComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildParentDescriptorHolder(), this.inheritancePolicyHolder){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return InheritancePolicyPropertiesPage.this.sortedCandidateParentDescriptors((MWDescriptorInheritancePolicy)subject);
            }
        });
    }

    private PropertyValueModel buildParentDescriptorHolder() {
        return new PropertyAspectAdapter(this.inheritancePolicyHolder, "parentDescriptor"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptorInheritancePolicy)this.subject).getParentDescriptor();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWDescriptorInheritancePolicy)this.subject).setParentDescriptor((MWDescriptor)((MWMappingDescriptor)value));
            }
        };
    }

    private ListIterator sortedCandidateParentDescriptors(MWDescriptorInheritancePolicy inheritancePolicy) {
        return CollectionTools.sort((Iterator)inheritancePolicy.candidateParentDescriptors()).listIterator();
    }

    protected ButtonModel buildIsRootDescriptorCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.isRootHolder);
    }

    private PropertyValueModel buildInheritancePolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "inheritancePolicy"){

            @Override
            protected Object getValueFromSubject() {
                MWInheritancePolicy policy = ((MWMappingDescriptor)this.subject).getInheritancePolicy();
                return policy.isActive() ? policy : null;
            }
        };
    }

    protected JPanel buildIsChildPanel(boolean isChild) {
        JPanel parentDescriptorPanel = new JPanel(new BorderLayout());
        ListChooser parentDescriptorChooser = this.buildParentDescriptorChooser();
        parentDescriptorChooser.setEnabled(isChild);
        JLabel parentDescriptorLabel = this.buildLabel("PARENT_DESC");
        parentDescriptorLabel.setEnabled(isChild);
        parentDescriptorLabel.setLabelFor(parentDescriptorChooser);
        parentDescriptorPanel.add((Component)parentDescriptorLabel, "Before");
        parentDescriptorPanel.add((Component)parentDescriptorChooser, "Center");
        this.addHelpTopicId(parentDescriptorPanel, this.helpTopicId() + ".parentDesc");
        return parentDescriptorPanel;
    }

    protected PropertyValueModel getInheritancePolicyHolder() {
        return this.inheritancePolicyHolder;
    }

    protected PropertyValueModel getIsRootHolder() {
        return this.isRootHolder;
    }

    public ClassIndicatorPolicySubPanel getClassIndicatorPolicyPanel() {
        return this.classIndicatorPolicyPanel;
    }
}

