/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class SCPlatformManager {
    private Map platforms;

    protected SCPlatformManager() {
        this.initialize();
    }

    protected void initialize() {
        this.platforms = new HashMap();
        this.buidPlatforms();
    }

    protected void addPlatform(String id, String platformClassName) {
        this.platforms.put(id, platformClassName);
    }

    protected abstract void buidPlatforms();

    public Iterator platformIds() {
        return this.platforms.keySet().iterator();
    }

    public Iterator platformNames() {
        return this.platforms.values().iterator();
    }

    public Iterator platformShortNames() {
        return new TransformationIterator(this.platformNames()){

            protected Object transform(Object next) {
                return ClassTools.shortNameForClassNamed((String)((String)next));
            }
        };
    }

    public String getRuntimePlatformClassNameForClass(String shortClassName) {
        Iterator i = this.platformNames();
        while (i.hasNext()) {
            String className = (String)i.next();
            if (!className.endsWith(shortClassName)) continue;
            return className;
        }
        throw new IllegalArgumentException("missing database type named: " + shortClassName);
    }

    public String getRuntimePlatformClassNameFor(String key) {
        return (String)this.platforms.get(key);
    }

    public String getIdFor(String shortClassName) {
        for (String key : this.platforms.keySet()) {
            String value = (String)this.platforms.get(key);
            if (!value.endsWith(shortClassName)) continue;
            return key;
        }
        throw new IllegalArgumentException("missing plaform named: " + shortClassName);
    }

    public boolean serverPlatformIsSupported(String className) {
        if (StringTools.stringIsEmpty((String)className)) {
            return false;
        }
        return this.platforms.containsValue(className);
    }

    public int platformsSize() {
        return this.platforms.size();
    }
}

