/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.EisPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.EISLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.XMLLoginAdapter;

public class DataSource {
    private static final int DATABASE_PLATFORM_ID = 1;
    private static final int EIS_PLATFORM_ID = 2;
    private static final int XML_PLATFORM_ID = 3;
    private static final int DEFAULT_PLATFORM_ID = 4;
    private int platformId;
    private String platformName;
    private String platformClassName;

    private DataSource() {
        this.platformClassName = null;
    }

    public DataSource(DatabasePlatform platform) {
        this.initializeDbDs(platform);
    }

    public DataSource(String shortClassName) {
        this.initializeEisDs(shortClassName);
    }

    public static DataSource buildXmlDataSource() {
        DataSource ds = new DataSource();
        ds.initializeXmlDs();
        return ds;
    }

    public static String getClassNameForDatabasePlatform(DatabasePlatform platform) {
        return platform.getRuntimePlatformClassName();
    }

    public static String getClassNameForEisPlatform(String shortClassName) {
        return EisPlatformManager.instance().getRuntimePlatformClassNameForClass(shortClassName);
    }

    public static DataSource buildDefault() {
        DataSource ds = new DataSource();
        ds.initializeDefaultDs();
        return ds;
    }

    public static DataSource buildPreferedDataSourceFor(SCAdapter adapter) {
        String platformName = adapter.preferences().get("platform.database", "Oracle11");
        DatabasePlatform platform = DatabasePlatformRepository.getDefault().platformNamed(platformName);
        return new DataSource(platform);
    }

    private void initializeDbDs(DatabasePlatform platform) {
        this.platformId = 1;
        this.platformName = platform.getName();
        this.platformClassName = platform.getRuntimePlatformClassName();
    }

    private void initializeEisDs(String shortClassName) {
        this.platformId = 2;
        this.platformName = shortClassName;
        this.platformClassName = EisPlatformManager.instance().getRuntimePlatformClassNameFor(shortClassName);
    }

    private void initializeXmlDs() {
        this.platformId = 3;
        this.platformName = "xml-platform";
        this.platformClassName = "oracle.toplink.ox.platform.SAXPlatform";
    }

    private void initializeDefaultDs() {
        this.platformId = 4;
        this.platformName = "default-platform";
    }

    public boolean isDatabase() {
        return this.platformId == 1;
    }

    public boolean isEis() {
        return this.platformId == 2;
    }

    public boolean isXml() {
        return this.platformId == 3;
    }

    public boolean isDefault() {
        return this.platformId == 4;
    }

    public String getName() {
        return this.platformName;
    }

    public String getPlatformClassName() {
        return this.platformClassName;
    }

    LoginAdapter buildLoginAdapter(DatabaseSessionAdapter parent) {
        if (this.isXml()) {
            return new XMLLoginAdapter(parent);
        }
        if (this.isDatabase()) {
            return new DatabaseLoginAdapter(parent);
        }
        if (this.isEis()) {
            return new EISLoginAdapter(parent);
        }
        if (this.isDefault()) {
            return parent.buildDefaultLogin();
        }
        throw new IllegalArgumentException(this.platformName);
    }

    public String toString() {
        return this.getName();
    }
}

