/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWColumnPair
extends MWModel {
    private MWColumnHandle sourceColumnHandle;
    public static final String SOURCE_COLUMN_PROPERTY = "sourceColumn";
    private MWColumnHandle targetColumnHandle;
    public static final String TARGET_COLUMN_PROPERTY = "targetColumn";

    private MWColumnPair() {
    }

    MWColumnPair(MWReference parent, MWColumn sourceColumn, MWColumn targetColumn) {
        super(parent);
        this.sourceColumnHandle.setColumn(sourceColumn);
        this.targetColumnHandle.setColumn(targetColumn);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.sourceColumnHandle = new MWColumnHandle(this, this.buildSourceColumnScrubber());
        this.targetColumnHandle = new MWColumnHandle(this, this.buildTargetColumnScrubber());
    }

    public MWReference getReference() {
        return (MWReference)this.getParent();
    }

    public MWColumn getSourceColumn() {
        return this.sourceColumnHandle.getColumn();
    }

    public void setSourceColumn(MWColumn sourceColumn) {
        if (sourceColumn != null && sourceColumn.getTable() != this.getReference().getSourceTable()) {
            throw new IllegalArgumentException();
        }
        MWColumn old = this.sourceColumnHandle.getColumn();
        this.sourceColumnHandle.setColumn(sourceColumn);
        this.firePropertyChanged(SOURCE_COLUMN_PROPERTY, old, sourceColumn);
    }

    public MWColumn getTargetColumn() {
        return this.targetColumnHandle.getColumn();
    }

    public void setTargetColumn(MWColumn targetColumn) {
        if (targetColumn != null && targetColumn.getTable() != this.getReference().getTargetTable()) {
            throw new IllegalArgumentException();
        }
        MWColumn old = this.targetColumnHandle.getColumn();
        this.targetColumnHandle.setColumn(targetColumn);
        this.firePropertyChanged(TARGET_COLUMN_PROPERTY, old, targetColumn);
    }

    public String getName() {
        StringBuffer sb = new StringBuffer(200);
        this.appendColumn(sb, this.getSourceColumn());
        sb.append('=');
        this.appendColumn(sb, this.getTargetColumn());
        return sb.toString();
    }

    private void appendColumn(StringBuffer sb, MWColumn column) {
        if (column != null) {
            sb.append(column.qualifiedName());
        }
    }

    boolean pairs(MWColumn sourceColumn, MWColumn targetColumn) {
        return this.getSourceColumn() == sourceColumn && this.getTargetColumn() == targetColumn;
    }

    public MWTable sourceTable() {
        return this.tableFrom(this.getSourceColumn());
    }

    public MWTable targetTable() {
        return this.tableFrom(this.getTargetColumn());
    }

    private MWTable tableFrom(MWColumn column) {
        return column == null ? null : column.getTable();
    }

    public void setSourceAndTargetColumns(MWColumn sourceColumn, MWColumn targetColumn) {
        this.setSourceColumn(sourceColumn);
        this.setTargetColumn(targetColumn);
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        if (this.getSourceColumn() == null || this.getTargetColumn() == null) {
            currentProblems.add(this.buildProblem("0704", this.getReference().getName()));
        }
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.sourceColumnHandle);
        children.add(this.targetColumnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildSourceColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWColumnPair.this.setSourceColumn(null);
            }

            public String toString() {
                return "MWColumnPair.buildSourceColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildTargetColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWColumnPair.this.setTargetColumn(null);
            }

            public String toString() {
                return "MWColumnPair.buildTargetColumnScrubber()";
            }
        };
    }

    boolean matches(ExternalForeignKeyColumnPair externalPair) {
        return this.getSourceColumn() == this.sourceColumn(externalPair) && this.getTargetColumn() == this.targetColumn(externalPair);
    }

    private MWColumn sourceColumn(ExternalForeignKeyColumnPair externalPair) {
        return this.getReference().sourceColumn(externalPair);
    }

    private MWColumn targetColumn(ExternalForeignKeyColumnPair externalPair) {
        return this.getReference().targetColumn(externalPair);
    }

    void configureRuntimeConstraint(ForeignKeyConstraint fkc) {
        if (this.getSourceColumn() == null || this.getTargetColumn() == null) {
            return;
        }
        fkc.addSourceField(this.getSourceColumn().getName());
        fkc.addTargetField(this.getTargetColumn().getName());
    }

    @Override
    public String displayString() {
        return this.getName();
    }

    @Override
    public void toString(StringBuffer sb) {
        super.toString(sb);
        this.printColumnNameOn(this.getSourceColumn(), sb);
        sb.append("=>");
        this.printColumnNameOn(this.getTargetColumn(), sb);
    }

    private void printColumnNameOn(MWColumn column, StringBuffer sb) {
        sb.append(column == null ? "null" : column.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWColumnPair.class);
        XMLCompositeObjectMapping sourceColumnHandleMapping = new XMLCompositeObjectMapping();
        sourceColumnHandleMapping.setAttributeName("sourceColumnHandle");
        sourceColumnHandleMapping.setGetMethodName("getSourceColumnHandleForTopLink");
        sourceColumnHandleMapping.setSetMethodName("setSourceColumnHandleForTopLink");
        sourceColumnHandleMapping.setReferenceClass(MWColumnHandle.class);
        sourceColumnHandleMapping.setXPath("source-column-handle");
        descriptor.addMapping((DatabaseMapping)sourceColumnHandleMapping);
        XMLCompositeObjectMapping targetColumnHandleMapping = new XMLCompositeObjectMapping();
        targetColumnHandleMapping.setAttributeName("targetColumnHandle");
        targetColumnHandleMapping.setGetMethodName("getTargetColumnHandleForTopLink");
        targetColumnHandleMapping.setSetMethodName("setTargetColumnHandleForTopLink");
        targetColumnHandleMapping.setReferenceClass(MWColumnHandle.class);
        targetColumnHandleMapping.setXPath("target-column-handle");
        descriptor.addMapping((DatabaseMapping)targetColumnHandleMapping);
        return descriptor;
    }

    private MWColumnHandle getSourceColumnHandleForTopLink() {
        return this.sourceColumnHandle.getColumn() == null ? null : this.sourceColumnHandle;
    }

    private void setSourceColumnHandleForTopLink(MWColumnHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildSourceColumnScrubber();
        this.sourceColumnHandle = handle == null ? new MWColumnHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWColumnHandle getTargetColumnHandleForTopLink() {
        return this.targetColumnHandle.getColumn() == null ? null : this.targetColumnHandle;
    }

    private void setTargetColumnHandleForTopLink(MWColumnHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildTargetColumnScrubber();
        this.targetColumnHandle = handle == null ? new MWColumnHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

