/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.aggregate.Parent;

public class AggregateRelationshipsDirectCollectionTestCase
extends TestCase {
    protected Parent originalParent;
    protected Parent readParent;

    public AggregateRelationshipsDirectCollectionTestCase() {
        this.setDescription("AggregateRelationships: test DirectCollection");
    }

    public void setup() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalParent = new Parent();
        this.originalParent.getAggregate().addNickname("Robby");
        this.originalParent.getAggregate().addNickname("Bobby");
        this.originalParent.getAggregate().addNickname("Nobby");
        this.originalParent.getAggregate().addNickname("Slowpoke");
        uow.registerObject((Object)this.originalParent);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        int id = this.originalParent.getId();
        try {
            this.readParent = (Parent)this.getSession().readObject(Parent.class, new ExpressionBuilder().get("id").equal(id));
        }
        catch (EclipseLinkException exception) {
            this.throwError("An exception occurred whilst reading back a Parent object with id " + id, exception);
        }
    }

    public void verify() {
        AggregateRelationshipsDirectCollectionTestCase.assertNotNull((String)"Parent read back should not be null", (Object)this.readParent);
        this.compareObjects(this.originalParent, this.readParent);
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.originalParent);
        uow.commit();
    }
}

