/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.insurance;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.insurance.Phone;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class ObjectArrayMappingUpdateTest
extends WriteObjectTest {
    PolicyHolder holder;

    public ObjectArrayMappingUpdateTest() {
        this.setDescription("The test add/remove object elements from the VArray type via UnitOfWork and checks if the update works properly");
    }

    protected void removePhone(Vector phones, String type, int areaCode, int number) {
        Enumeration phoneEnum = phones.elements();
        while (phoneEnum.hasMoreElements()) {
            Phone phone = (Phone)phoneEnum.nextElement();
            if (!phone.getType().equals(type) || phone.getAreaCode() != areaCode || phone.getNumber() != number) continue;
            phones.removeElement(phone);
        }
    }

    protected void setup() {
        this.beginTransaction();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holder = (PolicyHolder)uow.readObject(PolicyHolder.class);
        Phone newPhone = new Phone();
        newPhone.setType("Work");
        newPhone.setAreaCode(613);
        newPhone.setNumber(5698855);
        this.holder.addPhone(newPhone);
        this.removePhone(this.holder.getPhones(), "fax", 123, 23456789);
        uow.commit();
    }

    protected void verify() {
        Vector phones = this.holder.getPhones();
        Enumeration phoneEnum = phones.elements();
        while (phoneEnum.hasMoreElements()) {
            Phone phone = (Phone)phoneEnum.nextElement();
            if (phone.getAreaCode() == 613 && phone.getNumber() == 5698855 && phone.getType().equals("Work")) {
                return;
            }
            if (!phone.getType().equals("fax") || phone.getAreaCode() != 123 || phone.getNumber() != 23456789) continue;
            throw new TestException("Remove on ObjectArrayMapping fails!");
        }
        throw new TestException("Insert on ObjectArrayMapping fails!");
    }
}

