/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class DeleteObjectPrivatelyOwningUntriggeredIndirection
extends TestCase {
    BigDecimal id;

    protected void setup() {
        Employee employee = new Employee();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employeeClone = (Employee)uow.registerObject((Object)employee);
        employeeClone.setFirstName("A");
        employeeClone.addPhoneNumber(new PhoneNumber("home", "111", "1111111"));
        employeeClone.addPhoneNumber(new PhoneNumber("work", "222", "2222222"));
        uow.commit();
        this.id = employee.getId();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        Employee employee = (Employee)this.getSession().executeQuery((DatabaseQuery)this.createReadEmployeeQuery());
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)employee);
        uow.commit();
    }

    protected void verify() {
        ReadObjectQuery query = this.createReadEmployeeQuery();
        Employee employee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        if (employee != null) {
            throw new TestErrorException("Deleted Employee is still in the cache");
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        employee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        if (employee != null) {
            throw new TestErrorException("Deleted Employee is still in the db");
        }
        Vector phones = (Vector)this.getSession().executeQuery((DatabaseQuery)this.createReadPhoneNumbersQuery());
        if (!phones.isEmpty()) {
            throw new TestErrorException("Deleted Employee's phones are still in the db");
        }
    }

    public void reset() {
    }

    protected ReadObjectQuery createReadEmployeeQuery() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReadObjectQuery query = new ReadObjectQuery(builder);
        query.setReferenceClass(Employee.class);
        Expression exp = builder.get("id").equal((Object)this.id);
        query.setSelectionCriteria(exp);
        return query;
    }

    protected ReadAllQuery createReadPhoneNumbersQuery() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReadAllQuery query = new ReadAllQuery(builder);
        query.setReferenceClass(PhoneNumber.class);
        Expression exp = builder.get("owner").get("id").equal((Object)this.id);
        query.setSelectionCriteria(exp);
        return query;
    }
}

