/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.persistence.testing.tests.queries.report.Beer;
import org.eclipse.persistence.testing.tests.queries.report.Person;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Bar
implements Cloneable,
Serializable {
    protected String key = null;
    protected String name = null;
    protected Vector beerCollection = null;
    protected Person brewer = null;

    public Bar() {
    }

    public Bar(String name) {
        this.name = name;
    }

    public void addBeer(Beer aBeer) {
        this.getBeerCollection().addElement(aBeer);
        aBeer.getBarCollection().addElement(this);
    }

    public Vector getBeerCollection() {
        if (this.beerCollection == null) {
            this.beerCollection = new Vector();
        }
        return this.beerCollection;
    }

    public String getKey() {
        return this.key;
    }

    public Person getBrewer() {
        return this.brewer;
    }

    public String getName() {
        return this.name;
    }

    public void removeBeer(Beer aBeer) {
        this.getBeerCollection().remove(aBeer);
        aBeer.getBarCollection().remove(this);
    }

    public boolean servesBeer(Beer aBeer) {
        return this.getBeerCollection().contains(aBeer);
    }

    public void setBeerCollection(Vector newBeerCollection) {
        this.beerCollection = newBeerCollection;
    }

    public void setKey(String newKey) {
        this.key = newKey;
    }

    public void setBrewer(Person brewer) {
        this.brewer = brewer;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    private void printSomething() {
        System.out.println("BAR");
    }

    public void go() {
        this.printSomething();
    }

    public Object clone() {
        Bar bar = new Bar();
        bar.key = this.key;
        bar.name = this.name;
        for (int index = 0; index < this.beerCollection.size(); ++index) {
            bar.addBeer((Beer)((Beer)this.beerCollection.get(index)).clone());
        }
        return bar;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition table = new TableDefinition();
        table.setName("BAR");
        table.addField("KEY_BAR", String.class);
        table.addField("TXT_NAME", String.class);
        table.addField("KEY_PERSON", String.class);
        return table;
    }

    public static TableDefinition beerTableDefinition() {
        TableDefinition table = new TableDefinition();
        table.setName("BAR_BEER");
        table.addField("KEY_BAR", String.class);
        table.addField("KEY_BEER", String.class);
        return table;
    }
}

