/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.employee;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.eclipse.persistence.testing.tests.jpa.dynamic.QuerySQLTracker;
import org.eclipse.persistence.testing.tests.jpa.dynamic.employee.DynamicEmployeeSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EmployeeSparseMergeTestSuite {
    static EntityManagerFactory emf = null;
    static JPADynamicHelper helper = null;
    static Server serverSession = null;
    static DynamicEmployeeSystem deSystem = null;
    static QuerySQLTracker qTracker = null;

    @BeforeClass
    public static void setUp() throws Exception {
        emf = DynamicTestHelper.createEMF("dynamic");
        helper = new JPADynamicHelper(emf);
        deSystem = DynamicEmployeeSystem.buildProject((DynamicHelper)helper);
        serverSession = JpaHelper.getServerSession((EntityManagerFactory)emf);
        serverSession.executeNonSelectingSQL("update sequence set SEQ_COUNT = 0 where SEQ_NAME = 'EMP_SEQ'");
        deSystem.populate(helper, emf.createEntityManager());
        serverSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        qTracker = QuerySQLTracker.install((Session)serverSession);
        serverSession.setLogLevel(3);
    }

    @AfterClass
    public static void tearDown() {
        serverSession.executeNonSelectingSQL("DELETE FROM D_PROJ_EMP");
        serverSession.executeNonSelectingSQL("DELETE FROM D_PHONE");
        serverSession.executeNonSelectingSQL("DELETE FROM D_SALARY");
        serverSession.executeNonSelectingSQL("DELETE FROM D_PROJECT");
        serverSession.executeNonSelectingSQL("DELETE FROM D_EMPLOYEE");
        serverSession.executeNonSelectingSQL("DELETE FROM D_ADDRESS");
        try {
            serverSession.executeNonSelectingSQL("DROP TABLE D_SALARY");
            serverSession.executeNonSelectingSQL("DROP TABLE D_PROJ_EMP");
            serverSession.executeNonSelectingSQL("DROP TABLE D_PROJECT");
            serverSession.executeNonSelectingSQL("DROP TABLE D_PHONE");
            serverSession.executeNonSelectingSQL("DROP TABLE D_EMPLOYEE");
            serverSession.executeNonSelectingSQL("DROP TABLE D_ADDRESS");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        helper = null;
        emf.close();
        emf = null;
    }

    @Test
    public void mergeSparseDynamicEntityWithFetchGroup() {
        EntityManager em = emf.createEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        DynamicType employeeType = helper.getType("Employee");
        DynamicEntity sparseEmployee = employeeType.newDynamicEntity();
        EntityFetchGroup efg = new EntityFetchGroup(new String[0]);
        ((FetchGroupTracker)sparseEmployee)._persistence_setFetchGroup((FetchGroup)efg);
        sparseEmployee.set("id", (Object)EmployeeSparseMergeTestSuite.minimumEmployeeId(em));
        sparseEmployee.set("firstName", (Object)"Mike");
        sparseEmployee.set("lastName", (Object)"Norman");
        sparseEmployee.set("salary", (Object)12345);
        em.getTransaction().begin();
        em.merge((Object)sparseEmployee);
        em.getTransaction().commit();
        Assert.assertEquals((String)"Incorrect # of UPDATE calls", (long)2L, (long)qTracker.getTotalSQLUPDATECalls());
    }

    public static int minimumEmployeeId(EntityManager em) {
        return ((Number)em.createQuery("SELECT MIN(e.id) FROM Employee e").getSingleResult()).intValue();
    }
}

