/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.simple.sequencing;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.eclipse.persistence.testing.tests.jpa.dynamic.simple.sequencing.BaseSequencingTestSuite;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;

public class NativeSequencingTestSuite
extends BaseSequencingTestSuite {
    @BeforeClass
    public static void setUp() {
        emf = DynamicTestHelper.createEMF("dynamic");
        Assume.assumeTrue((boolean)JpaHelper.getServerSession((EntityManagerFactory)emf).getPlatform().isMySQL());
        helper = new JPADynamicHelper(emf);
        DynamicClassLoader dcl = helper.getDynamicClassLoader();
        Class javaType = dcl.createDynamicClass("model.sequencing.Simple");
        JPADynamicTypeBuilder typeBuilder = new JPADynamicTypeBuilder(javaType, null, new String[]{"SIMPLE_TABLE_SEQ"});
        typeBuilder.setPrimaryKeyFields(new String[]{"SID"});
        typeBuilder.addDirectMapping("id", Integer.TYPE, "SID");
        typeBuilder.addDirectMapping("value1", String.class, "VAL_1");
        NativeSequence sequence = new NativeSequence();
        sequence.setPreallocationSize(1);
        helper.getSession().getProject().getLogin().setDefaultSequence((Sequence)sequence);
        sequence.onConnect((Platform)helper.getSession().getPlatform());
        typeBuilder.configureSequencing((Sequence)sequence, "Simple_SEQ", "SID");
        helper.addTypes(true, true, new DynamicType[]{typeBuilder.getType()});
    }

    @AfterClass
    public static void tearDown() {
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        try {
            em.createNativeQuery("DROP TABLE SIMPLE_TABLE_SEQ").executeUpdate();
            em.getTransaction().commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        em.close();
        emf.close();
    }

    @Before
    public void clearSimpleTypeInstances() {
        Assume.assumeTrue((boolean)JpaHelper.getServerSession((EntityManagerFactory)emf).getPlatform().isMySQL());
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("DELETE FROM Simple").executeUpdate();
        em.createNativeQuery("ALTER TABLE SIMPLE_TABLE_SEQ DROP COLUMN SID").executeUpdate();
        em.createNativeQuery("ALTER TABLE SIMPLE_TABLE_SEQ ADD COLUMN SID INTEGER PRIMARY KEY AUTO_INCREMENT FIRST").executeUpdate();
        em.close();
        Server session = JpaHelper.getServerSession((EntityManagerFactory)emf);
        new SchemaManager((DatabaseSession)session).replaceSequences();
        session.getSequencingControl().initializePreallocated();
    }
}

