/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.jpa.xml.advanced;

import java.io.Serializable;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Dealer;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Project;

@Properties(value={@Property(name="ToBeOverriddenByXml", value="false", valueType=Boolean.class), @Property(name="ToBeProcessed", value="true", valueType=Boolean.class)})
public class Employee
implements Serializable {
    private int salary;
    private int version;
    private Integer id;
    private String firstName;
    @Property(name="ToBeIgnored", value="true", valueType=Boolean.class)
    private String lastName;
    private Gender gender;
    private Address address;
    private Employee manager;
    private SalaryRate payScale;
    private EmploymentPeriod period;
    private Collection<Employee> managedEmployees;
    private Collection<PhoneNumber> phoneNumbers = new Vector<PhoneNumber>();
    private Collection<Project> projects = new Vector<Project>();
    private Collection<String> responsibilities;
    private List<Dealer> dealers;
    private Map<String, Long> creditCards;
    private static final String AMEX = "Amex";
    private static final String DINERS = "DinersClub";
    private static final String MASTERCARD = "Mastercard";
    private static final String VISA = "Visa";
    private Map<String, Long> creditLines;
    private static final String ROYAL_BANK = "RoyalBank";
    private static final String CANADIAN_IMPERIAL = "CanadianImperial";
    private static final String SCOTIABANK = "Scotiabank";
    private static final String TORONTO_DOMINION = "TorontoDominion";
    private Time[] normalHours;
    private Time[] overtimeHours;
    private String socialInsuranceNumber;
    private int sinChangeCounter = 0;
    private Department department;

    public Employee() {
        this.managedEmployees = new Vector<Employee>();
        this.responsibilities = new Vector<String>();
        this.dealers = new ArrayList<Dealer>();
        this.creditCards = new HashMap<String, Long>();
        this.creditLines = new HashMap<String, Long>();
        this.normalHours = new Time[2];
        this.overtimeHours = new Time[2];
    }

    public Employee(String firstName, String lastName) {
        this();
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public void addAmex(long number) {
        this.getCreditCards().put(AMEX, new Long(number));
    }

    public void addCanadianImperialCreditLine(long number) {
        this.getCreditLines().put(CANADIAN_IMPERIAL, new Long(number));
    }

    public void addDealer(Dealer dealer) {
        this.dealers.add(dealer);
    }

    public void addDinersClub(long number) {
        this.getCreditCards().put(DINERS, new Long(number));
    }

    public void addManagedEmployee(Employee emp) {
        this.getManagedEmployees().add(emp);
        emp.setManager(this);
    }

    public void addMastercard(long number) {
        this.getCreditCards().put(MASTERCARD, new Long(number));
    }

    public void addPhoneNumber(PhoneNumber phone) {
        phone.owner = this;
        this.getPhoneNumbers().add(phone);
    }

    public void addProject(Project theProject) {
        this.getProjects().add(theProject);
    }

    public void addResponsibility(String responsibility) {
        this.getResponsibilities().add(responsibility);
    }

    public void addRoyalBankCreditLine(long number) {
        this.getCreditLines().put(ROYAL_BANK, new Long(number));
    }

    public void addScotiabankCreditLine(long number) {
        this.getCreditLines().put(SCOTIABANK, new Long(number));
    }

    public void addTorontoDominionCreditLine(long number) {
        this.getCreditLines().put(TORONTO_DOMINION, new Long(number));
    }

    public void addVisa(long number) {
        this.getCreditCards().put(VISA, new Long(number));
    }

    public Time[] buildNormalHours(Record row, Session session) {
        Time[] hours = new Time[]{(Time)session.getDatasourcePlatform().convertObject(row.get((Object)"START_TIME"), Time.class), (Time)session.getDatasourcePlatform().convertObject(row.get((Object)"END_TIME"), Time.class)};
        return hours;
    }

    public String displayString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("Employee ").append(this.getId()).append(": ").append(this.getLastName()).append(", ").append(this.getFirstName()).append(this.getSalary());
        return sbuff.toString();
    }

    public void enterSIN(String socialInsuranceNumber) {
        ++this.sinChangeCounter;
        this.socialInsuranceNumber = socialInsuranceNumber;
    }

    public static void getAbsolutelyNothing() {
    }

    public Address getAddress() {
        return this.address;
    }

    public String getAnEmptyString() {
        return "";
    }

    @Transient
    public Map<String, Long> getCreditCards() {
        return this.creditCards;
    }

    @Transient
    public Map<String, Long> getCreditLines() {
        return this.creditLines;
    }

    public List<Dealer> getDealers() {
        return this.dealers;
    }

    @Transient
    public Department getDepartment() {
        return this.department;
    }

    @Transient
    public Time getEndOvertime() {
        return this.getOvertimeHours()[1];
    }

    @Transient
    public Time getEndTime() {
        return this.getNormalHours()[1];
    }

    public String getFirstName() {
        return this.firstName;
    }

    public Gender getGender() {
        return this.gender;
    }

    public Integer getId() {
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Collection<Employee> getManagedEmployees() {
        return this.managedEmployees;
    }

    public Employee getManager() {
        return this.manager;
    }

    @Transient
    protected Time[] getNormalHours() {
        return this.normalHours;
    }

    @Transient
    protected Time[] getOvertimeHours() {
        return this.overtimeHours;
    }

    public SalaryRate getPayScale() {
        return this.payScale;
    }

    public EmploymentPeriod getPeriod() {
        return this.period;
    }

    public Collection<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public Collection<Project> getProjects() {
        return this.projects;
    }

    public Collection getResponsibilities() {
        return this.responsibilities;
    }

    public int getSalary() {
        return this.salary;
    }

    @Transient
    public Time getStartOvertime() {
        return this.getOvertimeHours()[0];
    }

    @Transient
    public Time getStartTime() {
        return this.getNormalHours()[0];
    }

    public int getVersion() {
        return this.version;
    }

    public String getYourStringBack(String str) {
        return str;
    }

    public boolean hasAmex(long number) {
        return this.hasCard(this.creditCards.get(AMEX), number);
    }

    public boolean hasCanadianImperialCreditLine(long number) {
        return this.hasCreditLine(this.creditLines.get(CANADIAN_IMPERIAL), number);
    }

    private boolean hasCard(Long cardNumber, long number) {
        if (cardNumber == null) {
            return false;
        }
        return cardNumber == number;
    }

    private boolean hasCreditLine(Long creditLineNumber, long number) {
        if (creditLineNumber == null) {
            return false;
        }
        return creditLineNumber == number;
    }

    public boolean hasDinersClub(long number) {
        return this.hasCard(this.creditCards.get(DINERS), number);
    }

    public boolean hasMastercard(long number) {
        return this.hasCard(this.creditCards.get(MASTERCARD), number);
    }

    public boolean hasRoyalBankCreditLine(long number) {
        return this.hasCreditLine(this.creditLines.get(ROYAL_BANK), number);
    }

    public boolean hasScotiabankCreditLine(long number) {
        return this.hasCreditLine(this.creditLines.get(SCOTIABANK), number);
    }

    public boolean hasTorontoDominionCreditLine(long number) {
        return this.hasCreditLine(this.creditLines.get(TORONTO_DOMINION), number);
    }

    public boolean hasVisa(long number) {
        return this.hasCard(this.creditCards.get(VISA), number);
    }

    public boolean isFemale() {
        return this.gender.equals((Object)Gender.Female);
    }

    public boolean isMale() {
        return this.gender.equals((Object)Gender.Male);
    }

    public void removeDealer(Dealer dealer) {
        this.dealers.remove(dealer);
    }

    public void removeManagedEmployee(Employee emp) {
        this.getManagedEmployees().remove(emp);
    }

    public void removePhoneNumber(PhoneNumber phone) {
        this.getPhoneNumbers().remove(phone);
    }

    public void removeProject(Project theProject) {
        this.getProjects().remove(theProject);
    }

    public void removeResponsibility(String responsibility) {
        this.getResponsibilities().remove(responsibility);
    }

    public String returnSIN() {
        return this.socialInsuranceNumber;
    }

    public int returnSinChangeCounter() {
        return this.sinChangeCounter;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    protected void setCreditCards(Map<String, Long> creditCards) {
        this.creditCards = creditCards;
    }

    protected void setCreditLines(Map<String, Long> creditLines) {
        this.creditLines = creditLines;
    }

    public void setDealers(List<Dealer> dealers) {
        this.dealers = dealers;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public void setEndOvertime(Time endOvertime) {
        Time[] newOvertimeHours = new Time[]{this.getStartOvertime(), endOvertime};
        this.setOvertimeHours(newOvertimeHours);
    }

    public void setEndTime(Time endTime) {
        Time[] newNormalHours = new Time[]{this.getStartTime(), endTime};
        this.setNormalHours(newNormalHours);
    }

    public void setFemale() {
        this.gender = Gender.Female;
    }

    public void setGivenName(String name) {
        this.firstName = name;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setFamilyName(String name) {
        this.lastName = name;
    }

    public void setMale() {
        this.gender = Gender.Male;
    }

    public void setManagedEmployees(Collection<Employee> managedEmployees) {
        this.managedEmployees = managedEmployees;
    }

    public void setManager(Employee manager) {
        this.manager = manager;
    }

    public void setNormalHours(Time[] normalHours) {
        this.normalHours = normalHours;
    }

    public void setOvertimeHours(Time[] overtimeHours) {
        this.overtimeHours = overtimeHours;
    }

    public void setPayScale(SalaryRate payScale) {
        this.payScale = payScale;
    }

    public void setPeriod(EmploymentPeriod period) {
        this.period = period;
    }

    public void setPhoneNumbers(Collection<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public void setProjects(Collection<Project> projects) {
        this.projects = projects;
    }

    public void setResponsibilities(Collection<String> responsibilities) {
        this.responsibilities = responsibilities;
    }

    public void setSalary(int salary) {
        this.salary = salary;
    }

    public void setStartOvertime(Time startOvertime) {
        Time[] newOvertimeHours = new Time[]{startOvertime, this.getEndOvertime()};
        this.setOvertimeHours(newOvertimeHours);
    }

    public void setStartTime(Time startTime) {
        Time[] newNormalHours = new Time[]{startTime, this.getEndTime()};
        this.setNormalHours(newNormalHours);
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public String toString() {
        return "Employee: " + this.getId();
    }

    public static enum SalaryRate {
        JUNIOR,
        SENIOR,
        MANAGER,
        EXECUTIVE;

    }

    public static enum Gender {
        Female,
        Male;

    }
}

