/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.io.CompositeOutputStream;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class CompositeOutputStreamTests
extends TestCase {
    private OutputStream out1;
    private OutputStream out2;
    private OutputStream tee;

    public CompositeOutputStreamTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.out1 = new ByteArrayOutputStream();
        this.out2 = new ByteArrayOutputStream();
        this.tee = new CompositeOutputStream(new OutputStream[]{this.out1, this.out2});
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testWrite() throws Exception {
        String string = "The quick brown fox jumps over the lazy dog.";
        this.tee.write(string.getBytes());
        CompositeOutputStreamTests.assertEquals((String)string, (String)this.out1.toString());
        CompositeOutputStreamTests.assertNotSame((Object)string, (Object)this.out1.toString());
        CompositeOutputStreamTests.assertEquals((String)string, (String)this.out2.toString());
        CompositeOutputStreamTests.assertNotSame((Object)string, (Object)this.out2.toString());
    }
}

